"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cognito_generated_1 = require("../cognito.generated");
const base_1 = require("./base");
/**
 * Represents a identity provider that integrates with 'Facebook Login'
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
class UserPoolIdentityProviderFacebook extends base_1.UserPoolIdentityProviderBase {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, props);
        const scopes = (_a = props.scopes) !== null && _a !== void 0 ? _a : ['public_profile'];
        const resource = new cognito_generated_1.CfnUserPoolIdentityProvider(this, 'Resource', {
            userPoolId: props.userPool.userPoolId,
            providerName: 'Facebook',
            providerType: 'Facebook',
            providerDetails: {
                client_id: props.clientId,
                client_secret: props.clientSecret,
                authorize_scopes: scopes.join(','),
                api_version: props.apiVersion,
            },
        });
        this.providerName = super.getResourceNameAttribute(resource.ref);
    }
}
exports.UserPoolIdentityProviderFacebook = UserPoolIdentityProviderFacebook;
//# sourceMappingURL=data:application/json;base64,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