"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
function arnForApplication(applicationName) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:application:${applicationName}`;
}
exports.arnForApplication = arnForApplication;
function arnForDeploymentGroup(applicationName, deploymentGroupName) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentgroup:${applicationName}/${deploymentGroupName}`;
}
exports.arnForDeploymentGroup = arnForDeploymentGroup;
function arnForDeploymentConfig(name) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentconfig:${name}`;
}
exports.arnForDeploymentConfig = arnForDeploymentConfig;
function renderAlarmConfiguration(alarms, ignorePollAlarmFailure) {
    return alarms.length === 0
        ? undefined
        : {
            alarms: alarms.map(a => ({ name: a.alarmName })),
            enabled: true,
            ignorePollAlarmFailure,
        };
}
exports.renderAlarmConfiguration = renderAlarmConfiguration;
var AutoRollbackEvent;
(function (AutoRollbackEvent) {
    AutoRollbackEvent["DEPLOYMENT_FAILURE"] = "DEPLOYMENT_FAILURE";
    AutoRollbackEvent["DEPLOYMENT_STOP_ON_ALARM"] = "DEPLOYMENT_STOP_ON_ALARM";
    AutoRollbackEvent["DEPLOYMENT_STOP_ON_REQUEST"] = "DEPLOYMENT_STOP_ON_REQUEST";
})(AutoRollbackEvent || (AutoRollbackEvent = {}));
function renderAutoRollbackConfiguration(alarms, autoRollbackConfig = {}) {
    const events = new Array();
    // we roll back failed deployments by default
    if (autoRollbackConfig.failedDeployment !== false) {
        events.push(AutoRollbackEvent.DEPLOYMENT_FAILURE);
    }
    // we _do not_ roll back stopped deployments by default
    if (autoRollbackConfig.stoppedDeployment === true) {
        events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_REQUEST);
    }
    // we _do not_ roll back alarm-triggering deployments by default
    // unless the Deployment Group has at least one alarm
    if (autoRollbackConfig.deploymentInAlarm !== false) {
        if (alarms.length > 0) {
            events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_ALARM);
        }
        else if (autoRollbackConfig.deploymentInAlarm === true) {
            throw new Error("The auto-rollback setting 'deploymentInAlarm' does not have any effect unless you associate " +
                'at least one CloudWatch alarm with the Deployment Group');
        }
    }
    return events.length > 0
        ? {
            enabled: true,
            events,
        }
        : undefined;
}
exports.renderAutoRollbackConfiguration = renderAutoRollbackConfiguration;
//# sourceMappingURL=data:application/json;base64,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