"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const codedeploy_generated_1 = require("../codedeploy.generated");
const utils_1 = require("../utils");
/**
 * A CodeDeploy Application that deploys to an Amazon ECS service.
 *
 * @resource AWS::CodeDeploy::Application
 */
class EcsApplication extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.applicationName,
        });
        const resource = new codedeploy_generated_1.CfnApplication(this, 'Resource', {
            applicationName: this.physicalName,
            computePlatform: 'ECS',
        });
        this.applicationName = this.getResourceNameAttribute(resource.ref);
        this.applicationArn = this.getResourceArnAttribute(utils_1.arnForApplication(resource.ref), {
            service: 'codedeploy',
            resource: 'application',
            resourceName: this.physicalName,
            sep: ':',
        });
    }
    /**
     * Import an Application defined either outside the CDK, or in a different CDK Stack.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param ecsApplicationName the name of the application to import
     * @returns a Construct representing a reference to an existing Application
     */
    static fromEcsApplicationName(scope, id, ecsApplicationName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.applicationArn = utils_1.arnForApplication(ecsApplicationName);
                this.applicationName = ecsApplicationName;
            }
        }
        return new Import(scope, id);
    }
}
exports.EcsApplication = EcsApplication;
//# sourceMappingURL=data:application/json;base64,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