"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * FileSystemLocation provider definition for a CodeBuild Project.
 */
class FileSystemLocation {
    /**
     * EFS file system provider.
     * @param props the EFS File System location property.
     */
    static efs(props) {
        return new EfsFileSystemLocation(props);
    }
}
exports.FileSystemLocation = FileSystemLocation;
/**
 * EfsFileSystemLocation definition for a CodeBuild project.
 */
class EfsFileSystemLocation {
    constructor(props) {
        this.props = props;
    }
    bind(_scope, _project) {
        return {
            location: {
                identifier: this.props.identifier,
                location: this.props.location,
                mountOptions: this.props.mountOptions,
                mountPoint: this.props.mountPoint,
                type: 'EFS',
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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