"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The width of the grid we're filling
 */
exports.GRID_WIDTH = 24;
/**
 * A real CloudWatch widget that has its own fixed size and remembers its position
 *
 * This is in contrast to other widgets which exist for layout purposes.
 */
class ConcreteWidget {
    constructor(width, height) {
        this.width = width;
        this.height = height;
        if (this.width > exports.GRID_WIDTH) {
            throw new Error(`Widget is too wide, max ${exports.GRID_WIDTH} units allowed`);
        }
    }
    position(x, y) {
        this.x = x;
        this.y = y;
    }
}
exports.ConcreteWidget = ConcreteWidget;
//# sourceMappingURL=data:application/json;base64,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