"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const widget_1 = require("./widget");
/**
 * Display query results from Logs Insights
 */
class LogQueryWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 6);
        this.props = props;
        if (props.logGroupNames.length === 0) {
            throw new Error('Specify at least one log group name.');
        }
        if (!!props.queryString === !!props.queryLines) {
            throw new Error('Specify exactly one of \'queryString\' and \'queryLines\'');
        }
    }
    toJson() {
        const sources = this.props.logGroupNames.map(l => `SOURCE '${l}'`).join(' | ');
        const query = this.props.queryLines
            ? this.props.queryLines.join('\n| ')
            : this.props.queryString;
        return [{
                type: 'log',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    view: 'table',
                    title: this.props.title,
                    region: this.props.region || cdk.Aws.REGION,
                    query: `${sources} | ${query}`,
                },
            }];
    }
}
exports.LogQueryWidget = LogQueryWidget;
//# sourceMappingURL=data:application/json;base64,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