"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cloudwatch_generated_1 = require("./cloudwatch.generated");
const layout_1 = require("./layout");
/**
 * Specify the period for graphs when the CloudWatch dashboard loads
 */
var PeriodOverride;
(function (PeriodOverride) {
    /**
     * Period of all graphs on the dashboard automatically adapt to the time range of the dashboard.
     */
    PeriodOverride["AUTO"] = "auto";
    /**
     * Period set for each graph will be used
     */
    PeriodOverride["INHERIT"] = "inherit";
})(PeriodOverride = exports.PeriodOverride || (exports.PeriodOverride = {}));
/**
 * A CloudWatch dashboard
 */
class Dashboard extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.dashboardName,
        });
        this.rows = [];
        {
            const { dashboardName } = props;
            if (dashboardName && !core_1.Token.isUnresolved(dashboardName) && !dashboardName.match(/^[\w-]+$/)) {
                throw new Error([
                    `The value ${dashboardName} for field dashboardName contains invalid characters.`,
                    'It can only contain alphanumerics, dash (-) and underscore (_).',
                ].join(' '));
            }
        }
        new cloudwatch_generated_1.CfnDashboard(this, 'Resource', {
            dashboardName: this.physicalName,
            dashboardBody: core_1.Lazy.stringValue({ produce: () => {
                    const column = new layout_1.Column(...this.rows);
                    column.position(0, 0);
                    return core_1.Stack.of(this).toJsonString({
                        start: props.start,
                        end: props.end,
                        periodOverride: props.periodOverride,
                        widgets: column.toJson(),
                    });
                } }),
        });
        (props.widgets || []).forEach(row => {
            this.addWidgets(...row);
        });
    }
    /**
     * Add a widget to the dashboard.
     *
     * Widgets given in multiple calls to add() will be laid out stacked on
     * top of each other.
     *
     * Multiple widgets added in the same call to add() will be laid out next
     * to each other.
     */
    addWidgets(...widgets) {
        if (widgets.length === 0) {
            return;
        }
        const w = widgets.length > 1 ? new layout_1.Row(...widgets) : widgets[0];
        this.rows.push(w);
    }
}
exports.Dashboard = Dashboard;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGFzaGJvYXJkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZGFzaGJvYXJkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQXFFLENBQUMsZ0RBQWdEO0FBQ3RILGlFQUFzRDtBQUN0RCxxQ0FBdUM7QUFFdkM7O0dBRUc7QUFDSCxJQUFZLGNBU1g7QUFURCxXQUFZLGNBQWM7SUFDdEI7O09BRUc7SUFDSCwrQkFBYSxDQUFBO0lBQ2I7O09BRUc7SUFDSCxxQ0FBbUIsQ0FBQTtBQUN2QixDQUFDLEVBVFcsY0FBYyxHQUFkLHNCQUFjLEtBQWQsc0JBQWMsUUFTekI7QUFpREQ7O0dBRUc7QUFDSCxNQUFhLFNBQVUsU0FBUSxlQUFRO0lBRW5DLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBd0IsRUFBRTtRQUNoRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNiLFlBQVksRUFBRSxLQUFLLENBQUMsYUFBYTtTQUNwQyxDQUFDLENBQUM7UUFKVSxTQUFJLEdBQWMsRUFBRSxDQUFDO1FBS2xDO1lBQ0ksTUFBTSxFQUFFLGFBQWEsRUFBRSxHQUFHLEtBQUssQ0FBQztZQUNoQyxJQUFJLGFBQWEsSUFBSSxDQUFDLFlBQUssQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxFQUFFO2dCQUN6RixNQUFNLElBQUksS0FBSyxDQUFDO29CQUNaLGFBQWEsYUFBYSx1REFBdUQ7b0JBQ2pGLGlFQUFpRTtpQkFDcEUsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQzthQUNoQjtTQUNKO1FBQ0QsSUFBSSxtQ0FBWSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDL0IsYUFBYSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQ2hDLGFBQWEsRUFBRSxXQUFJLENBQUMsV0FBVyxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRTtvQkFDeEMsTUFBTSxNQUFNLEdBQUcsSUFBSSxlQUFNLENBQUMsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7b0JBQ3hDLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO29CQUN0QixPQUFPLFlBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsWUFBWSxDQUFDO3dCQUMvQixLQUFLLEVBQUUsS0FBSyxDQUFDLEtBQUs7d0JBQ2xCLEdBQUcsRUFBRSxLQUFLLENBQUMsR0FBRzt3QkFDZCxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7d0JBQ3BDLE9BQU8sRUFBRSxNQUFNLENBQUMsTUFBTSxFQUFFO3FCQUMzQixDQUFDLENBQUM7Z0JBQ1AsQ0FBQyxFQUFFLENBQUM7U0FDWCxDQUFDLENBQUM7UUFDSCxDQUFDLEtBQUssQ0FBQyxPQUFPLElBQUksRUFBRSxDQUFDLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxFQUFFO1lBQ2hDLElBQUksQ0FBQyxVQUFVLENBQUMsR0FBRyxHQUFHLENBQUMsQ0FBQztRQUM1QixDQUFDLENBQUMsQ0FBQztJQUNQLENBQUM7SUFDRDs7Ozs7Ozs7T0FRRztJQUNJLFVBQVUsQ0FBQyxHQUFHLE9BQWtCO1FBQ25DLElBQUksT0FBTyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7WUFDdEIsT0FBTztTQUNWO1FBQ0QsTUFBTSxDQUFDLEdBQUcsT0FBTyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksWUFBRyxDQUFDLEdBQUcsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNoRSxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN0QixDQUFDO0NBQ0o7QUFoREQsOEJBZ0RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0LCBMYXp5LCBSZXNvdXJjZSwgU3RhY2ssIFRva2VuIH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBDZm5EYXNoYm9hcmQgfSBmcm9tICcuL2Nsb3Vkd2F0Y2guZ2VuZXJhdGVkJztcbmltcG9ydCB7IENvbHVtbiwgUm93IH0gZnJvbSAnLi9sYXlvdXQnO1xuaW1wb3J0IHsgSVdpZGdldCB9IGZyb20gJy4vd2lkZ2V0Jztcbi8qKlxuICogU3BlY2lmeSB0aGUgcGVyaW9kIGZvciBncmFwaHMgd2hlbiB0aGUgQ2xvdWRXYXRjaCBkYXNoYm9hcmQgbG9hZHNcbiAqL1xuZXhwb3J0IGVudW0gUGVyaW9kT3ZlcnJpZGUge1xuICAgIC8qKlxuICAgICAqIFBlcmlvZCBvZiBhbGwgZ3JhcGhzIG9uIHRoZSBkYXNoYm9hcmQgYXV0b21hdGljYWxseSBhZGFwdCB0byB0aGUgdGltZSByYW5nZSBvZiB0aGUgZGFzaGJvYXJkLlxuICAgICAqL1xuICAgIEFVVE8gPSAnYXV0bycsXG4gICAgLyoqXG4gICAgICogUGVyaW9kIHNldCBmb3IgZWFjaCBncmFwaCB3aWxsIGJlIHVzZWRcbiAgICAgKi9cbiAgICBJTkhFUklUID0gJ2luaGVyaXQnXG59XG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgQ2xvdWRXYXRjaCBEYXNoYm9hcmRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBEYXNoYm9hcmRQcm9wcyB7XG4gICAgLyoqXG4gICAgICogTmFtZSBvZiB0aGUgZGFzaGJvYXJkLlxuICAgICAqXG4gICAgICogSWYgc2V0LCBtdXN0IG9ubHkgY29udGFpbiBhbHBoYW51bWVyaWNzLCBkYXNoICgtKSBhbmQgdW5kZXJzY29yZSAoXylcbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gYXV0b21hdGljYWxseSBnZW5lcmF0ZWQgbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRhc2hib2FyZE5hbWU/OiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIHN0YXJ0IG9mIHRoZSB0aW1lIHJhbmdlIHRvIHVzZSBmb3IgZWFjaCB3aWRnZXQgb24gdGhlIGRhc2hib2FyZC5cbiAgICAgKiBZb3UgY2FuIHNwZWNpZnkgc3RhcnQgd2l0aG91dCBzcGVjaWZ5aW5nIGVuZCB0byBzcGVjaWZ5IGEgcmVsYXRpdmUgdGltZSByYW5nZSB0aGF0IGVuZHMgd2l0aCB0aGUgY3VycmVudCB0aW1lLlxuICAgICAqIEluIHRoaXMgY2FzZSwgdGhlIHZhbHVlIG9mIHN0YXJ0IG11c3QgYmVnaW4gd2l0aCAtUCwgYW5kIHlvdSBjYW4gdXNlIE0sIEgsIEQsIFcgYW5kIE0gYXMgYWJicmV2aWF0aW9ucyBmb3JcbiAgICAgKiBtaW51dGVzLCBob3VycywgZGF5cywgd2Vla3MgYW5kIG1vbnRocy4gRm9yIGV4YW1wbGUsIC1QVDhIIHNob3dzIHRoZSBsYXN0IDggaG91cnMgYW5kIC1QM00gc2hvd3MgdGhlIGxhc3QgdGhyZWUgbW9udGhzLlxuICAgICAqIFlvdSBjYW4gYWxzbyB1c2Ugc3RhcnQgYWxvbmcgd2l0aCBhbiBlbmQgZmllbGQsIHRvIHNwZWNpZnkgYW4gYWJzb2x1dGUgdGltZSByYW5nZS5cbiAgICAgKiBXaGVuIHNwZWNpZnlpbmcgYW4gYWJzb2x1dGUgdGltZSByYW5nZSwgdXNlIHRoZSBJU08gODYwMSBmb3JtYXQuIEZvciBleGFtcGxlLCAyMDE4LTEyLTE3VDA2OjAwOjAwLjAwMFouXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBXaGVuIHRoZSBkYXNoYm9hcmQgbG9hZHMsIHRoZSBzdGFydCB0aW1lIHdpbGwgYmUgdGhlIGRlZmF1bHQgdGltZSByYW5nZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBzdGFydD86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBUaGUgZW5kIG9mIHRoZSB0aW1lIHJhbmdlIHRvIHVzZSBmb3IgZWFjaCB3aWRnZXQgb24gdGhlIGRhc2hib2FyZCB3aGVuIHRoZSBkYXNoYm9hcmQgbG9hZHMuXG4gICAgICogSWYgeW91IHNwZWNpZnkgYSB2YWx1ZSBmb3IgZW5kLCB5b3UgbXVzdCBhbHNvIHNwZWNpZnkgYSB2YWx1ZSBmb3Igc3RhcnQuXG4gICAgICogU3BlY2lmeSBhbiBhYnNvbHV0ZSB0aW1lIGluIHRoZSBJU08gODYwMSBmb3JtYXQuIEZvciBleGFtcGxlLCAyMDE4LTEyLTE3VDA2OjAwOjAwLjAwMFouXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBXaGVuIHRoZSBkYXNoYm9hcmQgbG9hZHMsIHRoZSBlbmQgZGF0ZSB3aWxsIGJlIHRoZSBjdXJyZW50IHRpbWUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZW5kPzogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFVzZSB0aGlzIGZpZWxkIHRvIHNwZWNpZnkgdGhlIHBlcmlvZCBmb3IgdGhlIGdyYXBocyB3aGVuIHRoZSBkYXNoYm9hcmQgbG9hZHMuXG4gICAgICogU3BlY2lmeWluZyBgQXV0b2AgY2F1c2VzIHRoZSBwZXJpb2Qgb2YgYWxsIGdyYXBocyBvbiB0aGUgZGFzaGJvYXJkIHRvIGF1dG9tYXRpY2FsbHkgYWRhcHQgdG8gdGhlIHRpbWUgcmFuZ2Ugb2YgdGhlIGRhc2hib2FyZC5cbiAgICAgKiBTcGVjaWZ5aW5nIGBJbmhlcml0YCBlbnN1cmVzIHRoYXQgdGhlIHBlcmlvZCBzZXQgZm9yIGVhY2ggZ3JhcGggaXMgYWx3YXlzIG9iZXllZC5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IEF1dG9cbiAgICAgKi9cbiAgICByZWFkb25seSBwZXJpb2RPdmVycmlkZT86IFBlcmlvZE92ZXJyaWRlO1xuICAgIC8qKlxuICAgICAqIEluaXRpYWwgc2V0IG9mIHdpZGdldHMgb24gdGhlIGRhc2hib2FyZFxuICAgICAqXG4gICAgICogT25lIGFycmF5IHJlcHJlc2VudHMgYSByb3cgb2Ygd2lkZ2V0cy5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gTm8gd2lkZ2V0c1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHdpZGdldHM/OiBJV2lkZ2V0W11bXTtcbn1cbi8qKlxuICogQSBDbG91ZFdhdGNoIGRhc2hib2FyZFxuICovXG5leHBvcnQgY2xhc3MgRGFzaGJvYXJkIGV4dGVuZHMgUmVzb3VyY2Uge1xuICAgIHByaXZhdGUgcmVhZG9ubHkgcm93czogSVdpZGdldFtdID0gW107XG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IERhc2hib2FyZFByb3BzID0ge30pIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICAgICAgICBwaHlzaWNhbE5hbWU6IHByb3BzLmRhc2hib2FyZE5hbWUsXG4gICAgICAgIH0pO1xuICAgICAgICB7XG4gICAgICAgICAgICBjb25zdCB7IGRhc2hib2FyZE5hbWUgfSA9IHByb3BzO1xuICAgICAgICAgICAgaWYgKGRhc2hib2FyZE5hbWUgJiYgIVRva2VuLmlzVW5yZXNvbHZlZChkYXNoYm9hcmROYW1lKSAmJiAhZGFzaGJvYXJkTmFtZS5tYXRjaCgvXltcXHctXSskLykpIHtcbiAgICAgICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoW1xuICAgICAgICAgICAgICAgICAgICBgVGhlIHZhbHVlICR7ZGFzaGJvYXJkTmFtZX0gZm9yIGZpZWxkIGRhc2hib2FyZE5hbWUgY29udGFpbnMgaW52YWxpZCBjaGFyYWN0ZXJzLmAsXG4gICAgICAgICAgICAgICAgICAgICdJdCBjYW4gb25seSBjb250YWluIGFscGhhbnVtZXJpY3MsIGRhc2ggKC0pIGFuZCB1bmRlcnNjb3JlIChfKS4nLFxuICAgICAgICAgICAgICAgIF0uam9pbignICcpKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICBuZXcgQ2ZuRGFzaGJvYXJkKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgICAgICAgIGRhc2hib2FyZE5hbWU6IHRoaXMucGh5c2ljYWxOYW1lLFxuICAgICAgICAgICAgZGFzaGJvYXJkQm9keTogTGF6eS5zdHJpbmdWYWx1ZSh7IHByb2R1Y2U6ICgpID0+IHtcbiAgICAgICAgICAgICAgICAgICAgY29uc3QgY29sdW1uID0gbmV3IENvbHVtbiguLi50aGlzLnJvd3MpO1xuICAgICAgICAgICAgICAgICAgICBjb2x1bW4ucG9zaXRpb24oMCwgMCk7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiBTdGFjay5vZih0aGlzKS50b0pzb25TdHJpbmcoe1xuICAgICAgICAgICAgICAgICAgICAgICAgc3RhcnQ6IHByb3BzLnN0YXJ0LFxuICAgICAgICAgICAgICAgICAgICAgICAgZW5kOiBwcm9wcy5lbmQsXG4gICAgICAgICAgICAgICAgICAgICAgICBwZXJpb2RPdmVycmlkZTogcHJvcHMucGVyaW9kT3ZlcnJpZGUsXG4gICAgICAgICAgICAgICAgICAgICAgICB3aWRnZXRzOiBjb2x1bW4udG9Kc29uKCksXG4gICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgIH0gfSksXG4gICAgICAgIH0pO1xuICAgICAgICAocHJvcHMud2lkZ2V0cyB8fCBbXSkuZm9yRWFjaChyb3cgPT4ge1xuICAgICAgICAgICAgdGhpcy5hZGRXaWRnZXRzKC4uLnJvdyk7XG4gICAgICAgIH0pO1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBBZGQgYSB3aWRnZXQgdG8gdGhlIGRhc2hib2FyZC5cbiAgICAgKlxuICAgICAqIFdpZGdldHMgZ2l2ZW4gaW4gbXVsdGlwbGUgY2FsbHMgdG8gYWRkKCkgd2lsbCBiZSBsYWlkIG91dCBzdGFja2VkIG9uXG4gICAgICogdG9wIG9mIGVhY2ggb3RoZXIuXG4gICAgICpcbiAgICAgKiBNdWx0aXBsZSB3aWRnZXRzIGFkZGVkIGluIHRoZSBzYW1lIGNhbGwgdG8gYWRkKCkgd2lsbCBiZSBsYWlkIG91dCBuZXh0XG4gICAgICogdG8gZWFjaCBvdGhlci5cbiAgICAgKi9cbiAgICBwdWJsaWMgYWRkV2lkZ2V0cyguLi53aWRnZXRzOiBJV2lkZ2V0W10pIHtcbiAgICAgICAgaWYgKHdpZGdldHMubGVuZ3RoID09PSAwKSB7XG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cbiAgICAgICAgY29uc3QgdyA9IHdpZGdldHMubGVuZ3RoID4gMSA/IG5ldyBSb3coLi4ud2lkZ2V0cykgOiB3aWRnZXRzWzBdO1xuICAgICAgICB0aGlzLnJvd3MucHVzaCh3KTtcbiAgICB9XG59XG4iXX0=