"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Use an AutoScaling StepScalingAction as an Alarm Action
 */
class AutoScalingAction {
    constructor(stepScalingAction) {
        this.stepScalingAction = stepScalingAction;
    }
    /**
     * Returns an alarm action configuration to use an AutoScaling StepScalingAction
     * as an alarm action
     */
    bind(_scope, _alarm) {
        return { alarmActionArn: this.stepScalingAction.scalingPolicyArn };
    }
}
exports.AutoScalingAction = AutoScalingAction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0b3NjYWxpbmcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhdXRvc2NhbGluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUdBOztHQUVHO0FBQ0gsTUFBYSxpQkFBaUI7SUFDMUIsWUFBNkIsaUJBQWdEO1FBQWhELHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBK0I7SUFDN0UsQ0FBQztJQUNEOzs7T0FHRztJQUNJLElBQUksQ0FBQyxNQUFxQixFQUFFLE1BQXlCO1FBQ3hELE9BQU8sRUFBRSxjQUFjLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLENBQUM7SUFDdkUsQ0FBQztDQUNKO0FBVkQsOENBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBhdXRvc2NhbGluZyBmcm9tIFwiLi4vLi4vYXdzLWF1dG9zY2FsaW5nXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtYXV0b3NjYWxpbmcnXG5pbXBvcnQgKiBhcyBjbG91ZHdhdGNoIGZyb20gXCIuLi8uLi9hd3MtY2xvdWR3YXRjaFwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWNsb3Vkd2F0Y2gnXG5pbXBvcnQgKiBhcyBjZGsgZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG4vKipcbiAqIFVzZSBhbiBBdXRvU2NhbGluZyBTdGVwU2NhbGluZ0FjdGlvbiBhcyBhbiBBbGFybSBBY3Rpb25cbiAqL1xuZXhwb3J0IGNsYXNzIEF1dG9TY2FsaW5nQWN0aW9uIGltcGxlbWVudHMgY2xvdWR3YXRjaC5JQWxhcm1BY3Rpb24ge1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgc3RlcFNjYWxpbmdBY3Rpb246IGF1dG9zY2FsaW5nLlN0ZXBTY2FsaW5nQWN0aW9uKSB7XG4gICAgfVxuICAgIC8qKlxuICAgICAqIFJldHVybnMgYW4gYWxhcm0gYWN0aW9uIGNvbmZpZ3VyYXRpb24gdG8gdXNlIGFuIEF1dG9TY2FsaW5nIFN0ZXBTY2FsaW5nQWN0aW9uXG4gICAgICogYXMgYW4gYWxhcm0gYWN0aW9uXG4gICAgICovXG4gICAgcHVibGljIGJpbmQoX3Njb3BlOiBjZGsuQ29uc3RydWN0LCBfYWxhcm06IGNsb3Vkd2F0Y2guSUFsYXJtKTogY2xvdWR3YXRjaC5BbGFybUFjdGlvbkNvbmZpZyB7XG4gICAgICAgIHJldHVybiB7IGFsYXJtQWN0aW9uQXJuOiB0aGlzLnN0ZXBTY2FsaW5nQWN0aW9uLnNjYWxpbmdQb2xpY3lBcm4gfTtcbiAgICB9XG59XG4iXX0=