"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Represents a provider for an AWS CloudFormation custom resources.
 */
class CustomResourceProvider {
    /**
     * @param serviceToken the ServiceToken which contains the ARN for this provider.
     */
    constructor(serviceToken) {
        this.serviceToken = serviceToken;
    }
    /**
     * The Lambda provider that implements this custom resource.
     *
     * We recommend using a lambda.SingletonFunction for this.
     */
    static fromLambda(handler) {
        return new CustomResourceProvider(handler.functionArn);
    }
    /**
     * The SNS Topic for the provider that implements this custom resource.
     */
    static fromTopic(topic) {
        return new CustomResourceProvider(topic.topicArn);
    }
    /**
     * Use AWS Lambda as a provider.
     * @deprecated use `fromLambda`
     */
    static lambda(handler) { return this.fromLambda(handler); }
    /**
     * Use an SNS topic as the provider.
     * @deprecated use `fromTopic`
     */
    static topic(topic) { return this.fromTopic(topic); }
    bind(_) {
        return { serviceToken: this.serviceToken };
    }
}
exports.CustomResourceProvider = CustomResourceProvider;
/**
 * Deprecated.
 * @deprecated use `core.CustomResource`
 */
class CustomResource extends core.CustomResource {
    constructor(scope, id, props) {
        super(scope, id, {
            pascalCaseProperties: true,
            properties: props.properties,
            removalPolicy: props.removalPolicy,
            resourceType: props.resourceType,
            serviceToken: core.Lazy.stringValue({ produce: () => props.provider.bind(this).serviceToken }),
        });
    }
}
exports.CustomResource = CustomResource;
//# sourceMappingURL=data:application/json;base64,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