"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("../../aws-ec2"); // Automatically re-written from '@aws-cdk/aws-ec2'
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cloud9_generated_1 = require("../lib/cloud9.generated");
/**
 * A Cloud9 Environment with Amazon EC2
 * @resource AWS::Cloud9::EnvironmentEC2
 */
class Ec2Environment extends cdk.Resource {
    constructor(scope, id, props) {
        var _a, _b, _c;
        super(scope, id);
        this.vpc = props.vpc;
        if (!props.subnetSelection && this.vpc.publicSubnets.length === 0) {
            throw new Error('no subnetSelection specified and no public subnet found in the vpc, please specify subnetSelection');
        }
        const vpcSubnets = (_a = props.subnetSelection) !== null && _a !== void 0 ? _a : { subnetType: ec2.SubnetType.PUBLIC };
        const c9env = new cloud9_generated_1.CfnEnvironmentEC2(this, 'Resource', {
            name: props.ec2EnvironmentName,
            description: props.description,
            instanceType: (_c = (_b = props.instanceType) === null || _b === void 0 ? void 0 : _b.toString()) !== null && _c !== void 0 ? _c : ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE2, ec2.InstanceSize.MICRO).toString(),
            subnetId: this.vpc.selectSubnets(vpcSubnets).subnetIds[0],
        });
        this.environmentId = c9env.ref;
        this.ec2EnvironmentArn = c9env.getAtt('Arn').toString();
        this.ec2EnvironmentName = c9env.getAtt('Name').toString();
        this.ideUrl = `https://${this.stack.region}.console.aws.amazon.com/cloud9/ide/${this.environmentId}`;
    }
    /**
     * import from EnvironmentEc2Name
     */
    static fromEc2EnvironmentName(scope, id, ec2EnvironmentName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.ec2EnvironmentName = ec2EnvironmentName;
                this.ec2EnvironmentArn = cdk.Stack.of(this).formatArn({
                    service: 'cloud9',
                    resource: 'environment',
                    resourceName: this.ec2EnvironmentName,
                });
            }
        }
        return new Import(scope, id);
    }
}
exports.Ec2Environment = Ec2Environment;
//# sourceMappingURL=data:application/json;base64,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