import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::AppStream::DirectoryConfig`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html
 */
export interface CfnDirectoryConfigProps {
    /**
     * `AWS::AppStream::DirectoryConfig.DirectoryName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-directoryname
     */
    readonly directoryName: string;
    /**
     * `AWS::AppStream::DirectoryConfig.OrganizationalUnitDistinguishedNames`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-organizationalunitdistinguishednames
     */
    readonly organizationalUnitDistinguishedNames: string[];
    /**
     * `AWS::AppStream::DirectoryConfig.ServiceAccountCredentials`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-serviceaccountcredentials
     */
    readonly serviceAccountCredentials: CfnDirectoryConfig.ServiceAccountCredentialsProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppStream::DirectoryConfig`
 *
 * @cloudformationResource AWS::AppStream::DirectoryConfig
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html
 */
export declare class CfnDirectoryConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::DirectoryConfig";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnDirectoryConfig;
    /**
     * `AWS::AppStream::DirectoryConfig.DirectoryName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-directoryname
     */
    directoryName: string;
    /**
     * `AWS::AppStream::DirectoryConfig.OrganizationalUnitDistinguishedNames`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-organizationalunitdistinguishednames
     */
    organizationalUnitDistinguishedNames: string[];
    /**
     * `AWS::AppStream::DirectoryConfig.ServiceAccountCredentials`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-serviceaccountcredentials
     */
    serviceAccountCredentials: CfnDirectoryConfig.ServiceAccountCredentialsProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::AppStream::DirectoryConfig`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDirectoryConfigProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnDirectoryConfig {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-directoryconfig-serviceaccountcredentials.html
     */
    interface ServiceAccountCredentialsProperty {
        /**
         * `CfnDirectoryConfig.ServiceAccountCredentialsProperty.AccountName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-directoryconfig-serviceaccountcredentials.html#cfn-appstream-directoryconfig-serviceaccountcredentials-accountname
         */
        readonly accountName: string;
        /**
         * `CfnDirectoryConfig.ServiceAccountCredentialsProperty.AccountPassword`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-directoryconfig-serviceaccountcredentials.html#cfn-appstream-directoryconfig-serviceaccountcredentials-accountpassword
         */
        readonly accountPassword: string;
    }
}
/**
 * Properties for defining a `AWS::AppStream::Fleet`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html
 */
export interface CfnFleetProps {
    /**
     * `AWS::AppStream::Fleet.ComputeCapacity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-computecapacity
     */
    readonly computeCapacity: CfnFleet.ComputeCapacityProperty | cdk.IResolvable;
    /**
     * `AWS::AppStream::Fleet.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::AppStream::Fleet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-name
     */
    readonly name: string;
    /**
     * `AWS::AppStream::Fleet.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-description
     */
    readonly description?: string;
    /**
     * `AWS::AppStream::Fleet.DisconnectTimeoutInSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-disconnecttimeoutinseconds
     */
    readonly disconnectTimeoutInSeconds?: number;
    /**
     * `AWS::AppStream::Fleet.DisplayName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-displayname
     */
    readonly displayName?: string;
    /**
     * `AWS::AppStream::Fleet.DomainJoinInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-domainjoininfo
     */
    readonly domainJoinInfo?: CfnFleet.DomainJoinInfoProperty | cdk.IResolvable;
    /**
     * `AWS::AppStream::Fleet.EnableDefaultInternetAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-enabledefaultinternetaccess
     */
    readonly enableDefaultInternetAccess?: boolean | cdk.IResolvable;
    /**
     * `AWS::AppStream::Fleet.FleetType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-fleettype
     */
    readonly fleetType?: string;
    /**
     * `AWS::AppStream::Fleet.IdleDisconnectTimeoutInSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-idledisconnecttimeoutinseconds
     */
    readonly idleDisconnectTimeoutInSeconds?: number;
    /**
     * `AWS::AppStream::Fleet.ImageArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-imagearn
     */
    readonly imageArn?: string;
    /**
     * `AWS::AppStream::Fleet.ImageName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-imagename
     */
    readonly imageName?: string;
    /**
     * `AWS::AppStream::Fleet.MaxUserDurationInSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-maxuserdurationinseconds
     */
    readonly maxUserDurationInSeconds?: number;
    /**
     * `AWS::AppStream::Fleet.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::AppStream::Fleet.VpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-vpcconfig
     */
    readonly vpcConfig?: CfnFleet.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppStream::Fleet`
 *
 * @cloudformationResource AWS::AppStream::Fleet
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html
 */
export declare class CfnFleet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::Fleet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnFleet;
    /**
     * `AWS::AppStream::Fleet.ComputeCapacity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-computecapacity
     */
    computeCapacity: CfnFleet.ComputeCapacityProperty | cdk.IResolvable;
    /**
     * `AWS::AppStream::Fleet.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-instancetype
     */
    instanceType: string;
    /**
     * `AWS::AppStream::Fleet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-name
     */
    name: string;
    /**
     * `AWS::AppStream::Fleet.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-description
     */
    description: string | undefined;
    /**
     * `AWS::AppStream::Fleet.DisconnectTimeoutInSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-disconnecttimeoutinseconds
     */
    disconnectTimeoutInSeconds: number | undefined;
    /**
     * `AWS::AppStream::Fleet.DisplayName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-displayname
     */
    displayName: string | undefined;
    /**
     * `AWS::AppStream::Fleet.DomainJoinInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-domainjoininfo
     */
    domainJoinInfo: CfnFleet.DomainJoinInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::Fleet.EnableDefaultInternetAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-enabledefaultinternetaccess
     */
    enableDefaultInternetAccess: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::Fleet.FleetType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-fleettype
     */
    fleetType: string | undefined;
    /**
     * `AWS::AppStream::Fleet.IdleDisconnectTimeoutInSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-idledisconnecttimeoutinseconds
     */
    idleDisconnectTimeoutInSeconds: number | undefined;
    /**
     * `AWS::AppStream::Fleet.ImageArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-imagearn
     */
    imageArn: string | undefined;
    /**
     * `AWS::AppStream::Fleet.ImageName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-imagename
     */
    imageName: string | undefined;
    /**
     * `AWS::AppStream::Fleet.MaxUserDurationInSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-maxuserdurationinseconds
     */
    maxUserDurationInSeconds: number | undefined;
    /**
     * `AWS::AppStream::Fleet.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::AppStream::Fleet.VpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-vpcconfig
     */
    vpcConfig: CfnFleet.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AppStream::Fleet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFleetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-computecapacity.html
     */
    interface ComputeCapacityProperty {
        /**
         * `CfnFleet.ComputeCapacityProperty.DesiredInstances`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-computecapacity.html#cfn-appstream-fleet-computecapacity-desiredinstances
         */
        readonly desiredInstances: number;
    }
}
export declare namespace CfnFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-domainjoininfo.html
     */
    interface DomainJoinInfoProperty {
        /**
         * `CfnFleet.DomainJoinInfoProperty.DirectoryName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-domainjoininfo.html#cfn-appstream-fleet-domainjoininfo-directoryname
         */
        readonly directoryName?: string;
        /**
         * `CfnFleet.DomainJoinInfoProperty.OrganizationalUnitDistinguishedName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-domainjoininfo.html#cfn-appstream-fleet-domainjoininfo-organizationalunitdistinguishedname
         */
        readonly organizationalUnitDistinguishedName?: string;
    }
}
export declare namespace CfnFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnFleet.VpcConfigProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-vpcconfig.html#cfn-appstream-fleet-vpcconfig-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnFleet.VpcConfigProperty.SubnetIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-vpcconfig.html#cfn-appstream-fleet-vpcconfig-subnetids
         */
        readonly subnetIds?: string[];
    }
}
/**
 * Properties for defining a `AWS::AppStream::ImageBuilder`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html
 */
export interface CfnImageBuilderProps {
    /**
     * `AWS::AppStream::ImageBuilder.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::AppStream::ImageBuilder.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-name
     */
    readonly name: string;
    /**
     * `AWS::AppStream::ImageBuilder.AccessEndpoints`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-accessendpoints
     */
    readonly accessEndpoints?: Array<CfnImageBuilder.AccessEndpointProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AppStream::ImageBuilder.AppstreamAgentVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-appstreamagentversion
     */
    readonly appstreamAgentVersion?: string;
    /**
     * `AWS::AppStream::ImageBuilder.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-description
     */
    readonly description?: string;
    /**
     * `AWS::AppStream::ImageBuilder.DisplayName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-displayname
     */
    readonly displayName?: string;
    /**
     * `AWS::AppStream::ImageBuilder.DomainJoinInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-domainjoininfo
     */
    readonly domainJoinInfo?: CfnImageBuilder.DomainJoinInfoProperty | cdk.IResolvable;
    /**
     * `AWS::AppStream::ImageBuilder.EnableDefaultInternetAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-enabledefaultinternetaccess
     */
    readonly enableDefaultInternetAccess?: boolean | cdk.IResolvable;
    /**
     * `AWS::AppStream::ImageBuilder.ImageArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-imagearn
     */
    readonly imageArn?: string;
    /**
     * `AWS::AppStream::ImageBuilder.ImageName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-imagename
     */
    readonly imageName?: string;
    /**
     * `AWS::AppStream::ImageBuilder.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::AppStream::ImageBuilder.VpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-vpcconfig
     */
    readonly vpcConfig?: CfnImageBuilder.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppStream::ImageBuilder`
 *
 * @cloudformationResource AWS::AppStream::ImageBuilder
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html
 */
export declare class CfnImageBuilder extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::ImageBuilder";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnImageBuilder;
    /**
     * @cloudformationAttribute StreamingUrl
     */
    readonly attrStreamingUrl: string;
    /**
     * `AWS::AppStream::ImageBuilder.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-instancetype
     */
    instanceType: string;
    /**
     * `AWS::AppStream::ImageBuilder.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-name
     */
    name: string;
    /**
     * `AWS::AppStream::ImageBuilder.AccessEndpoints`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-accessendpoints
     */
    accessEndpoints: Array<CfnImageBuilder.AccessEndpointProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.AppstreamAgentVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-appstreamagentversion
     */
    appstreamAgentVersion: string | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-description
     */
    description: string | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.DisplayName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-displayname
     */
    displayName: string | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.DomainJoinInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-domainjoininfo
     */
    domainJoinInfo: CfnImageBuilder.DomainJoinInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.EnableDefaultInternetAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-enabledefaultinternetaccess
     */
    enableDefaultInternetAccess: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.ImageArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-imagearn
     */
    imageArn: string | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.ImageName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-imagename
     */
    imageName: string | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::AppStream::ImageBuilder.VpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-vpcconfig
     */
    vpcConfig: CfnImageBuilder.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AppStream::ImageBuilder`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnImageBuilderProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnImageBuilder {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-accessendpoint.html
     */
    interface AccessEndpointProperty {
        /**
         * `CfnImageBuilder.AccessEndpointProperty.EndpointType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-accessendpoint.html#cfn-appstream-imagebuilder-accessendpoint-endpointtype
         */
        readonly endpointType: string;
        /**
         * `CfnImageBuilder.AccessEndpointProperty.VpceId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-accessendpoint.html#cfn-appstream-imagebuilder-accessendpoint-vpceid
         */
        readonly vpceId: string;
    }
}
export declare namespace CfnImageBuilder {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-domainjoininfo.html
     */
    interface DomainJoinInfoProperty {
        /**
         * `CfnImageBuilder.DomainJoinInfoProperty.DirectoryName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-domainjoininfo.html#cfn-appstream-imagebuilder-domainjoininfo-directoryname
         */
        readonly directoryName?: string;
        /**
         * `CfnImageBuilder.DomainJoinInfoProperty.OrganizationalUnitDistinguishedName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-domainjoininfo.html#cfn-appstream-imagebuilder-domainjoininfo-organizationalunitdistinguishedname
         */
        readonly organizationalUnitDistinguishedName?: string;
    }
}
export declare namespace CfnImageBuilder {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnImageBuilder.VpcConfigProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-vpcconfig.html#cfn-appstream-imagebuilder-vpcconfig-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnImageBuilder.VpcConfigProperty.SubnetIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-vpcconfig.html#cfn-appstream-imagebuilder-vpcconfig-subnetids
         */
        readonly subnetIds?: string[];
    }
}
/**
 * Properties for defining a `AWS::AppStream::Stack`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html
 */
export interface CfnStackProps {
    /**
     * `AWS::AppStream::Stack.AccessEndpoints`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-accessendpoints
     */
    readonly accessEndpoints?: Array<CfnStack.AccessEndpointProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AppStream::Stack.ApplicationSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-applicationsettings
     */
    readonly applicationSettings?: CfnStack.ApplicationSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::AppStream::Stack.AttributesToDelete`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-attributestodelete
     */
    readonly attributesToDelete?: string[];
    /**
     * `AWS::AppStream::Stack.DeleteStorageConnectors`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-deletestorageconnectors
     */
    readonly deleteStorageConnectors?: boolean | cdk.IResolvable;
    /**
     * `AWS::AppStream::Stack.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-description
     */
    readonly description?: string;
    /**
     * `AWS::AppStream::Stack.DisplayName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-displayname
     */
    readonly displayName?: string;
    /**
     * `AWS::AppStream::Stack.EmbedHostDomains`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-embedhostdomains
     */
    readonly embedHostDomains?: string[];
    /**
     * `AWS::AppStream::Stack.FeedbackURL`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-feedbackurl
     */
    readonly feedbackUrl?: string;
    /**
     * `AWS::AppStream::Stack.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-name
     */
    readonly name?: string;
    /**
     * `AWS::AppStream::Stack.RedirectURL`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-redirecturl
     */
    readonly redirectUrl?: string;
    /**
     * `AWS::AppStream::Stack.StorageConnectors`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-storageconnectors
     */
    readonly storageConnectors?: Array<CfnStack.StorageConnectorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AppStream::Stack.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::AppStream::Stack.UserSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-usersettings
     */
    readonly userSettings?: Array<CfnStack.UserSettingProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppStream::Stack`
 *
 * @cloudformationResource AWS::AppStream::Stack
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html
 */
export declare class CfnStack extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::Stack";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnStack;
    /**
     * `AWS::AppStream::Stack.AccessEndpoints`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-accessendpoints
     */
    accessEndpoints: Array<CfnStack.AccessEndpointProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::Stack.ApplicationSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-applicationsettings
     */
    applicationSettings: CfnStack.ApplicationSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::Stack.AttributesToDelete`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-attributestodelete
     */
    attributesToDelete: string[] | undefined;
    /**
     * `AWS::AppStream::Stack.DeleteStorageConnectors`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-deletestorageconnectors
     */
    deleteStorageConnectors: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::Stack.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-description
     */
    description: string | undefined;
    /**
     * `AWS::AppStream::Stack.DisplayName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-displayname
     */
    displayName: string | undefined;
    /**
     * `AWS::AppStream::Stack.EmbedHostDomains`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-embedhostdomains
     */
    embedHostDomains: string[] | undefined;
    /**
     * `AWS::AppStream::Stack.FeedbackURL`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-feedbackurl
     */
    feedbackUrl: string | undefined;
    /**
     * `AWS::AppStream::Stack.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-name
     */
    name: string | undefined;
    /**
     * `AWS::AppStream::Stack.RedirectURL`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-redirecturl
     */
    redirectUrl: string | undefined;
    /**
     * `AWS::AppStream::Stack.StorageConnectors`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-storageconnectors
     */
    storageConnectors: Array<CfnStack.StorageConnectorProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::Stack.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::AppStream::Stack.UserSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-usersettings
     */
    userSettings: Array<CfnStack.UserSettingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AppStream::Stack`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnStackProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnStack {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-accessendpoint.html
     */
    interface AccessEndpointProperty {
        /**
         * `CfnStack.AccessEndpointProperty.EndpointType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-accessendpoint.html#cfn-appstream-stack-accessendpoint-endpointtype
         */
        readonly endpointType: string;
        /**
         * `CfnStack.AccessEndpointProperty.VpceId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-accessendpoint.html#cfn-appstream-stack-accessendpoint-vpceid
         */
        readonly vpceId: string;
    }
}
export declare namespace CfnStack {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-applicationsettings.html
     */
    interface ApplicationSettingsProperty {
        /**
         * `CfnStack.ApplicationSettingsProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-applicationsettings.html#cfn-appstream-stack-applicationsettings-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnStack.ApplicationSettingsProperty.SettingsGroup`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-applicationsettings.html#cfn-appstream-stack-applicationsettings-settingsgroup
         */
        readonly settingsGroup?: string;
    }
}
export declare namespace CfnStack {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-storageconnector.html
     */
    interface StorageConnectorProperty {
        /**
         * `CfnStack.StorageConnectorProperty.ConnectorType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-storageconnector.html#cfn-appstream-stack-storageconnector-connectortype
         */
        readonly connectorType: string;
        /**
         * `CfnStack.StorageConnectorProperty.Domains`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-storageconnector.html#cfn-appstream-stack-storageconnector-domains
         */
        readonly domains?: string[];
        /**
         * `CfnStack.StorageConnectorProperty.ResourceIdentifier`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-storageconnector.html#cfn-appstream-stack-storageconnector-resourceidentifier
         */
        readonly resourceIdentifier?: string;
    }
}
export declare namespace CfnStack {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-usersetting.html
     */
    interface UserSettingProperty {
        /**
         * `CfnStack.UserSettingProperty.Action`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-usersetting.html#cfn-appstream-stack-usersetting-action
         */
        readonly action: string;
        /**
         * `CfnStack.UserSettingProperty.Permission`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-usersetting.html#cfn-appstream-stack-usersetting-permission
         */
        readonly permission: string;
    }
}
/**
 * Properties for defining a `AWS::AppStream::StackFleetAssociation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackfleetassociation.html
 */
export interface CfnStackFleetAssociationProps {
    /**
     * `AWS::AppStream::StackFleetAssociation.FleetName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackfleetassociation.html#cfn-appstream-stackfleetassociation-fleetname
     */
    readonly fleetName: string;
    /**
     * `AWS::AppStream::StackFleetAssociation.StackName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackfleetassociation.html#cfn-appstream-stackfleetassociation-stackname
     */
    readonly stackName: string;
}
/**
 * A CloudFormation `AWS::AppStream::StackFleetAssociation`
 *
 * @cloudformationResource AWS::AppStream::StackFleetAssociation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackfleetassociation.html
 */
export declare class CfnStackFleetAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::StackFleetAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnStackFleetAssociation;
    /**
     * `AWS::AppStream::StackFleetAssociation.FleetName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackfleetassociation.html#cfn-appstream-stackfleetassociation-fleetname
     */
    fleetName: string;
    /**
     * `AWS::AppStream::StackFleetAssociation.StackName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackfleetassociation.html#cfn-appstream-stackfleetassociation-stackname
     */
    stackName: string;
    /**
     * Create a new `AWS::AppStream::StackFleetAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStackFleetAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::AppStream::StackUserAssociation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html
 */
export interface CfnStackUserAssociationProps {
    /**
     * `AWS::AppStream::StackUserAssociation.AuthenticationType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-authenticationtype
     */
    readonly authenticationType: string;
    /**
     * `AWS::AppStream::StackUserAssociation.StackName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-stackname
     */
    readonly stackName: string;
    /**
     * `AWS::AppStream::StackUserAssociation.UserName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-username
     */
    readonly userName: string;
    /**
     * `AWS::AppStream::StackUserAssociation.SendEmailNotification`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-sendemailnotification
     */
    readonly sendEmailNotification?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppStream::StackUserAssociation`
 *
 * @cloudformationResource AWS::AppStream::StackUserAssociation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html
 */
export declare class CfnStackUserAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::StackUserAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnStackUserAssociation;
    /**
     * `AWS::AppStream::StackUserAssociation.AuthenticationType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-authenticationtype
     */
    authenticationType: string;
    /**
     * `AWS::AppStream::StackUserAssociation.StackName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-stackname
     */
    stackName: string;
    /**
     * `AWS::AppStream::StackUserAssociation.UserName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-username
     */
    userName: string;
    /**
     * `AWS::AppStream::StackUserAssociation.SendEmailNotification`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-sendemailnotification
     */
    sendEmailNotification: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AppStream::StackUserAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStackUserAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::AppStream::User`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html
 */
export interface CfnUserProps {
    /**
     * `AWS::AppStream::User.AuthenticationType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-authenticationtype
     */
    readonly authenticationType: string;
    /**
     * `AWS::AppStream::User.UserName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-username
     */
    readonly userName: string;
    /**
     * `AWS::AppStream::User.FirstName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-firstname
     */
    readonly firstName?: string;
    /**
     * `AWS::AppStream::User.LastName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-lastname
     */
    readonly lastName?: string;
    /**
     * `AWS::AppStream::User.MessageAction`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-messageaction
     */
    readonly messageAction?: string;
}
/**
 * A CloudFormation `AWS::AppStream::User`
 *
 * @cloudformationResource AWS::AppStream::User
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html
 */
export declare class CfnUser extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::User";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnUser;
    /**
     * `AWS::AppStream::User.AuthenticationType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-authenticationtype
     */
    authenticationType: string;
    /**
     * `AWS::AppStream::User.UserName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-username
     */
    userName: string;
    /**
     * `AWS::AppStream::User.FirstName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-firstname
     */
    firstName: string | undefined;
    /**
     * `AWS::AppStream::User.LastName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-lastname
     */
    lastName: string | undefined;
    /**
     * `AWS::AppStream::User.MessageAction`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-messageaction
     */
    messageAction: string | undefined;
    /**
     * Create a new `AWS::AppStream::User`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
