"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
class RequestValidator extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.requestValidatorName,
        });
        const validatorProps = {
            name: this.physicalName,
            restApiId: props.restApi.restApiId,
            validateRequestBody: props.validateRequestBody,
            validateRequestParameters: props.validateRequestParameters,
        };
        const resource = new apigateway_generated_1.CfnRequestValidator(this, 'Resource', validatorProps);
        this.requestValidatorId = resource.ref;
        const deployment = (props.restApi instanceof restapi_1.RestApi) ? props.restApi.latestDeployment : undefined;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({ validator: validatorProps });
        }
    }
    static fromRequestValidatorId(scope, id, requestValidatorId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.requestValidatorId = requestValidatorId;
            }
        }
        return new Import(scope, id);
    }
}
exports.RequestValidator = RequestValidator;
//# sourceMappingURL=data:application/json;base64,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