"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var JsonSchemaVersion;
(function (JsonSchemaVersion) {
    /**
     * In API Gateway models are defined using the JSON schema draft 4.
     * @see https://tools.ietf.org/html/draft-zyp-json-schema-04
     */
    JsonSchemaVersion["DRAFT4"] = "http://json-schema.org/draft-04/schema#";
    JsonSchemaVersion["DRAFT7"] = "http://json-schema.org/draft-07/schema#";
})(JsonSchemaVersion = exports.JsonSchemaVersion || (exports.JsonSchemaVersion = {}));
var JsonSchemaType;
(function (JsonSchemaType) {
    JsonSchemaType["NULL"] = "null";
    JsonSchemaType["BOOLEAN"] = "boolean";
    JsonSchemaType["OBJECT"] = "object";
    JsonSchemaType["ARRAY"] = "array";
    JsonSchemaType["NUMBER"] = "number";
    JsonSchemaType["INTEGER"] = "integer";
    JsonSchemaType["STRING"] = "string";
})(JsonSchemaType = exports.JsonSchemaType || (exports.JsonSchemaType = {}));
//# sourceMappingURL=data:application/json;base64,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