"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const method_1 = require("./method");
const AUTHORIZER_SYMBOL = Symbol.for('@aws-cdk/aws-apigateway.Authorizer');
/**
 * Base class for all custom authorizers
 */
class Authorizer extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.authorizationType = method_1.AuthorizationType.CUSTOM;
        Object.defineProperty(this, AUTHORIZER_SYMBOL, { value: true });
    }
    /**
     * Return whether the given object is an Authorizer.
     */
    static isAuthorizer(x) {
        return x !== null && typeof (x) === 'object' && AUTHORIZER_SYMBOL in x;
    }
}
exports.Authorizer = Authorizer;
//# sourceMappingURL=data:application/json;base64,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