"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const amplify_generated_1 = require("./amplify.generated");
/**
 * An Amplify Console domain
 */
class Domain extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.subDomains = props.subDomains || [];
        const domainName = props.domainName || id;
        const domain = new amplify_generated_1.CfnDomain(this, 'Resource', {
            appId: props.app.appId,
            domainName,
            subDomainSettings: core_1.Lazy.anyValue({ produce: () => this.renderSubDomainSettings() }, { omitEmptyArray: true }),
        });
        this.arn = domain.attrArn;
        this.certificateRecord = domain.attrCertificateRecord;
        this.domainName = domain.attrDomainName;
        this.domainStatus = domain.attrDomainStatus;
        this.statusReason = domain.attrStatusReason;
    }
    /**
     * Maps a branch to a sub domain
     *
     * @param branch The branch
     * @param prefix The prefix. Use '' to map to the root of the domain. Defaults to branch name.
     */
    mapSubDomain(branch, prefix) {
        this.subDomains.push({ branch, prefix });
        return this;
    }
    /**
     * Maps a branch to the domain root
     */
    mapRoot(branch) {
        return this.mapSubDomain(branch, '');
    }
    validate() {
        if (this.subDomains.length === 0) {
            return ['The domain doesn\'t contain any subdomains'];
        }
        return [];
    }
    renderSubDomainSettings() {
        return this.subDomains.map(s => ({
            branchName: s.branch.branchName,
            prefix: s.prefix === undefined ? s.branch.branchName : s.prefix,
        }));
    }
}
exports.Domain = Domain;
//# sourceMappingURL=data:application/json;base64,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