"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Symlink follow mode.
 * @deprecated see `core.SymlinkFollowMode`
 */
var FollowMode;
(function (FollowMode) {
    /**
     * Never follow symlinks.
     */
    FollowMode["NEVER"] = "never";
    /**
     * Materialize all symlinks, whether they are internal or external to the source directory.
     */
    FollowMode["ALWAYS"] = "always";
    /**
     * Only follows symlinks that are external to the source directory.
     */
    FollowMode["EXTERNAL"] = "external";
    // ----------------- TODO::::::::::::::::::::::::::::::::::::::::::::
    /**
     * Forbids source from having any symlinks pointing outside of the source
     * tree.
     *
     * This is the safest mode of operation as it ensures that copy operations
     * won't materialize files from the user's file system. Internal symlinks are
     * not followed.
     *
     * If the copy operation runs into an external symlink, it will fail.
     */
    FollowMode["BLOCK_EXTERNAL"] = "internal-only";
})(FollowMode = exports.FollowMode || (exports.FollowMode = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZm9sbG93LW1vZGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmb2xsb3ctbW9kZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7R0FHRztBQUNILElBQVksVUF5Qlg7QUF6QkQsV0FBWSxVQUFVO0lBQ2xCOztPQUVHO0lBQ0gsNkJBQWUsQ0FBQTtJQUNmOztPQUVHO0lBQ0gsK0JBQWlCLENBQUE7SUFDakI7O09BRUc7SUFDSCxtQ0FBcUIsQ0FBQTtJQUNyQixxRUFBcUU7SUFDckU7Ozs7Ozs7OztPQVNHO0lBQ0gsOENBQWdDLENBQUE7QUFDcEMsQ0FBQyxFQXpCVyxVQUFVLEdBQVYsa0JBQVUsS0FBVixrQkFBVSxRQXlCckIiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFN5bWxpbmsgZm9sbG93IG1vZGUuXG4gKiBAZGVwcmVjYXRlZCBzZWUgYGNvcmUuU3ltbGlua0ZvbGxvd01vZGVgXG4gKi9cbmV4cG9ydCBlbnVtIEZvbGxvd01vZGUge1xuICAgIC8qKlxuICAgICAqIE5ldmVyIGZvbGxvdyBzeW1saW5rcy5cbiAgICAgKi9cbiAgICBORVZFUiA9ICduZXZlcicsXG4gICAgLyoqXG4gICAgICogTWF0ZXJpYWxpemUgYWxsIHN5bWxpbmtzLCB3aGV0aGVyIHRoZXkgYXJlIGludGVybmFsIG9yIGV4dGVybmFsIHRvIHRoZSBzb3VyY2UgZGlyZWN0b3J5LlxuICAgICAqL1xuICAgIEFMV0FZUyA9ICdhbHdheXMnLFxuICAgIC8qKlxuICAgICAqIE9ubHkgZm9sbG93cyBzeW1saW5rcyB0aGF0IGFyZSBleHRlcm5hbCB0byB0aGUgc291cmNlIGRpcmVjdG9yeS5cbiAgICAgKi9cbiAgICBFWFRFUk5BTCA9ICdleHRlcm5hbCcsXG4gICAgLy8gLS0tLS0tLS0tLS0tLS0tLS0gVE9ETzo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6Ojo6XG4gICAgLyoqXG4gICAgICogRm9yYmlkcyBzb3VyY2UgZnJvbSBoYXZpbmcgYW55IHN5bWxpbmtzIHBvaW50aW5nIG91dHNpZGUgb2YgdGhlIHNvdXJjZVxuICAgICAqIHRyZWUuXG4gICAgICpcbiAgICAgKiBUaGlzIGlzIHRoZSBzYWZlc3QgbW9kZSBvZiBvcGVyYXRpb24gYXMgaXQgZW5zdXJlcyB0aGF0IGNvcHkgb3BlcmF0aW9uc1xuICAgICAqIHdvbid0IG1hdGVyaWFsaXplIGZpbGVzIGZyb20gdGhlIHVzZXIncyBmaWxlIHN5c3RlbS4gSW50ZXJuYWwgc3ltbGlua3MgYXJlXG4gICAgICogbm90IGZvbGxvd2VkLlxuICAgICAqXG4gICAgICogSWYgdGhlIGNvcHkgb3BlcmF0aW9uIHJ1bnMgaW50byBhbiBleHRlcm5hbCBzeW1saW5rLCBpdCB3aWxsIGZhaWwuXG4gICAgICovXG4gICAgQkxPQ0tfRVhURVJOQUwgPSAnaW50ZXJuYWwtb25seSdcbn1cbiJdfQ==