"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const follow_mode_1 = require("./fs/follow-mode");
function toSymlinkFollow(follow) {
    if (!follow) {
        return undefined;
    }
    switch (follow) {
        case follow_mode_1.FollowMode.NEVER: return core_1.SymlinkFollowMode.NEVER;
        case follow_mode_1.FollowMode.ALWAYS: return core_1.SymlinkFollowMode.ALWAYS;
        case follow_mode_1.FollowMode.BLOCK_EXTERNAL: return core_1.SymlinkFollowMode.BLOCK_EXTERNAL;
        case follow_mode_1.FollowMode.EXTERNAL: return core_1.SymlinkFollowMode.EXTERNAL;
        default:
            throw new Error(`unknown follow mode: ${follow}`);
    }
}
exports.toSymlinkFollow = toSymlinkFollow;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tcGF0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tcGF0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQStDLENBQUMsZ0RBQWdEO0FBQ2hHLGtEQUE4QztBQUM5QyxTQUFnQixlQUFlLENBQUMsTUFBbUI7SUFDL0MsSUFBSSxDQUFDLE1BQU0sRUFBRTtRQUNULE9BQU8sU0FBUyxDQUFDO0tBQ3BCO0lBQ0QsUUFBUSxNQUFNLEVBQUU7UUFDWixLQUFLLHdCQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsT0FBTyx3QkFBaUIsQ0FBQyxLQUFLLENBQUM7UUFDdEQsS0FBSyx3QkFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLE9BQU8sd0JBQWlCLENBQUMsTUFBTSxDQUFDO1FBQ3hELEtBQUssd0JBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxPQUFPLHdCQUFpQixDQUFDLGNBQWMsQ0FBQztRQUN4RSxLQUFLLHdCQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsT0FBTyx3QkFBaUIsQ0FBQyxRQUFRLENBQUM7UUFDNUQ7WUFDSSxNQUFNLElBQUksS0FBSyxDQUFDLHdCQUF3QixNQUFNLEVBQUUsQ0FBQyxDQUFDO0tBQ3pEO0FBQ0wsQ0FBQztBQVpELDBDQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU3ltbGlua0ZvbGxvd01vZGUgfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbmltcG9ydCB7IEZvbGxvd01vZGUgfSBmcm9tICcuL2ZzL2ZvbGxvdy1tb2RlJztcbmV4cG9ydCBmdW5jdGlvbiB0b1N5bWxpbmtGb2xsb3coZm9sbG93PzogRm9sbG93TW9kZSk6IFN5bWxpbmtGb2xsb3dNb2RlIHwgdW5kZWZpbmVkIHtcbiAgICBpZiAoIWZvbGxvdykge1xuICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBzd2l0Y2ggKGZvbGxvdykge1xuICAgICAgICBjYXNlIEZvbGxvd01vZGUuTkVWRVI6IHJldHVybiBTeW1saW5rRm9sbG93TW9kZS5ORVZFUjtcbiAgICAgICAgY2FzZSBGb2xsb3dNb2RlLkFMV0FZUzogcmV0dXJuIFN5bWxpbmtGb2xsb3dNb2RlLkFMV0FZUztcbiAgICAgICAgY2FzZSBGb2xsb3dNb2RlLkJMT0NLX0VYVEVSTkFMOiByZXR1cm4gU3ltbGlua0ZvbGxvd01vZGUuQkxPQ0tfRVhURVJOQUw7XG4gICAgICAgIGNhc2UgRm9sbG93TW9kZS5FWFRFUk5BTDogcmV0dXJuIFN5bWxpbmtGb2xsb3dNb2RlLkVYVEVSTkFMO1xuICAgICAgICBkZWZhdWx0OlxuICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKGB1bmtub3duIGZvbGxvdyBtb2RlOiAke2ZvbGxvd31gKTtcbiAgICB9XG59XG4iXX0=