import abc
import builtins
import datetime
import enum
import typing

import jsii
import jsii.compat
import publication

from .._jsii import *

from .. import (Resource as _Resource_884d0774, Construct as _Construct_f50a3f53, RemovalPolicy as _RemovalPolicy_5986e9f3, CfnResource as _CfnResource_7760e8e4, FromCloudFormationOptions as _FromCloudFormationOptions_5f49f6f1, TreeInspector as _TreeInspector_154f5999, IInspectable as _IInspectable_051e6ed8, TagManager as _TagManager_2508893f, IResolvable as _IResolvable_9ceae33e, CfnTag as _CfnTag_b4661f1a, IResource as _IResource_72f7ee7e)
from ..aws_iam import (AddToResourcePolicyResult as _AddToResourcePolicyResult_d2a345d1, PolicyStatement as _PolicyStatement_f75dc775, Grant as _Grant_96af6d2d, IGrantable as _IGrantable_0fcfc53a, PolicyDocument as _PolicyDocument_1d1bca11, PrincipalBase as _PrincipalBase_e4459eeb, IPrincipal as _IPrincipal_97126874, PrincipalPolicyFragment as _PrincipalPolicyFragment_621f702c)


@jsii.data_type(jsii_type="monocdk-experiment.aws_kms.AliasAttributes", jsii_struct_bases=[], name_mapping={'alias_name': 'aliasName', 'alias_target_key': 'aliasTargetKey'})
class AliasAttributes():
    def __init__(self, *, alias_name: str, alias_target_key: "IKey") -> None:
        """Properties of a reference to an existing KMS Alias.

        :param alias_name: Specifies the alias name. This value must begin with alias/ followed by a name (i.e. alias/ExampleAlias)
        :param alias_target_key: The customer master key (CMK) to which the Alias refers.

        stability
        :stability: experimental
        """
        self._values = {
            'alias_name': alias_name,
            'alias_target_key': alias_target_key,
        }

    @builtins.property
    def alias_name(self) -> str:
        """Specifies the alias name.

        This value must begin with alias/ followed by a name (i.e. alias/ExampleAlias)

        stability
        :stability: experimental
        """
        return self._values.get('alias_name')

    @builtins.property
    def alias_target_key(self) -> "IKey":
        """The customer master key (CMK) to which the Alias refers.

        stability
        :stability: experimental
        """
        return self._values.get('alias_target_key')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AliasAttributes(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="monocdk-experiment.aws_kms.AliasProps", jsii_struct_bases=[], name_mapping={'alias_name': 'aliasName', 'target_key': 'targetKey', 'removal_policy': 'removalPolicy'})
class AliasProps():
    def __init__(self, *, alias_name: str, target_key: "IKey", removal_policy: typing.Optional[_RemovalPolicy_5986e9f3]=None) -> None:
        """Construction properties for a KMS Key Alias object.

        :param alias_name: The name of the alias. The name must start with alias followed by a forward slash, such as alias/. You can't specify aliases that begin with alias/AWS. These aliases are reserved.
        :param target_key: The ID of the key for which you are creating the alias. Specify the key's globally unique identifier or Amazon Resource Name (ARN). You can't specify another alias.
        :param removal_policy: Policy to apply when the alias is removed from this stack. Default: - The alias will be deleted

        stability
        :stability: experimental
        """
        self._values = {
            'alias_name': alias_name,
            'target_key': target_key,
        }
        if removal_policy is not None: self._values["removal_policy"] = removal_policy

    @builtins.property
    def alias_name(self) -> str:
        """The name of the alias.

        The name must start with alias followed by a
        forward slash, such as alias/. You can't specify aliases that begin with
        alias/AWS. These aliases are reserved.

        stability
        :stability: experimental
        """
        return self._values.get('alias_name')

    @builtins.property
    def target_key(self) -> "IKey":
        """The ID of the key for which you are creating the alias.

        Specify the key's
        globally unique identifier or Amazon Resource Name (ARN). You can't
        specify another alias.

        stability
        :stability: experimental
        """
        return self._values.get('target_key')

    @builtins.property
    def removal_policy(self) -> typing.Optional[_RemovalPolicy_5986e9f3]:
        """Policy to apply when the alias is removed from this stack.

        default
        :default: - The alias will be deleted

        stability
        :stability: experimental
        """
        return self._values.get('removal_policy')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AliasProps(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.implements(_IInspectable_051e6ed8)
class CfnAlias(_CfnResource_7760e8e4, metaclass=jsii.JSIIMeta, jsii_type="monocdk-experiment.aws_kms.CfnAlias"):
    """A CloudFormation ``AWS::KMS::Alias``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-alias.html
    cloudformationResource:
    :cloudformationResource:: AWS::KMS::Alias
    """
    def __init__(self, scope: _Construct_f50a3f53, id: str, *, alias_name: str, target_key_id: str) -> None:
        """Create a new ``AWS::KMS::Alias``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param alias_name: ``AWS::KMS::Alias.AliasName``.
        :param target_key_id: ``AWS::KMS::Alias.TargetKeyId``.
        """
        props = CfnAliasProps(alias_name=alias_name, target_key_id=target_key_id)

        jsii.create(CfnAlias, self, [scope, id, props])

    @jsii.member(jsii_name="fromCloudFormation")
    @builtins.classmethod
    def from_cloud_formation(cls, scope: _Construct_f50a3f53, id: str, resource_attributes: typing.Any, *, finder: _ICfnFinder_3b168f30) -> "CfnAlias":
        """A factory method that creates a new instance of this class from an object containing the CloudFormation properties of this resource.

        Used in the @aws-cdk/cloudformation-include module.

        :param scope: -
        :param id: -
        :param resource_attributes: -
        :param finder: The finder interface used to resolve references across the template.

        stability
        :stability: experimental
        """
        options = _FromCloudFormationOptions_5f49f6f1(finder=finder)

        return jsii.sinvoke(cls, "fromCloudFormation", [scope, id, resource_attributes, options])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(self, props: typing.Mapping[str, typing.Any]) -> typing.Mapping[str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property
    @jsii.member(jsii_name="aliasName")
    def alias_name(self) -> str:
        """``AWS::KMS::Alias.AliasName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-alias.html#cfn-kms-alias-aliasname
        """
        return jsii.get(self, "aliasName")

    @alias_name.setter
    def alias_name(self, value: str) -> None:
        jsii.set(self, "aliasName", value)

    @builtins.property
    @jsii.member(jsii_name="targetKeyId")
    def target_key_id(self) -> str:
        """``AWS::KMS::Alias.TargetKeyId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-alias.html#cfn-kms-alias-targetkeyid
        """
        return jsii.get(self, "targetKeyId")

    @target_key_id.setter
    def target_key_id(self, value: str) -> None:
        jsii.set(self, "targetKeyId", value)


@jsii.data_type(jsii_type="monocdk-experiment.aws_kms.CfnAliasProps", jsii_struct_bases=[], name_mapping={'alias_name': 'aliasName', 'target_key_id': 'targetKeyId'})
class CfnAliasProps():
    def __init__(self, *, alias_name: str, target_key_id: str) -> None:
        """Properties for defining a ``AWS::KMS::Alias``.

        :param alias_name: ``AWS::KMS::Alias.AliasName``.
        :param target_key_id: ``AWS::KMS::Alias.TargetKeyId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-alias.html
        """
        self._values = {
            'alias_name': alias_name,
            'target_key_id': target_key_id,
        }

    @builtins.property
    def alias_name(self) -> str:
        """``AWS::KMS::Alias.AliasName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-alias.html#cfn-kms-alias-aliasname
        """
        return self._values.get('alias_name')

    @builtins.property
    def target_key_id(self) -> str:
        """``AWS::KMS::Alias.TargetKeyId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-alias.html#cfn-kms-alias-targetkeyid
        """
        return self._values.get('target_key_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CfnAliasProps(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.implements(_IInspectable_051e6ed8)
class CfnKey(_CfnResource_7760e8e4, metaclass=jsii.JSIIMeta, jsii_type="monocdk-experiment.aws_kms.CfnKey"):
    """A CloudFormation ``AWS::KMS::Key``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html
    cloudformationResource:
    :cloudformationResource:: AWS::KMS::Key
    """
    def __init__(self, scope: _Construct_f50a3f53, id: str, *, key_policy: typing.Any, description: typing.Optional[str]=None, enabled: typing.Optional[typing.Union[bool, _IResolvable_9ceae33e]]=None, enable_key_rotation: typing.Optional[typing.Union[bool, _IResolvable_9ceae33e]]=None, key_usage: typing.Optional[str]=None, pending_window_in_days: typing.Optional[jsii.Number]=None, tags: typing.Optional[typing.List[_CfnTag_b4661f1a]]=None) -> None:
        """Create a new ``AWS::KMS::Key``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param key_policy: ``AWS::KMS::Key.KeyPolicy``.
        :param description: ``AWS::KMS::Key.Description``.
        :param enabled: ``AWS::KMS::Key.Enabled``.
        :param enable_key_rotation: ``AWS::KMS::Key.EnableKeyRotation``.
        :param key_usage: ``AWS::KMS::Key.KeyUsage``.
        :param pending_window_in_days: ``AWS::KMS::Key.PendingWindowInDays``.
        :param tags: ``AWS::KMS::Key.Tags``.
        """
        props = CfnKeyProps(key_policy=key_policy, description=description, enabled=enabled, enable_key_rotation=enable_key_rotation, key_usage=key_usage, pending_window_in_days=pending_window_in_days, tags=tags)

        jsii.create(CfnKey, self, [scope, id, props])

    @jsii.member(jsii_name="fromCloudFormation")
    @builtins.classmethod
    def from_cloud_formation(cls, scope: _Construct_f50a3f53, id: str, resource_attributes: typing.Any, *, finder: _ICfnFinder_3b168f30) -> "CfnKey":
        """A factory method that creates a new instance of this class from an object containing the CloudFormation properties of this resource.

        Used in the @aws-cdk/cloudformation-include module.

        :param scope: -
        :param id: -
        :param resource_attributes: -
        :param finder: The finder interface used to resolve references across the template.

        stability
        :stability: experimental
        """
        options = _FromCloudFormationOptions_5f49f6f1(finder=finder)

        return jsii.sinvoke(cls, "fromCloudFormation", [scope, id, resource_attributes, options])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(self, props: typing.Mapping[str, typing.Any]) -> typing.Mapping[str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: Arn
        """
        return jsii.get(self, "attrArn")

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::KMS::Key.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-tags
        """
        return jsii.get(self, "tags")

    @builtins.property
    @jsii.member(jsii_name="keyPolicy")
    def key_policy(self) -> typing.Any:
        """``AWS::KMS::Key.KeyPolicy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-keypolicy
        """
        return jsii.get(self, "keyPolicy")

    @key_policy.setter
    def key_policy(self, value: typing.Any) -> None:
        jsii.set(self, "keyPolicy", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        """``AWS::KMS::Key.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-description
        """
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> typing.Optional[typing.Union[bool, _IResolvable_9ceae33e]]:
        """``AWS::KMS::Key.Enabled``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-enabled
        """
        return jsii.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: typing.Optional[typing.Union[bool, _IResolvable_9ceae33e]]) -> None:
        jsii.set(self, "enabled", value)

    @builtins.property
    @jsii.member(jsii_name="enableKeyRotation")
    def enable_key_rotation(self) -> typing.Optional[typing.Union[bool, _IResolvable_9ceae33e]]:
        """``AWS::KMS::Key.EnableKeyRotation``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-enablekeyrotation
        """
        return jsii.get(self, "enableKeyRotation")

    @enable_key_rotation.setter
    def enable_key_rotation(self, value: typing.Optional[typing.Union[bool, _IResolvable_9ceae33e]]) -> None:
        jsii.set(self, "enableKeyRotation", value)

    @builtins.property
    @jsii.member(jsii_name="keyUsage")
    def key_usage(self) -> typing.Optional[str]:
        """``AWS::KMS::Key.KeyUsage``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-keyusage
        """
        return jsii.get(self, "keyUsage")

    @key_usage.setter
    def key_usage(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "keyUsage", value)

    @builtins.property
    @jsii.member(jsii_name="pendingWindowInDays")
    def pending_window_in_days(self) -> typing.Optional[jsii.Number]:
        """``AWS::KMS::Key.PendingWindowInDays``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-pendingwindowindays
        """
        return jsii.get(self, "pendingWindowInDays")

    @pending_window_in_days.setter
    def pending_window_in_days(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "pendingWindowInDays", value)


@jsii.data_type(jsii_type="monocdk-experiment.aws_kms.CfnKeyProps", jsii_struct_bases=[], name_mapping={'key_policy': 'keyPolicy', 'description': 'description', 'enabled': 'enabled', 'enable_key_rotation': 'enableKeyRotation', 'key_usage': 'keyUsage', 'pending_window_in_days': 'pendingWindowInDays', 'tags': 'tags'})
class CfnKeyProps():
    def __init__(self, *, key_policy: typing.Any, description: typing.Optional[str]=None, enabled: typing.Optional[typing.Union[bool, _IResolvable_9ceae33e]]=None, enable_key_rotation: typing.Optional[typing.Union[bool, _IResolvable_9ceae33e]]=None, key_usage: typing.Optional[str]=None, pending_window_in_days: typing.Optional[jsii.Number]=None, tags: typing.Optional[typing.List[_CfnTag_b4661f1a]]=None) -> None:
        """Properties for defining a ``AWS::KMS::Key``.

        :param key_policy: ``AWS::KMS::Key.KeyPolicy``.
        :param description: ``AWS::KMS::Key.Description``.
        :param enabled: ``AWS::KMS::Key.Enabled``.
        :param enable_key_rotation: ``AWS::KMS::Key.EnableKeyRotation``.
        :param key_usage: ``AWS::KMS::Key.KeyUsage``.
        :param pending_window_in_days: ``AWS::KMS::Key.PendingWindowInDays``.
        :param tags: ``AWS::KMS::Key.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html
        """
        self._values = {
            'key_policy': key_policy,
        }
        if description is not None: self._values["description"] = description
        if enabled is not None: self._values["enabled"] = enabled
        if enable_key_rotation is not None: self._values["enable_key_rotation"] = enable_key_rotation
        if key_usage is not None: self._values["key_usage"] = key_usage
        if pending_window_in_days is not None: self._values["pending_window_in_days"] = pending_window_in_days
        if tags is not None: self._values["tags"] = tags

    @builtins.property
    def key_policy(self) -> typing.Any:
        """``AWS::KMS::Key.KeyPolicy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-keypolicy
        """
        return self._values.get('key_policy')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """``AWS::KMS::Key.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-description
        """
        return self._values.get('description')

    @builtins.property
    def enabled(self) -> typing.Optional[typing.Union[bool, _IResolvable_9ceae33e]]:
        """``AWS::KMS::Key.Enabled``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-enabled
        """
        return self._values.get('enabled')

    @builtins.property
    def enable_key_rotation(self) -> typing.Optional[typing.Union[bool, _IResolvable_9ceae33e]]:
        """``AWS::KMS::Key.EnableKeyRotation``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-enablekeyrotation
        """
        return self._values.get('enable_key_rotation')

    @builtins.property
    def key_usage(self) -> typing.Optional[str]:
        """``AWS::KMS::Key.KeyUsage``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-keyusage
        """
        return self._values.get('key_usage')

    @builtins.property
    def pending_window_in_days(self) -> typing.Optional[jsii.Number]:
        """``AWS::KMS::Key.PendingWindowInDays``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-pendingwindowindays
        """
        return self._values.get('pending_window_in_days')

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::KMS::Key.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-tags
        """
        return self._values.get('tags')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CfnKeyProps(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.interface(jsii_type="monocdk-experiment.aws_kms.IKey")
class IKey(_IResource_72f7ee7e, jsii.compat.Protocol):
    """A KMS Key, either managed by this CDK app, or imported.

    stability
    :stability: experimental
    """
    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IKeyProxy

    @builtins.property
    @jsii.member(jsii_name="keyArn")
    def key_arn(self) -> str:
        """The ARN of the key.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        ...

    @builtins.property
    @jsii.member(jsii_name="keyId")
    def key_id(self) -> str:
        """The ID of the key (the part that looks something like: 1234abcd-12ab-34cd-56ef-1234567890ab).

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        ...

    @jsii.member(jsii_name="addAlias")
    def add_alias(self, alias: str) -> "Alias":
        """Defines a new alias for the key.

        :param alias: -

        stability
        :stability: experimental
        """
        ...

    @jsii.member(jsii_name="addToResourcePolicy")
    def add_to_resource_policy(self, statement: _PolicyStatement_f75dc775, allow_no_op: typing.Optional[bool]=None) -> _AddToResourcePolicyResult_d2a345d1:
        """Adds a statement to the KMS key resource policy.

        :param statement: The policy statement to add.
        :param allow_no_op: If this is set to ``false`` and there is no policy defined (i.e. external key), the operation will fail. Otherwise, it will no-op.

        stability
        :stability: experimental
        """
        ...

    @jsii.member(jsii_name="grant")
    def grant(self, grantee: _IGrantable_0fcfc53a, *actions: str) -> _Grant_96af6d2d:
        """Grant the indicated permissions on this key to the given principal.

        :param grantee: -
        :param actions: -

        stability
        :stability: experimental
        """
        ...

    @jsii.member(jsii_name="grantDecrypt")
    def grant_decrypt(self, grantee: _IGrantable_0fcfc53a) -> _Grant_96af6d2d:
        """Grant decryption permisisons using this key to the given principal.

        :param grantee: -

        stability
        :stability: experimental
        """
        ...

    @jsii.member(jsii_name="grantEncrypt")
    def grant_encrypt(self, grantee: _IGrantable_0fcfc53a) -> _Grant_96af6d2d:
        """Grant encryption permisisons using this key to the given principal.

        :param grantee: -

        stability
        :stability: experimental
        """
        ...

    @jsii.member(jsii_name="grantEncryptDecrypt")
    def grant_encrypt_decrypt(self, grantee: _IGrantable_0fcfc53a) -> _Grant_96af6d2d:
        """Grant encryption and decryption permisisons using this key to the given principal.

        :param grantee: -

        stability
        :stability: experimental
        """
        ...


class _IKeyProxy(jsii.proxy_for(_IResource_72f7ee7e)):
    """A KMS Key, either managed by this CDK app, or imported.

    stability
    :stability: experimental
    """
    __jsii_type__ = "monocdk-experiment.aws_kms.IKey"
    @builtins.property
    @jsii.member(jsii_name="keyArn")
    def key_arn(self) -> str:
        """The ARN of the key.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        return jsii.get(self, "keyArn")

    @builtins.property
    @jsii.member(jsii_name="keyId")
    def key_id(self) -> str:
        """The ID of the key (the part that looks something like: 1234abcd-12ab-34cd-56ef-1234567890ab).

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        return jsii.get(self, "keyId")

    @jsii.member(jsii_name="addAlias")
    def add_alias(self, alias: str) -> "Alias":
        """Defines a new alias for the key.

        :param alias: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "addAlias", [alias])

    @jsii.member(jsii_name="addToResourcePolicy")
    def add_to_resource_policy(self, statement: _PolicyStatement_f75dc775, allow_no_op: typing.Optional[bool]=None) -> _AddToResourcePolicyResult_d2a345d1:
        """Adds a statement to the KMS key resource policy.

        :param statement: The policy statement to add.
        :param allow_no_op: If this is set to ``false`` and there is no policy defined (i.e. external key), the operation will fail. Otherwise, it will no-op.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "addToResourcePolicy", [statement, allow_no_op])

    @jsii.member(jsii_name="grant")
    def grant(self, grantee: _IGrantable_0fcfc53a, *actions: str) -> _Grant_96af6d2d:
        """Grant the indicated permissions on this key to the given principal.

        :param grantee: -
        :param actions: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "grant", [grantee, *actions])

    @jsii.member(jsii_name="grantDecrypt")
    def grant_decrypt(self, grantee: _IGrantable_0fcfc53a) -> _Grant_96af6d2d:
        """Grant decryption permisisons using this key to the given principal.

        :param grantee: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "grantDecrypt", [grantee])

    @jsii.member(jsii_name="grantEncrypt")
    def grant_encrypt(self, grantee: _IGrantable_0fcfc53a) -> _Grant_96af6d2d:
        """Grant encryption permisisons using this key to the given principal.

        :param grantee: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "grantEncrypt", [grantee])

    @jsii.member(jsii_name="grantEncryptDecrypt")
    def grant_encrypt_decrypt(self, grantee: _IGrantable_0fcfc53a) -> _Grant_96af6d2d:
        """Grant encryption and decryption permisisons using this key to the given principal.

        :param grantee: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "grantEncryptDecrypt", [grantee])


@jsii.implements(IKey)
class Key(_Resource_884d0774, metaclass=jsii.JSIIMeta, jsii_type="monocdk-experiment.aws_kms.Key"):
    """Defines a KMS key.

    stability
    :stability: experimental
    resource:
    :resource:: AWS::KMS::Key
    """
    def __init__(self, scope: _Construct_f50a3f53, id: str, *, alias: typing.Optional[str]=None, description: typing.Optional[str]=None, enabled: typing.Optional[bool]=None, enable_key_rotation: typing.Optional[bool]=None, policy: typing.Optional[_PolicyDocument_1d1bca11]=None, removal_policy: typing.Optional[_RemovalPolicy_5986e9f3]=None, trust_account_identities: typing.Optional[bool]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param alias: Initial alias to add to the key. More aliases can be added later by calling ``addAlias``. Default: - No alias is added for the key.
        :param description: A description of the key. Use a description that helps your users decide whether the key is appropriate for a particular task. Default: - No description.
        :param enabled: Indicates whether the key is available for use. Default: - Key is enabled.
        :param enable_key_rotation: Indicates whether AWS KMS rotates the key. Default: false
        :param policy: Custom policy document to attach to the KMS key. Default: - A policy document with permissions for the account root to administer the key will be created.
        :param removal_policy: Whether the encryption key should be retained when it is removed from the Stack. This is useful when one wants to retain access to data that was encrypted with a key that is being retired. Default: RemovalPolicy.Retain
        :param trust_account_identities: Whether the key usage can be granted by IAM policies. Setting this to true adds a default statement which delegates key access control completely to the identity's IAM policy (similar to how it works for other AWS resources). Default: false

        stability
        :stability: experimental
        """
        props = KeyProps(alias=alias, description=description, enabled=enabled, enable_key_rotation=enable_key_rotation, policy=policy, removal_policy=removal_policy, trust_account_identities=trust_account_identities)

        jsii.create(Key, self, [scope, id, props])

    @jsii.member(jsii_name="fromKeyArn")
    @builtins.classmethod
    def from_key_arn(cls, scope: _Construct_f50a3f53, id: str, key_arn: str) -> "IKey":
        """Import an externally defined KMS Key using its ARN.

        :param scope: the construct that will "own" the imported key.
        :param id: the id of the imported key in the construct tree.
        :param key_arn: the ARN of an existing KMS key.

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "fromKeyArn", [scope, id, key_arn])

    @jsii.member(jsii_name="addAlias")
    def add_alias(self, alias_name: str) -> "Alias":
        """Defines a new alias for the key.

        :param alias_name: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "addAlias", [alias_name])

    @jsii.member(jsii_name="addToResourcePolicy")
    def add_to_resource_policy(self, statement: _PolicyStatement_f75dc775, allow_no_op: typing.Optional[bool]=None) -> _AddToResourcePolicyResult_d2a345d1:
        """Adds a statement to the KMS key resource policy.

        :param statement: The policy statement to add.
        :param allow_no_op: If this is set to ``false`` and there is no policy defined (i.e. external key), the operation will fail. Otherwise, it will no-op.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "addToResourcePolicy", [statement, allow_no_op])

    @jsii.member(jsii_name="grant")
    def grant(self, grantee: _IGrantable_0fcfc53a, *actions: str) -> _Grant_96af6d2d:
        """Grant the indicated permissions on this key to the given principal.

        This modifies both the principal's policy as well as the resource policy,
        since the default CloudFormation setup for KMS keys is that the policy
        must not be empty and so default grants won't work.

        :param grantee: -
        :param actions: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "grant", [grantee, *actions])

    @jsii.member(jsii_name="grantDecrypt")
    def grant_decrypt(self, grantee: _IGrantable_0fcfc53a) -> _Grant_96af6d2d:
        """Grant decryption permisisons using this key to the given principal.

        :param grantee: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "grantDecrypt", [grantee])

    @jsii.member(jsii_name="grantEncrypt")
    def grant_encrypt(self, grantee: _IGrantable_0fcfc53a) -> _Grant_96af6d2d:
        """Grant encryption permisisons using this key to the given principal.

        :param grantee: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "grantEncrypt", [grantee])

    @jsii.member(jsii_name="grantEncryptDecrypt")
    def grant_encrypt_decrypt(self, grantee: _IGrantable_0fcfc53a) -> _Grant_96af6d2d:
        """Grant encryption and decryption permisisons using this key to the given principal.

        :param grantee: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "grantEncryptDecrypt", [grantee])

    @builtins.property
    @jsii.member(jsii_name="keyArn")
    def key_arn(self) -> str:
        """The ARN of the key.

        stability
        :stability: experimental
        """
        return jsii.get(self, "keyArn")

    @builtins.property
    @jsii.member(jsii_name="keyId")
    def key_id(self) -> str:
        """The ID of the key (the part that looks something like: 1234abcd-12ab-34cd-56ef-1234567890ab).

        stability
        :stability: experimental
        """
        return jsii.get(self, "keyId")

    @builtins.property
    @jsii.member(jsii_name="trustAccountIdentities")
    def _trust_account_identities(self) -> bool:
        """Optional property to control trusting account identities.

        If specified grants will default identity policies instead of to both
        resource and identity policies.

        stability
        :stability: experimental
        """
        return jsii.get(self, "trustAccountIdentities")

    @builtins.property
    @jsii.member(jsii_name="policy")
    def _policy(self) -> typing.Optional[_PolicyDocument_1d1bca11]:
        """Optional policy document that represents the resource policy of this key.

        If specified, addToResourcePolicy can be used to edit this policy.
        Otherwise this method will no-op.

        stability
        :stability: experimental
        """
        return jsii.get(self, "policy")


@jsii.data_type(jsii_type="monocdk-experiment.aws_kms.KeyProps", jsii_struct_bases=[], name_mapping={'alias': 'alias', 'description': 'description', 'enabled': 'enabled', 'enable_key_rotation': 'enableKeyRotation', 'policy': 'policy', 'removal_policy': 'removalPolicy', 'trust_account_identities': 'trustAccountIdentities'})
class KeyProps():
    def __init__(self, *, alias: typing.Optional[str]=None, description: typing.Optional[str]=None, enabled: typing.Optional[bool]=None, enable_key_rotation: typing.Optional[bool]=None, policy: typing.Optional[_PolicyDocument_1d1bca11]=None, removal_policy: typing.Optional[_RemovalPolicy_5986e9f3]=None, trust_account_identities: typing.Optional[bool]=None) -> None:
        """Construction properties for a KMS Key object.

        :param alias: Initial alias to add to the key. More aliases can be added later by calling ``addAlias``. Default: - No alias is added for the key.
        :param description: A description of the key. Use a description that helps your users decide whether the key is appropriate for a particular task. Default: - No description.
        :param enabled: Indicates whether the key is available for use. Default: - Key is enabled.
        :param enable_key_rotation: Indicates whether AWS KMS rotates the key. Default: false
        :param policy: Custom policy document to attach to the KMS key. Default: - A policy document with permissions for the account root to administer the key will be created.
        :param removal_policy: Whether the encryption key should be retained when it is removed from the Stack. This is useful when one wants to retain access to data that was encrypted with a key that is being retired. Default: RemovalPolicy.Retain
        :param trust_account_identities: Whether the key usage can be granted by IAM policies. Setting this to true adds a default statement which delegates key access control completely to the identity's IAM policy (similar to how it works for other AWS resources). Default: false

        stability
        :stability: experimental
        """
        self._values = {
        }
        if alias is not None: self._values["alias"] = alias
        if description is not None: self._values["description"] = description
        if enabled is not None: self._values["enabled"] = enabled
        if enable_key_rotation is not None: self._values["enable_key_rotation"] = enable_key_rotation
        if policy is not None: self._values["policy"] = policy
        if removal_policy is not None: self._values["removal_policy"] = removal_policy
        if trust_account_identities is not None: self._values["trust_account_identities"] = trust_account_identities

    @builtins.property
    def alias(self) -> typing.Optional[str]:
        """Initial alias to add to the key.

        More aliases can be added later by calling ``addAlias``.

        default
        :default: - No alias is added for the key.

        stability
        :stability: experimental
        """
        return self._values.get('alias')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """A description of the key.

        Use a description that helps your users decide
        whether the key is appropriate for a particular task.

        default
        :default: - No description.

        stability
        :stability: experimental
        """
        return self._values.get('description')

    @builtins.property
    def enabled(self) -> typing.Optional[bool]:
        """Indicates whether the key is available for use.

        default
        :default: - Key is enabled.

        stability
        :stability: experimental
        """
        return self._values.get('enabled')

    @builtins.property
    def enable_key_rotation(self) -> typing.Optional[bool]:
        """Indicates whether AWS KMS rotates the key.

        default
        :default: false

        stability
        :stability: experimental
        """
        return self._values.get('enable_key_rotation')

    @builtins.property
    def policy(self) -> typing.Optional[_PolicyDocument_1d1bca11]:
        """Custom policy document to attach to the KMS key.

        default
        :default:

        - A policy document with permissions for the account root to
          administer the key will be created.

        stability
        :stability: experimental
        """
        return self._values.get('policy')

    @builtins.property
    def removal_policy(self) -> typing.Optional[_RemovalPolicy_5986e9f3]:
        """Whether the encryption key should be retained when it is removed from the Stack.

        This is useful when one wants to
        retain access to data that was encrypted with a key that is being retired.

        default
        :default: RemovalPolicy.Retain

        stability
        :stability: experimental
        """
        return self._values.get('removal_policy')

    @builtins.property
    def trust_account_identities(self) -> typing.Optional[bool]:
        """Whether the key usage can be granted by IAM policies.

        Setting this to true adds a default statement which delegates key
        access control completely to the identity's IAM policy (similar
        to how it works for other AWS resources).

        default
        :default: false

        see
        :see: https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam
        stability
        :stability: experimental
        """
        return self._values.get('trust_account_identities')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'KeyProps(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class ViaServicePrincipal(_PrincipalBase_e4459eeb, metaclass=jsii.JSIIMeta, jsii_type="monocdk-experiment.aws_kms.ViaServicePrincipal"):
    """A principal to allow access to a key if it's being used through another AWS service.

    stability
    :stability: experimental
    """
    def __init__(self, service_name: str, base_principal: typing.Optional[_IPrincipal_97126874]=None) -> None:
        """
        :param service_name: -
        :param base_principal: -

        stability
        :stability: experimental
        """
        jsii.create(ViaServicePrincipal, self, [service_name, base_principal])

    @builtins.property
    @jsii.member(jsii_name="policyFragment")
    def policy_fragment(self) -> _PrincipalPolicyFragment_621f702c:
        """Return the policy fragment that identifies this principal in a Policy.

        stability
        :stability: experimental
        """
        return jsii.get(self, "policyFragment")


@jsii.interface(jsii_type="monocdk-experiment.aws_kms.IAlias")
class IAlias(IKey, jsii.compat.Protocol):
    """A KMS Key alias.

    An alias can be used in all places that expect a key.

    stability
    :stability: experimental
    """
    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IAliasProxy

    @builtins.property
    @jsii.member(jsii_name="aliasName")
    def alias_name(self) -> str:
        """The name of the alias.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        ...

    @builtins.property
    @jsii.member(jsii_name="aliasTargetKey")
    def alias_target_key(self) -> "IKey":
        """The Key to which the Alias refers.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        ...


class _IAliasProxy(jsii.proxy_for(IKey)):
    """A KMS Key alias.

    An alias can be used in all places that expect a key.

    stability
    :stability: experimental
    """
    __jsii_type__ = "monocdk-experiment.aws_kms.IAlias"
    @builtins.property
    @jsii.member(jsii_name="aliasName")
    def alias_name(self) -> str:
        """The name of the alias.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        return jsii.get(self, "aliasName")

    @builtins.property
    @jsii.member(jsii_name="aliasTargetKey")
    def alias_target_key(self) -> "IKey":
        """The Key to which the Alias refers.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        return jsii.get(self, "aliasTargetKey")


@jsii.implements(IAlias)
class Alias(_Resource_884d0774, metaclass=jsii.JSIIMeta, jsii_type="monocdk-experiment.aws_kms.Alias"):
    """Defines a display name for a customer master key (CMK) in AWS Key Management Service (AWS KMS).

    Using an alias to refer to a key can help you simplify key
    management. For example, when rotating keys, you can just update the alias
    mapping instead of tracking and changing key IDs. For more information, see
    Working with Aliases in the AWS Key Management Service Developer Guide.

    You can also add an alias for a key by calling ``key.addAlias(alias)``.

    stability
    :stability: experimental
    resource:
    :resource:: AWS::KMS::Alias
    """
    def __init__(self, scope: _Construct_f50a3f53, id: str, *, alias_name: str, target_key: "IKey", removal_policy: typing.Optional[_RemovalPolicy_5986e9f3]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param alias_name: The name of the alias. The name must start with alias followed by a forward slash, such as alias/. You can't specify aliases that begin with alias/AWS. These aliases are reserved.
        :param target_key: The ID of the key for which you are creating the alias. Specify the key's globally unique identifier or Amazon Resource Name (ARN). You can't specify another alias.
        :param removal_policy: Policy to apply when the alias is removed from this stack. Default: - The alias will be deleted

        stability
        :stability: experimental
        """
        props = AliasProps(alias_name=alias_name, target_key=target_key, removal_policy=removal_policy)

        jsii.create(Alias, self, [scope, id, props])

    @jsii.member(jsii_name="fromAliasAttributes")
    @builtins.classmethod
    def from_alias_attributes(cls, scope: _Construct_f50a3f53, id: str, *, alias_name: str, alias_target_key: "IKey") -> "IAlias":
        """Import an existing KMS Alias defined outside the CDK app.

        :param scope: The parent creating construct (usually ``this``).
        :param id: The construct's name.
        :param alias_name: Specifies the alias name. This value must begin with alias/ followed by a name (i.e. alias/ExampleAlias)
        :param alias_target_key: The customer master key (CMK) to which the Alias refers.

        stability
        :stability: experimental
        """
        attrs = AliasAttributes(alias_name=alias_name, alias_target_key=alias_target_key)

        return jsii.sinvoke(cls, "fromAliasAttributes", [scope, id, attrs])

    @jsii.member(jsii_name="addAlias")
    def add_alias(self, alias: str) -> "Alias":
        """Defines a new alias for the key.

        :param alias: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "addAlias", [alias])

    @jsii.member(jsii_name="addToResourcePolicy")
    def add_to_resource_policy(self, statement: _PolicyStatement_f75dc775, allow_no_op: typing.Optional[bool]=None) -> _AddToResourcePolicyResult_d2a345d1:
        """Adds a statement to the KMS key resource policy.

        :param statement: -
        :param allow_no_op: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "addToResourcePolicy", [statement, allow_no_op])

    @jsii.member(jsii_name="generatePhysicalName")
    def _generate_physical_name(self) -> str:
        """
        stability
        :stability: experimental
        """
        return jsii.invoke(self, "generatePhysicalName", [])

    @jsii.member(jsii_name="grant")
    def grant(self, grantee: _IGrantable_0fcfc53a, *actions: str) -> _Grant_96af6d2d:
        """Grant the indicated permissions on this key to the given principal.

        :param grantee: -
        :param actions: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "grant", [grantee, *actions])

    @jsii.member(jsii_name="grantDecrypt")
    def grant_decrypt(self, grantee: _IGrantable_0fcfc53a) -> _Grant_96af6d2d:
        """Grant decryption permisisons using this key to the given principal.

        :param grantee: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "grantDecrypt", [grantee])

    @jsii.member(jsii_name="grantEncrypt")
    def grant_encrypt(self, grantee: _IGrantable_0fcfc53a) -> _Grant_96af6d2d:
        """Grant encryption permisisons using this key to the given principal.

        :param grantee: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "grantEncrypt", [grantee])

    @jsii.member(jsii_name="grantEncryptDecrypt")
    def grant_encrypt_decrypt(self, grantee: _IGrantable_0fcfc53a) -> _Grant_96af6d2d:
        """Grant encryption and decryption permisisons using this key to the given principal.

        :param grantee: -

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "grantEncryptDecrypt", [grantee])

    @builtins.property
    @jsii.member(jsii_name="aliasName")
    def alias_name(self) -> str:
        """The name of the alias.

        stability
        :stability: experimental
        """
        return jsii.get(self, "aliasName")

    @builtins.property
    @jsii.member(jsii_name="aliasTargetKey")
    def alias_target_key(self) -> "IKey":
        """The Key to which the Alias refers.

        stability
        :stability: experimental
        """
        return jsii.get(self, "aliasTargetKey")

    @builtins.property
    @jsii.member(jsii_name="keyArn")
    def key_arn(self) -> str:
        """The ARN of the key.

        stability
        :stability: experimental
        """
        return jsii.get(self, "keyArn")

    @builtins.property
    @jsii.member(jsii_name="keyId")
    def key_id(self) -> str:
        """The ID of the key (the part that looks something like: 1234abcd-12ab-34cd-56ef-1234567890ab).

        stability
        :stability: experimental
        """
        return jsii.get(self, "keyId")


__all__ = [
    "Alias",
    "AliasAttributes",
    "AliasProps",
    "CfnAlias",
    "CfnAliasProps",
    "CfnKey",
    "CfnKeyProps",
    "IAlias",
    "IKey",
    "Key",
    "KeyProps",
    "ViaServicePrincipal",
]

publication.publish()
