/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import com.google.common.collect.Maps;
import java.util.Map;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AlignmentUtils;
import org.jf.dexlib2.util.AnnotatedBytes;

public abstract class SectionAnnotator {
    public final DexAnnotator annotator;
    public final DexBackedDexFile dexFile;
    public final int itemType;
    public final int sectionOffset;
    public final int itemCount;
    protected Map<Integer, String> itemIdentities = Maps.newHashMap();

    public SectionAnnotator(DexAnnotator annotator, MapItem mapItem) {
        this.annotator = annotator;
        this.dexFile = annotator.dexFile;
        this.itemType = mapItem.getType();
        this.sectionOffset = mapItem.getType() >= 4096 ? mapItem.getOffset() + this.dexFile.getBaseDataOffset() : mapItem.getOffset();
        this.itemCount = mapItem.getItemCount();
    }

    public abstract String getItemName();

    protected abstract void annotateItem(AnnotatedBytes var1, int var2, String var3);

    public void annotateSection(AnnotatedBytes out) {
        out.moveTo(this.sectionOffset);
        this.annotateSectionInner(out, this.itemCount);
    }

    protected int getItemOffset(int itemIndex, int currentOffset) {
        return AlignmentUtils.alignOffset(currentOffset, this.getItemAlignment());
    }

    protected void annotateSectionInner(AnnotatedBytes out, int itemCount) {
        String itemName = this.getItemName();
        if (itemCount > 0) {
            out.annotate(0, "", new Object[0]);
            out.annotate(0, "-----------------------------", new Object[0]);
            out.annotate(0, "%s section", itemName);
            out.annotate(0, "-----------------------------", new Object[0]);
            out.annotate(0, "", new Object[0]);
            for (int i = 0; i < itemCount; ++i) {
                out.moveTo(this.getItemOffset(i, out.getCursor()));
                String itemIdentity = this.getItemIdentity(out.getCursor());
                if (itemIdentity != null) {
                    out.annotate(0, "[%d] %s: %s", i, itemName, itemIdentity);
                } else {
                    out.annotate(0, "[%d] %s", i, itemName);
                }
                out.indent();
                this.annotateItem(out, i, itemIdentity);
                out.deindent();
            }
        }
    }

    private String getItemIdentity(int itemOffset) {
        return this.itemIdentities.get(itemOffset);
    }

    public void setItemIdentity(int itemOffset, String identity) {
        this.itemIdentities.put(itemOffset + this.dexFile.getBaseDataOffset(), identity);
    }

    public int getItemAlignment() {
        return 1;
    }
}

