/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.StringIdItem;
import org.jf.dexlib2.dexbacked.raw.TypeIdItem;
import org.jf.dexlib2.dexbacked.raw.TypeListItem;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class ProtoIdItem {
    public static SectionAnnotator makeAnnotator(DexAnnotator annotator, MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            public String getItemName() {
                return "proto_id_item";
            }

            @Override
            protected void annotateItem(AnnotatedBytes out, int itemIndex, String itemIdentity) {
                int shortyIndex = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, "shorty_idx = %s", StringIdItem.getReferenceAnnotation(this.dexFile, shortyIndex));
                int returnTypeIndex = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, "return_type_idx = %s", TypeIdItem.getReferenceAnnotation(this.dexFile, returnTypeIndex));
                int parametersOffset = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, "parameters_off = %s", TypeListItem.getReferenceAnnotation(this.dexFile, parametersOffset));
            }
        };
    }

    public static String getReferenceAnnotation(DexBackedDexFile dexFile, int protoIndex) {
        try {
            String protoString = ProtoIdItem.asString(dexFile, protoIndex);
            return String.format("proto_id_item[%d]: %s", protoIndex, protoString);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return String.format("proto_id_item[%d]", protoIndex);
        }
    }

    public static String asString(DexBackedDexFile dexFile, int protoIndex) {
        int offset = dexFile.getProtoSection().getOffset(protoIndex);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int parametersOffset = dexFile.getBuffer().readSmallUint(offset + 8);
        sb.append(TypeListItem.asString(dexFile, parametersOffset));
        sb.append(")");
        int returnTypeIndex = dexFile.getBuffer().readSmallUint(offset + 4);
        String returnType = (String)dexFile.getTypeSection().get(returnTypeIndex);
        sb.append(returnType);
        return sb.toString();
    }
}

