/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.MethodHandleType;
import org.jf.dexlib2.dexbacked.raw.FieldIdItem;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.MethodIdItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;
import org.jf.util.ExceptionWithContext;

public class MethodHandleItem {
    public static SectionAnnotator makeAnnotator(DexAnnotator annotator, MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            public String getItemName() {
                return "method_handle_item";
            }

            @Override
            protected void annotateItem(AnnotatedBytes out, int itemIndex, String itemIdentity) {
                String fieldOrMethodDescriptor;
                int methodHandleType = this.dexFile.getBuffer().readUshort(out.getCursor());
                out.annotate(2, "type = %s", MethodHandleType.toString(methodHandleType));
                out.annotate(2, "unused", new Object[0]);
                int fieldOrMethodId = this.dexFile.getBuffer().readUshort(out.getCursor());
                switch (methodHandleType) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        fieldOrMethodDescriptor = FieldIdItem.getReferenceAnnotation(this.dexFile, fieldOrMethodId);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        fieldOrMethodDescriptor = MethodIdItem.getReferenceAnnotation(this.dexFile, fieldOrMethodId);
                        break;
                    }
                    default: {
                        throw new ExceptionWithContext("Invalid method handle type: %d", methodHandleType);
                    }
                }
                out.annotate(2, "field_or_method_id = %s", fieldOrMethodDescriptor);
                out.annotate(2, "unused", new Object[0]);
            }
        };
    }
}

