/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public enum HiddenApiRestriction {
    WHITELIST(0, "whitelist", false),
    GREYLIST(1, "greylist", false),
    BLACKLIST(2, "blacklist", false),
    GREYLIST_MAX_O(3, "greylist-max-o", false),
    GREYLIST_MAX_P(4, "greylist-max-p", false),
    GREYLIST_MAX_Q(5, "greylist-max-q", false),
    CORE_PLATFORM_API(8, "core-platform-api", true),
    TEST_API(16, "test-api", true);

    private static final HiddenApiRestriction[] hiddenApiFlags;
    private static final HiddenApiRestriction[] domainSpecificApiFlags;
    private static final Map<String, HiddenApiRestriction> hiddenApiRestrictionsByName;
    private final int value;
    private final String name;
    private final boolean isDomainSpecificApiFlag;

    private HiddenApiRestriction(int value, String name, boolean isDomainSpecificApiFlag) {
        this.value = value;
        this.name = name;
        this.isDomainSpecificApiFlag = isDomainSpecificApiFlag;
    }

    public String toString() {
        return this.name;
    }

    public boolean isSet(int value) {
        if (this.isDomainSpecificApiFlag) {
            return (value & this.value) != 0;
        }
        return (value & 7) == this.value;
    }

    public static Set<HiddenApiRestriction> getAllFlags(int value) {
        HiddenApiRestriction normalRestriction = hiddenApiFlags[value & 7];
        int domainSpecificPart = value & 0xFFFFFFF8;
        if (domainSpecificPart == 0) {
            return ImmutableSet.of(normalRestriction);
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)normalRestriction);
        for (HiddenApiRestriction domainSpecificApiFlag : domainSpecificApiFlags) {
            if (!domainSpecificApiFlag.isSet(value)) continue;
            builder.add((Object)domainSpecificApiFlag);
        }
        return builder.build();
    }

    public static String formatHiddenRestrictions(int value) {
        StringJoiner joiner = new StringJoiner("|");
        for (HiddenApiRestriction hiddenApiRestriction : HiddenApiRestriction.getAllFlags(value)) {
            joiner.add(hiddenApiRestriction.toString());
        }
        return joiner.toString();
    }

    static {
        hiddenApiFlags = new HiddenApiRestriction[]{WHITELIST, GREYLIST, BLACKLIST, GREYLIST_MAX_O, GREYLIST_MAX_P, GREYLIST_MAX_Q};
        domainSpecificApiFlags = new HiddenApiRestriction[]{CORE_PLATFORM_API, TEST_API};
        hiddenApiRestrictionsByName = new HashMap<String, HiddenApiRestriction>();
        for (HiddenApiRestriction hiddenApiRestriction : HiddenApiRestriction.values()) {
            hiddenApiRestrictionsByName.put(hiddenApiRestriction.toString(), hiddenApiRestriction);
        }
    }
}

