/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.jf.util.jcommander.Command;
import org.jf.util.jcommander.ExtendedParameter;

public abstract class DexInputCommand
extends Command {
    @Parameter(names={"-a", "--api"}, description="The numeric api level of the file being disassembled.")
    @ExtendedParameter(argumentNames={"api"})
    public int apiLevel = -1;
    @Parameter(description="A dex/apk/oat/odex file. For apk or oat files that contain multiple dex files, you can specify the specific entry to use as if the apk/oat file was a directory. e.g. \"app.apk/classes2.dex\". For more information, see \"baksmali help input\".")
    @ExtendedParameter(argumentNames={"file"})
    protected List<String> inputList = Lists.newArrayList();
    protected File inputFile;
    protected String inputEntry;
    protected MultiDexContainer.DexEntry<? extends DexBackedDexFile> dexEntry;
    protected DexBackedDexFile dexFile;

    public DexInputCommand(List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    protected void loadDexFile(String input) {
        block15: {
            File file;
            for (file = new File(input); file != null && !file.exists(); file = file.getParentFile()) {
            }
            if (file == null || !file.exists() || file.isDirectory()) {
                System.err.println("Can't find file: " + input);
                System.exit(1);
            }
            this.inputFile = file;
            String dexEntryName = null;
            if (file.getPath().length() < input.length()) {
                dexEntryName = input.substring(file.getPath().length() + 1);
            }
            Opcodes opcodes = null;
            if (this.apiLevel != -1) {
                opcodes = Opcodes.forApi(this.apiLevel);
            }
            if (!Strings.isNullOrEmpty(dexEntryName)) {
                boolean exactMatch = false;
                if (dexEntryName.length() > 2 && dexEntryName.charAt(0) == '\"' && dexEntryName.charAt(dexEntryName.length() - 1) == '\"') {
                    dexEntryName = dexEntryName.substring(1, dexEntryName.length() - 1);
                    exactMatch = true;
                }
                this.inputEntry = dexEntryName;
                try {
                    this.dexEntry = DexFileFactory.loadDexEntry(file, dexEntryName, exactMatch, opcodes);
                    this.dexFile = this.dexEntry.getDexFile();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                MultiDexContainer<? extends DexBackedDexFile> container = DexFileFactory.loadDexContainer(file, opcodes);
                if (container.getDexEntryNames().size() == 1) {
                    this.dexEntry = container.getEntry(container.getDexEntryNames().get(0));
                    assert (this.dexEntry != null);
                    this.dexFile = this.dexEntry.getDexFile();
                    break block15;
                }
                if (container.getDexEntryNames().size() > 1) {
                    this.dexEntry = container.getEntry("classes.dex");
                    if (this.dexEntry == null) {
                        this.dexEntry = container.getEntry(container.getDexEntryNames().get(0));
                    }
                    assert (this.dexEntry != null);
                    this.dexFile = this.dexEntry.getDexFile();
                    break block15;
                }
                throw new RuntimeException(String.format("\"%s\" has no dex files", input));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

