/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.reader.zip.ZipUtil;
import com.googlecode.d2j.signapk.SunJarSignImpl;
import com.googlecode.d2j.signapk.TinySignImpl;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;

@BaseCmd.Syntax(cmd="d2j-apk-sign", syntax="[options] <apk>", desc="Sign an android apk file use a test certificate.")
public class ApkSign
extends BaseCmd {
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .apk file, default is $current_dir/[apk-name]-signed.apk", argName="out-apk-file")
    private Path output;
    @BaseCmd.Opt(opt="t", longOpt="tiny", hasArg=false, description="use tiny sign")
    private boolean tiny = false;

    public static void main(String ... args) {
        new ApkSign().doMain(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        Path apkIn = new File(this.remainingArgs[0]).toPath();
        if (!Files.exists(apkIn, new LinkOption[0])) {
            System.err.println(apkIn + " is not exists");
            this.usage();
            return;
        }
        if (this.output == null) {
            this.output = Files.isDirectory(apkIn, new LinkOption[0]) ? new File(apkIn.getFileName() + "-signed.apk").toPath() : new File(ApkSign.getBaseName((String)apkIn.getFileName().toString()) + "-signed.apk").toPath();
        }
        if (Files.exists(this.output, new LinkOption[0]) && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            this.usage();
            return;
        }
        Path tmp = null;
        try {
            void var4_8;
            Path realJar;
            if (Files.isDirectory(apkIn, new LinkOption[0])) {
                tmp = realJar = Files.createTempFile("d2j", ".jar", new FileAttribute[0]);
                System.out.println("zipping " + apkIn + " -> " + realJar);
                try (FileSystem fileSystem = ApkSign.createZip((Path)realJar);){
                    final Path outRoot = fileSystem.getPath("/", new String[0]);
                    ApkSign.walkJarOrDir((Path)apkIn, (BaseCmd.FileVisitorX)new BaseCmd.FileVisitorX(){

                        public void visitFile(Path file, String relative) throws IOException {
                            Path target = outRoot.resolve(relative);
                            BaseCmd.createParentDirectories((Path)target);
                            Files.copy(file, target, new CopyOption[0]);
                        }
                    });
                }
            } else {
                realJar = apkIn;
            }
            if (this.tiny) {
                TinySignImpl tinySignImpl = new TinySignImpl();
            } else {
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(ApkSign.class.getResourceAsStream("ApkSign.cer"));
                    KeyFactory rSAKeyFactory = KeyFactory.getInstance("RSA");
                    PrivateKey privateKey = rSAKeyFactory.generatePrivate(new PKCS8EncodedKeySpec(ZipUtil.toByteArray((InputStream)ApkSign.class.getResourceAsStream("ApkSign.private"))));
                    SunJarSignImpl sunJarSignImpl = new SunJarSignImpl(cert, privateKey);
                }
                catch (Exception cnfe) {
                    TinySignImpl tinySignImpl = new TinySignImpl();
                }
            }
            var4_8.sign(apkIn.toFile(), this.output.toFile());
            System.out.println("sign " + realJar + " -> " + this.output);
            if (tmp == null) return;
        }
        catch (Throwable throwable) {
            if (tmp == null) throw throwable;
            Files.deleteIfExists(tmp);
            throw throwable;
        }
        Files.deleteIfExists(tmp);
    }
}

