"use strict";
const cdk = require("@aws-cdk/core");
const appmesh = require("../lib");
module.exports = {
    'Can export existing route and re-import'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const mesh = new appmesh.Mesh(stack, 'mesh', {
            meshName: 'test-mesh',
        });
        const router = new appmesh.VirtualRouter(stack, 'router', {
            mesh,
        });
        const service1 = new appmesh.VirtualService(stack, 'service-1', {
            virtualServiceName: 'service1.domain.local',
            mesh,
        });
        const node = mesh.addVirtualNode('test-node', {
            dnsHostName: 'test',
            listener: {
                portMapping: {
                    port: 8080,
                    protocol: appmesh.Protocol.HTTP,
                },
            },
            backends: [
                service1,
            ],
        });
        const route = new appmesh.Route(stack, 'route-1', {
            mesh,
            virtualRouter: router,
            routeTargets: [
                {
                    virtualNode: node,
                    weight: 50,
                },
            ],
            prefix: '/',
        });
        const stack2 = new cdk.Stack();
        appmesh.Route.fromRouteName(stack2, 'imported-route', mesh.meshName, router.virtualRouterName, route.routeName);
        // Nothing to do with imported route yet
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5yb3V0ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRlc3Qucm91dGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLHFDQUFxQztBQUdyQyxrQ0FBa0M7QUFFbEMsaUJBQVM7SUFDUCx5Q0FBeUMsQ0FBQyxJQUFVO1FBQ2xELFFBQVE7UUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUU5QixPQUFPO1FBQ1AsTUFBTSxJQUFJLEdBQUcsSUFBSSxPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUU7WUFDM0MsUUFBUSxFQUFFLFdBQVc7U0FDdEIsQ0FBQyxDQUFDO1FBRUgsTUFBTSxNQUFNLEdBQUcsSUFBSSxPQUFPLENBQUMsYUFBYSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUU7WUFDeEQsSUFBSTtTQUNMLENBQUMsQ0FBQztRQUVILE1BQU0sUUFBUSxHQUFHLElBQUksT0FBTyxDQUFDLGNBQWMsQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFO1lBQzlELGtCQUFrQixFQUFFLHVCQUF1QjtZQUMzQyxJQUFJO1NBQ0wsQ0FBQyxDQUFDO1FBRUgsTUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxXQUFXLEVBQUU7WUFDNUMsV0FBVyxFQUFFLE1BQU07WUFDbkIsUUFBUSxFQUFFO2dCQUNSLFdBQVcsRUFDVDtvQkFDRSxJQUFJLEVBQUUsSUFBSTtvQkFDVixRQUFRLEVBQUUsT0FBTyxDQUFDLFFBQVEsQ0FBQyxJQUFJO2lCQUNoQzthQUNKO1lBQ0QsUUFBUSxFQUFFO2dCQUNSLFFBQVE7YUFDVDtTQUNGLENBQUMsQ0FBQztRQUVILE1BQU0sS0FBSyxHQUFHLElBQUksT0FBTyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsU0FBUyxFQUFFO1lBQ2hELElBQUk7WUFDSixhQUFhLEVBQUUsTUFBTTtZQUNyQixZQUFZLEVBQUU7Z0JBQ1o7b0JBQ0UsV0FBVyxFQUFFLElBQUk7b0JBQ2pCLE1BQU0sRUFBRSxFQUFFO2lCQUNYO2FBQ0Y7WUFDRCxNQUFNLEVBQUUsR0FBRztTQUNaLENBQUMsQ0FBQztRQUVILE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQy9CLE9BQU8sQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLE1BQU0sRUFBRSxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsUUFBUSxFQUFFLE1BQU0sQ0FBQyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUM7UUFFaEgsd0NBQXdDO1FBRXhDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgVGVzdCB9IGZyb20gJ25vZGV1bml0JztcblxuaW1wb3J0ICogYXMgYXBwbWVzaCBmcm9tICcuLi9saWInO1xuXG5leHBvcnQgPSB7XG4gICdDYW4gZXhwb3J0IGV4aXN0aW5nIHJvdXRlIGFuZCByZS1pbXBvcnQnKHRlc3Q6IFRlc3QpIHtcbiAgICAvLyBHSVZFTlxuICAgIGNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjaygpO1xuXG4gICAgLy8gV0hFTlxuICAgIGNvbnN0IG1lc2ggPSBuZXcgYXBwbWVzaC5NZXNoKHN0YWNrLCAnbWVzaCcsIHtcbiAgICAgIG1lc2hOYW1lOiAndGVzdC1tZXNoJyxcbiAgICB9KTtcblxuICAgIGNvbnN0IHJvdXRlciA9IG5ldyBhcHBtZXNoLlZpcnR1YWxSb3V0ZXIoc3RhY2ssICdyb3V0ZXInLCB7XG4gICAgICBtZXNoLFxuICAgIH0pO1xuXG4gICAgY29uc3Qgc2VydmljZTEgPSBuZXcgYXBwbWVzaC5WaXJ0dWFsU2VydmljZShzdGFjaywgJ3NlcnZpY2UtMScsIHtcbiAgICAgIHZpcnR1YWxTZXJ2aWNlTmFtZTogJ3NlcnZpY2UxLmRvbWFpbi5sb2NhbCcsXG4gICAgICBtZXNoLFxuICAgIH0pO1xuXG4gICAgY29uc3Qgbm9kZSA9IG1lc2guYWRkVmlydHVhbE5vZGUoJ3Rlc3Qtbm9kZScsIHtcbiAgICAgIGRuc0hvc3ROYW1lOiAndGVzdCcsXG4gICAgICBsaXN0ZW5lcjoge1xuICAgICAgICBwb3J0TWFwcGluZzpcbiAgICAgICAgICB7XG4gICAgICAgICAgICBwb3J0OiA4MDgwLFxuICAgICAgICAgICAgcHJvdG9jb2w6IGFwcG1lc2guUHJvdG9jb2wuSFRUUCxcbiAgICAgICAgICB9LFxuICAgICAgfSxcbiAgICAgIGJhY2tlbmRzOiBbXG4gICAgICAgIHNlcnZpY2UxLFxuICAgICAgXSxcbiAgICB9KTtcblxuICAgIGNvbnN0IHJvdXRlID0gbmV3IGFwcG1lc2guUm91dGUoc3RhY2ssICdyb3V0ZS0xJywge1xuICAgICAgbWVzaCxcbiAgICAgIHZpcnR1YWxSb3V0ZXI6IHJvdXRlcixcbiAgICAgIHJvdXRlVGFyZ2V0czogW1xuICAgICAgICB7XG4gICAgICAgICAgdmlydHVhbE5vZGU6IG5vZGUsXG4gICAgICAgICAgd2VpZ2h0OiA1MCxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgICBwcmVmaXg6ICcvJyxcbiAgICB9KTtcblxuICAgIGNvbnN0IHN0YWNrMiA9IG5ldyBjZGsuU3RhY2soKTtcbiAgICBhcHBtZXNoLlJvdXRlLmZyb21Sb3V0ZU5hbWUoc3RhY2syLCAnaW1wb3J0ZWQtcm91dGUnLCBtZXNoLm1lc2hOYW1lLCByb3V0ZXIudmlydHVhbFJvdXRlck5hbWUsIHJvdXRlLnJvdXRlTmFtZSk7XG5cbiAgICAvLyBOb3RoaW5nIHRvIGRvIHdpdGggaW1wb3J0ZWQgcm91dGUgeWV0XG5cbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcbn07XG4iXX0=