# Sobre GamesDB

GamesDB é uma classe Python que permite a busca de informações sobre jogos eletrônicos em um site com o mesmo nome. A classe usa as bibliotecas BeautifulSoup, requests e fuzzywuzzy.

A classe tem um método de busca de jogo pela identificação dele no site e um método busca por nome. Ambos retornam uma lista com um dicionário para cada jogo procurado ou apenas um dicionário se apenas um jogo for procurado. As seguintes informações do jogo são retornadas:

- id
- game_title
- overview
- genres
- esrb_rating
- trailer
- platform
- region
- developers
- publishers
- release_date
- players
- coop
- cover
- cover_thumb
- fanarts
- screenshots
- clearlogos

##Instalando
    pip install gamesdb-api

## Como usar

    >>> from gamesdb_api import GamesDB
    >>> gdb = GamesDB()
    
### Busca de jogo por identificador:

    >>> games = gbd.get_game_by_id('5')
    >>> print(games)

    {'id': '5', 'game_title': 'Donkey Kong', 'overview': "Can you save Mario's girl from the clutches of Donkey Kong? Donkey Kong has kidnapped Mario's girlfriend Pauline and taken her to the top of a construction site. It's up to you to help Mario save Pauline before time runs out. But it won't be easy. Donkey Kong will do everything in his power to stop you. He'll throw barrel bombs, flaming fireballs and anything else he can get his hands on. So if you're looking for action, don't monkey around. Get the original Donkey Kong from the Nintendo Arcade Classics Series!", 'platform': 'Nintendo Entertainment System (NES)', 'region': 'NTSC-U', 'developers': ['Nintendo R&D2'], 'publishers': ['Nintendo'], 'release_date': '1986-06-01', 'players': '2', 'coop': 'No', 'trailer': 'https://youtube.com/watch?v=C_PrG8P5W8o', 'esrb_rating': 'E - Everyone', 'genres': ['Platform'], 'cover': 'https://cdn.thegamesdb.net/images/original/boxart/front/5-2.jpg', 'cover_thumb': None, 'fanarts': ['https://cdn.thegamesdb.net/images/original/fanart/5-4.jpg', 'https://cdn.thegamesdb.net/images/original/fanart/5-1.jpg'], 'screenshots': ['https://cdn.thegamesdb.net/images/original/screenshots/5-1.jpg'], 'clearlogos': ['https://cdn.thegamesdb.net/images/original/clearlogo/5.png']}
Retorna um dicionário com informações do jogo 

    >>> lista = ['5','23','100']
    >>> games = gdb.get_game_by_id(lista)
    >>> for game in games:
    >>>     print (games)

    {'id': '5', 'game_title': 'Donkey Kong', 'overview': "Can you save Mario's girl from the clutches of Donkey Kong? Donkey Kong has kidnapped Mario's girlfriend Pauline and taken her to the top of a construction site. It's up to you to help Mario save Pauline before time runs out. But it won't be easy. Donkey Kong will do everything in his power to stop you. He'll throw barrel bombs, flaming fireballs and anything else he can get his hands on. So if you're looking for action, don't monkey around. Get the original Donkey Kong from the Nintendo Arcade Classics Series!", 'platform': 'Nintendo Entertainment System (NES)', 'region': 'NTSC-U', 'developers': ['Nintendo R&D2'], 'publishers': ['Nintendo'], 'release_date': '1986-06-01', 'players': '2', 'coop': 'No', 'trailer': 'https://youtube.com/watch?v=C_PrG8P5W8o', 'esrb_rating': 'E - Everyone', 'genres': ['Platform'], 'cover': 'https://cdn.thegamesdb.net/images/original/boxart/front/5-2.jpg', 'cover_thumb': None, 'fanarts': ['https://cdn.thegamesdb.net/images/original/fanart/5-4.jpg', 'https://cdn.thegamesdb.net/images/original/fanart/5-1.jpg'], 'screenshots': ['https://cdn.thegamesdb.net/images/original/screenshots/5-1.jpg'], 'clearlogos': ['https://cdn.thegamesdb.net/images/original/clearlogo/5.png']}
    {'id': '23', 'game_title': 'Gears of War', 'overview': 'The game focuses on the troops of Delta Squad as they fight to save the human inhabitants of the fictional planet Sera from a relentless subterranean enemy known as the Locust Horde. The player assumes the role of Marcus Fenix, a former prisoner and war-hardened soldier. The game is based on the use of cover and strategic fire for the player to advance through the scenarios; a second player can play cooperatively through the main campaign to assist. The game also features several online multiplayer game modes for up to eight players.', 'platform': 'PC', 'region': 'Region Not Set', 'developers': ['Epic'], 'publishers': ['Microsoft Studios'], 'release_date': '2006-11-07', 'players': '2', 'coop': 'Yes', 'trailer': 'https://youtube.com/watch?v=_D9r8Xm2aDw', 'esrb_rating': 'M - Mature 17+', 'genres': ['Shooter'], 'cover': 'https://cdn.thegamesdb.net/images/original/boxart/front/23-1.jpg', 'cover_thumb': None, 'fanarts': ['https://cdn.thegamesdb.net/images/original/fanart/23-1.jpg', 'https://cdn.thegamesdb.net/images/original/fanart/23-2.jpg'], 'screenshots': ['https://cdn.thegamesdb.net/images/original/screenshots/23-1.jpg'], 'clearlogos': []}
    {'id': '100', 'game_title': 'Spider-Man 3', 'overview': "The game's plot expands on the film by including additional characters and elements from the Spider-Man comics and the Marvel Universe. Depending on the platform, different villains from the comics are featured, but all versions of the game feature the film's main villains: Venom, New Goblin, and Sandman.", 'platform': 'Sony Playstation 3', 'region': 'Region Not Set', 'developers': ['Treyarch'], 'publishers': ['Activision'], 'release_date': '2007-05-04', 'players': '1', 'coop': 'No', 'trailer': 'https://youtube.com/watch?v=O4JB4B4RXpg', 'esrb_rating': 'T - Teen', 'genres': ['Action'], 'cover': 'https://cdn.thegamesdb.net/images/original/boxart/front/100-1.jpg', 'cover_thumb': None, 'fanarts': ['https://cdn.thegamesdb.net/images/original/fanart/100-1.jpg', 'https://cdn.thegamesdb.net/images/original/fanart/100-2.jpg', 'https://cdn.thegamesdb.net/images/original/fanart/100-3.jpg', 'https://cdn.thegamesdb.net/images/original/fanart/100-4.jpg'], 'screenshots': ['https://cdn.thegamesdb.net/images/original/screenshots/100-1.jpg'], 'clearlogos': ['https://cdn.thegamesdb.net/images/original/clearlogo/100.png']}
    
Retorna uma lista com um dicionário para jogo pesquisado.


### Busca de jogo por nome:

    >>> games = gdb.get_game_by_name('Super Mario World', 'Super Nintendo (SNES)')
    ou
    >>> games = gdb.get_game_by_name('Super Mario Word', 6)

    {'id': '83376', 'game_title': 'Super Mario World', 'overview': 'No overview is currently available for this title, please feel free to add one.', 'platform': 'Super Nintendo (SNES)', 'region': 'NTSC-J', 'developers': ['Nintendo'], 'publishers': ['Nintendo'], 'release_date': '1990-11-21', 'players': '2', 'coop': 'No', 'esrb_rating': 'E - Everyone', 'genres': ['Platform'], 'cover': 'https://cdn.thegamesdb.net/images/original/boxart/front/83376-1.jpg', 'cover_thumb': None, 'fanarts': [], 'screenshots': [], 'clearlogos': []}
Retorna um dicionário com informações do jogo 

    >>> lista = ['Super Mario World','Jogo Qualquer','Final Fantasy 3']
    >>> games = gdb.get_game_by_name(lista, 'Super Nintendo (SNES)')
    ou
    >>> games = gdb.get_game_by_name(lista, 6')
    >>> for game in games:
    >>>     print(game)    

    {'id': '83376', 'game_title': 'Super Mario World', 'overview': 'No overview is currently available for this title, please feel free to add one.', 'platform': 'Super Nintendo (SNES)', 'region': 'NTSC-J', 'developers': ['Nintendo'], 'publishers': ['Nintendo'], 'release_date': '1990-11-21', 'players': '2', 'coop': 'No', 'esrb_rating': 'E - Everyone', 'genres': ['Platform'], 'cover': 'https://cdn.thegamesdb.net/images/original/boxart/front/83376-1.jpg', 'cover_thumb': None, 'fanarts': [], 'screenshots': [], 'clearlogos': []}
    {'not_found': 'Jogo Qualquer'}
    {'id': '1762', 'game_title': 'Final Fantasy V', 'overview': "The Elemental Crystals...the life source of the planet. With them, gentle winds blow, the seas are active, fire burns bright, and the earth is full of life. All seems well in the world, until the wind suddenly stops, the sea begin to grow stagnant, the heat of fire becomes scarce, and the earth begins to wither. King Tycoon, sensing a premonition of evil, hurries off to check on the Wind Crystal, only to witness it destroy itself.\r\n\r\nMeanwhile, a young traveler named Butz is camping in a field when a giant meteor strikes the planet. When he heads out to examine the meteor, he is shocked to find a young girl named Lenna, who is the princess of Tycoon, and a old man named Galuf, who is on a critical mission. Later, joined by Faris, a pirate captain, the foursome must travel the land in search of the destructor of the Crystals, and save the planet at any cost!\r\n\r\nFinal Fantasy V featured many new gameplay options and tactics, including an improved Job/Ability system (like in Final Fantasy Tactics), the return of the ATB (Active Time Battle) turn system, and all of the classic FF gameplay you've come to know and love!\r\n\r\nFinal Fantasy V was released as a stand-alone game in Japan, and again in Final Fantasy Collection. Its U.S. debut was as part of Final Fantasy Anthology. It was also later ported to the Gameboy Advance, adding 4 new Jobs, a new 30-floor dungeon, a bestiary, a music player, the ability to quick save anywhere, a few extra pieces of equipment, and a newly update translation.", 'platform': 'Super Nintendo (SNES)', 'region': 'Region Not Set', 'developers': ['Squaresoft'], 'publishers': ['Squaresoft'], 'release_date': '1992-12-06', 'players': '1', 'coop': 'No', 'genres': ['Role-Playing'], 'cover': 'https://cdn.thegamesdb.net/images/original/boxart/front/1762-2.jpg', 'cover_thumb': None, 'fanarts': ['https://cdn.thegamesdb.net/images/original/fanart/1762-1.jpg', 'https://cdn.thegamesdb.net/images/original/fanart/1762-2.jpg', 'https://cdn.thegamesdb.net/images/original/fanart/1762-3.jpg', 'https://cdn.thegamesdb.net/images/original/fanart/1762-4.jpg', 'https://cdn.thegamesdb.net/images/original/fanart/1762-5.jpg'], 'screenshots': [], 'clearlogos': ['https://cdn.thegamesdb.net/images/original/clearlogo/1762.png']}


    
Retorna uma lista com um dicionário para jogo pesquisado.

### Nomes e códigos de consoles:

    >>> for name, id in gbd.codigo_console.items():
    >>> print(f'{name}-{id}

###Buscar todos os jogos de uma plataforma:

    >>> games = gdb.get_games_platform(21)
    >>> print(games)
    
    {'88142': '240p TestSuite Sega Mega-CD', '4933': '3 Ninjas Kick Back', '52882': '3 Ninjas Kick Back / Hook', '41470': 'A-Rank Thunder Tanjouhen', '4937': 'A/X-101', '5011': 'Advanced Dungeons & Dragons: Eye of the Beholder', '34263': 'After Armageddon Gaiden: Majuu Toushouden Eclipse', '737': 'After Burner III', '4935': 'AH-3 Thunderstrike', '34264': 'Aisle Lord', '34265': 'Alshark', '4936': 'Android Assault: The Revenge of Bari-Arm', '25432': 'Anett Futatabi', '41471': 'Aoki Ookami to Shiroki Mejika: Genchou Hishi', '34266': 'Arcus 1-2-3', '34368': 'Arslan Senki', '34320': 'Bakuden Unbalance Zone', '4938': 'Batman Returns', '34270': 'Battle Fantasy', '51997': 'Battle Frenzy', '4940': 'BattleCorps', '51998': 'Battletech: Gray Death Legion', '4941': 'BC Racers', '4942': 'Bill Walsh College Football', '19298': 'BlackHole Assault', '31873': 'Bloodshot', '4943': 'Bouncers', '4944': "Bram Stoker's Dracula", '4945': 'Brutal: Paws of Fury', '34288': 'Bug Blasters: The Exterminators', '34271': 'Burai: Hachigyoku no Yuushi Densetsu', '27249': 'Burning Fists: Force Striker', '4946': 'Cadillacs and Dinosaurs: The Second Cataclysm', '34279': 'Capcom No Quiz: Tonosama No Yabou', '34281': 'Captain Tsubasa', '4947': "Championship Soccer '94", '4948': 'Chuck Rock', '3893': 'Chuck Rock II: Son of Chuck', '51999': 'Citizen X', '4949': 'Cliffhanger', '4950': 'Cobra Command', '79307': 'Cobra Command (PAL)', '31786': "Compton's Interactive Encyclopedia", '4952': 'Corpse Killer', '34382': 'Cosmic Fantasy Stories', '4953': 'Crime Patrol', '34371': 'Cyborg 009', '34282': 'Daihoushinden', '4954': 'Dark Wizard', '34374': 'Death Bringer', '4955': 'Demolition Man', '34284': 'Detonator Orgun', '36016': 'Devastator', '4956': 'Double Switch', '4957': 'Dracula Unleashed', '738': "Dragon's Lair", '4958': 'Dune', '442': 'Dungeon Explorer', '4959': 'Dungeon Master II: Skullkeep', '34357': 'Dynamic Country Club: 3D Golf Simulation', '25461': 'Earnest Evans', '98395': 'Earthworm Jim: Special Edition', '5006': 'Earthworm Jim: Special Edition', '132': 'Ecco the Dolphin', '82556': 'Ecco the Dolphin [Not For Resale]', '79250': 'Ecco The Dolphin CD (JPN)', '440': 'Ecco: The Tides of Time', '34313': 'Egawa Suguru no Super League CD', '5007': 'ESPN Baseball Tonight', '5008': 'ESPN National Hockey Night', '31785': "ESPN NBA HangTime '95", '5009': 'ESPN Sunday Night NFL', '5010': 'Eternal Champions: Challenge from the Dark Side', '34383': 'F1 Circus CD', '5013': 'Fahrenheit', '5014': 'Fatal Fury Special', '5015': 'FIFA International Soccer', '5016': 'Final Fight CD', '443': 'Flashback: The Quest for Identity', '5017': 'Flink', '5012': 'Formula One World Championship: Beyond the Limit', '52000': 'Frog Feast', '34362': 'Funky Horror Band', '34290': 'Gambler Jiko Chuushinha 2 Gekitou! Tokyo Mahjong Land Hen', '34379': 'Game no Kanzume Vol. 1', '34376': 'Game no Kanzume Vol. 2', '34319': 'Genei Toshi - Illusion City', '1916': 'Genghis Khan II: Clan of the Gray Wolf', '102773': 'Ground Zero Texas [Limited Run Games]', '5018': 'Ground Zero: Texas', '99462': 'Ground Zero: Texas - Nuclear Edition - Premium Edition', '5019': 'Heart of the Alien: Out of this World Parts I And II', '34377': 'Heavy Nova', '5020': 'Heimdall', '441': 'Hook', '68175': 'Hot hits / Rock paintings', '5057': 'INXS: Make My Video', '5021': 'Iron Helix', '34380': 'Ishii Hisaichi no Daiseikai', '2577': 'Jaguar XJ220', '51693': 'Jangou World Cup', '5022': 'Jeopardy!', '5023': "Joe Montana's NFL Football", '5024': 'Jurassic Park', '2578': 'Keio Flying Squadron', '101117': 'Keio Flying Squadron', '5046': 'Kids on Site', '5058': 'Kris Kross: Make My Video', '5048': 'Lethal Enforcers', '65440': 'Lethal Enforcers [Gun Bundle]', '5049': 'Lethal Enforcers II: Gun Fighters', '5050': 'Links: The Challenge of Golf', '5051': 'Loadstar: The Legend of Tully Bodine', '34381': 'Lodoss Jima Senki: Eiyuu Sensou', '5052': 'Lords of Thunder', '5053': 'Lunar: Eternal Blue', '5054': 'Lunar: The Silver Star', '79249': 'Lunar: The Silver Star - Runa Za Shirubā Sutā (JPN)', '5055': 'Mad Dog II: The Lost Gold', '5056': 'Mad Dog McCree', '34291': 'Mahou no Shoujo: Silky Lip', '5060': 'Mansion of Hidden Souls', '34292': "Marko's Magic Football", '5059': 'Marky Mark and the Funky Bunch: Make My Video', '15798': "Mary Shelley's Frankenstein", '47832': "Mary Shelley's Frankenstein / Bram Stoker's Dracula Double Deal", '34293': 'Mega Schwarzschild', '5061': 'MegaRace', '5062': 'Mickey Mania: The Timeless Adventures of Mickey Mouse', '5063': 'Microcosm', '79315': 'Microcosm (PAL)', '5064': 'Midnight Raiders', '34294': 'Might and Magic III: Isles of Terra', '51695': 'Mighty Mighty Missile', '439': 'Mighty Morphin Power Rangers', '5065': 'Mortal Kombat', '5066': 'My Paint: The Animated Paint Program', '5067': 'NBA Jam', '5068': 'NFL Football Trivia Challenge', '5069': "NFL's Greatest: San Francisco vs. Dallas 1978-1993", '5070': "NHL '94", '34378': 'Night Striker', '5071': 'Night Trap', '83286': 'Night Trap (red paper box)', '97139': 'Night Trap (SCD) Premium Edition [Limited Run]', '34299': 'Nobunaga no Yabou: Haouden', '34300': 'Nostalgia 1907', '99179': 'Note! - Color Mechanica', '5072': 'Novastorm', '5073': 'Panic!', '5074': "Penn & Teller's Smoke and Mirrors", '5075': 'Pitfall: The Mayan Adventure', '2646': 'Popful Mail', '5076': 'Power Factory Featuring C+C Music Factory', '5077': 'Power Monger', '5078': 'Prince of Persia', '79335': 'Prince of Persia', '5079': 'Prize Fighter', '34312': 'Pro Yakyuu Super League CD', '34268': 'Psychic Detective Series Vol. 3: Aya', '34269': 'Psychic Detective Series Vol. 4: Orgel', '5080': 'Puggsy', '34301': 'Quiz Scramble Special', '444': 'Racing Aces', '5081': 'Radical Rex', '27806': 'Ranma ½: Byakuran Aika', '5082': 'RDF Global Conflict', '5083': 'Revenge of the Ninja', '5084': 'Revengers of Vengeance', '5085': 'Rise of the Dragon', '5086': 'Road Avenger', '79317': 'Road Avenger (PAL)', '5087': 'Road Rash', '445': 'Robo Aleste', '5088': 'Samurai Shodown', '34303': 'San Goku Shi III', '29399': 'Sega Classics Arcade Collection 4-in-1', '14048': 'Sega Classics Arcade Collection 5-in-1', '75064': 'SEGA Games Can Vol. 2', '34262': 'Seima Densetsu 3X3 Eyes', '34289': 'Seirei Shinseiki Fhey Area', '34305': 'Sengoku Denshou', '70840': 'Sensible Soccer (PAL)', '739': 'Sewer Shark', '965': 'Shadow of the Beast II', '23755': 'Shadowrun', '5090': 'Sherlock Holmes: Consulting Detective', '56156': 'Sherlock Holmes: Consulting Detective / Sega Classics: Arcade Collection', '5091': 'Sherlock Holmes: Consulting Detective Vol. II', '34310': 'Shin Megami Tensei', '5092': 'Shining Force CD', '97192': 'Shining Force CD (JP)', '5093': 'Silpheed', '34308': 'Sim Earth: The Living Planet', '5094': 'Slam City with Scottie Pippen', '5095': 'Snatcher', '79323': 'Sol-Feace', '5096': 'Sol-Feace', '70697': 'Sol-Feace / Cobra Command', '129': 'Sonic CD', '69520': 'Sonic CD', '79310': 'Sonic CD', '99874': 'Sonic CD [Not for Resale]', '29757': 'Sonic the Hedgehog Megamix', '5097': 'SoulStar', '79312': 'Soulstar (PAL)', '5098': 'Space Ace', '34323': 'Star Strike', '5102': 'Star Wars Chess', '740': 'Star Wars: Rebel Assault', '75735': 'Star Wars: Rebel Assault (SCD) Premium Edition', '75778': 'Star Wars: Rebel Assault Classic Edition', '5101': 'StarBlade', '5103': 'Stellar-Fire', '55741': 'Super Strike Trilogy', '5104': 'Supreme Warrior', '741': 'Surgical Strike', '108118': 'Switch', '34314': 'Syndicate', '34315': 'Tenbu Mega CD Special', '34316': 'Tenka Fubu Eiyuutachi no Houkou', '4934': 'The Adventures of Batman & Robin', '5117': 'The Adventures of Willy Beamish', '5100': 'The Amazing Spider-Man vs. The Kingpin', '4951': 'The Colors of Modern Rock', '5047': 'The Lawnmower Man', '5106': 'The Masked Rider: Kamen Rider ZO', '34318': 'The Ninja Warriors', '5105': 'The San Diego Zoo Presents: The Animals!', '5089': 'The Secret of Monkey Island', '75734': 'The Secret Of Monkey Island (SCD) Premium Edition [Limited Run]', '75777': 'The Secret Of Monkey Island Classic Edition', '5107': 'The Smurfs', '5099': 'The Space Adventure', '5108': 'The Terminator', '34317': 'Theme Park', '5109': 'Third World War', '35708': 'Thunderhawk', '48504': 'Time Cop', '5110': 'Time Gal', '79248': 'Time Gal (JPN)', '26758': 'TimeCop (Prototype)', '5111': 'Tomcat Alley', '5112': 'Trivial Pursuit', '5113': 'Ultraverse Prime', '66642': 'Ultraverse Prime / Microcosm', '27807': 'Urusei Yatsura: Dear My Friends', '2579': 'Vay', '27808': 'Warau Salesman', '5114': 'Wheel of Fortune', '5115': 'Who Shot Johnny Rock?', '5116': 'Wild Woody', '5118': 'Wing Commander', '34321': 'Winning Post', '5119': 'Wirehead', '5120': 'Wolfchild', '5121': 'Wonder Dog', '34372': 'Wondermega Collection', '5122': 'World Cup USA 94', '5123': 'WWF Rage in the Cage', '34322': 'Yumimi Mix'}
    
