# Likelihood ratio test

Using the Godambe Information Matrix, dadi can also perform hypothesis testing through an adjusted likelihood ratio test. The likelihood ratio test allows for comparison between two nested models, such that the simple model is a special case of the more complex model. The full likelihood ratio test statistic is equal to \\(D = 2(ll_c - ll_s)\\), where \\(ll_c\\) and \\(ll_s\\) are the likelihoods of the complex and simple model, respectively. Model selection is then performed by comparing this test statistic to a \\(\chi^2\\) distribution with degrees of freedom equal to the difference in number of parameters between the simple and complex model. To perform likelihood ratio test using composite likelihoods, a multiplicative adjustment to the likelihood ratio test statistic shown above is needed. dadi can calculate this adjustment, using the fucntion.

	adj = dadi.Godambe.LRT_adjust(func_ex, grid_pts, all_boot, p0, data, nested_indices, multinom = True, eps)

The parameters have the same meaning as for `Godambe.GIM_uncert`, where `func_ex` is the complex model function and `p0` is the best-fit parameters. Results in [6](./references.md) suggested that setting `p0` equal to the best-fit parameters from either the simple model or complex model yield similar adjustments, although the data in that paper were simulated under the simple model. When data was simulated under the complex model, it was found that evaluating the adjustment at the complex model parameterization was more powerful, yielding a more liberal adjustment than evaluating at the simple model parameterization. We suggest evaluating at the complex model parameterization, although evaluating at the simple model parameterization as well may offer additional insight and be preferable if you desire a more conservative estimate of the adjustment. The additional parameter `nested_indices` is a list that indicates which positions in the complex model arguments are fixed to create the simple model. For example, if the complex model parameters are \\([T, \nu_1, \nu_2, m]\\), and the simple model is no migration (so \\(m = 0\\)), then `nested_indices = [3]`. (Indices are numbered starting from zero.) The resulting adjusted \\(D\\) statistics is then \\(D_{adj} = adj \times 2(ll_c-ll_s)\\)).

In the simplest case of a single parameter on the interior of the complex parameter space, the null distribution for \\(D_{adj}\\) is \\(\chi^2\\) with 1 degree-of-freedom. If the a single parameter is on the boundary of the parameter space, the null distribution is \\(\frac{1}{2}\chi_0^2 + \frac{1}{2}\chi_1^2\\). See [6](./references.md) for an example of this. For convenience, dadi includes a function that computes the p-value given \\(D\\).

	p = sum_chi2_ppf(D, weights)

Here \\(D\\) is \\(D_{adj}\\) and `weights` records the weights in the sum-of-\\(\chi^2\\) distribution, beginning with zero degrees of freedom. For example, the case of a single parameter on the boundary would be `weights = (0.5, 0.5)`. For more complex scenarios, see [7](./references.md).
