import unittest

from rimo_utils import good_open

import 環境
from Librian虛擬機 import 虛擬機環境

虛擬機環境.加載配置('./project/_默認工程')


class 全部測試(unittest.TestCase):
    maxDiff = None
    # def test_角色(self):
    #     from Librian虛擬機 import 角色
    #     self.assertEqual(
    #         str(角色.角色表),
    #         "{'潘大爺': 角色(潘大爺->[衣:{'_默認': ['_']}],[顏:{'_默認': []}])}"
    #     )
    #     self.assertEqual(
    #         str(角色.角色表['潘大爺'].圖層座標),
    #         "{'_': {'x': 0, 'y': 0}}"
    #     )

    def test_編譯(self):
        from Librian虛擬機 import 編譯
        with good_open(f'{虛擬機環境.工程路徑}/{虛擬機環境.配置["劇本入口"]}') as f:
            self.assertEqual(
                編譯.編譯(f),
                [
                    {'縮進數': 0, '註釋': ' 背景來自pixiv_id=75399001的「無料背景素材[和風縁側]」。', '類型': '註釋'},
                    {'縮進數': 0, '註釋': ' 潘大爺的立繪來自某黃昏風立繪生成器。', '類型': '註釋'}, {'縮進數': 0, '註釋': ' 音樂來自https://filmmusic.io，作者Kevin MacLeod，使用CC4條款。', '類型': '註釋', '之後的空白': 1},
                    {'縮進數': 0, '原文': 'BGM call-to-adventure', '函數': 'BGM', '參數表': [{'a': 'call-to-adventure'}], '類型': '函數調用'},
                    {'縮進數': 0, '原文': 'BG 和風縁側', '函數': 'BG', '參數表': [{'a': '和風縁側'}], '類型': '函數調用'},
                    {'縮進數': 0, '名': '潘大爺', '代': None, '特效': None, '顏': None, '語': '今天天氣不錯，\n去散步吧。', '類型': '人物對話'},
                    {'縮進數': 0, '類型': '旁白', '旁白': '潘大爺走了。'}, {'縮進數': 0, '鏡頭符號': '-', '內容': '潘大爺', '類型': '鏡頭'}, {'縮進數': 0, '類型': '旁白', '旁白': '然後就誰也沒有了。'}
                ]
            )

    def test_劇本(self):
        from Librian虛擬機 import 劇本
        讀者 = 劇本.讀者(f'{虛擬機環境.工程路徑}/{虛擬機環境.配置["劇本入口"]}')
        self.assertEqual(
            list(讀者.迭代器()),
            [
                {'額外信息': '', '話語': '今天天氣不錯，\n去散步吧。', '名字': '潘大爺', '立繪': [{'圖層': [{'文件': '../project/_默認工程/_臨時文件/潘大爺/_.png', '子位置': (0, 0)}], '位置': [300, 0, 1], '動作': ('淡入',), '特效': None, '名字': '潘大爺'}], '視頻': '', '背景': ('和風縁側.jpg', 1, '_淡出'), '背景音樂': ('call-to-adventure.mp3', 1), 'cg': '', 'js': '', '選項': [], '語者': '潘大爺', '特效表': {}},
                {'額外信息': '', '話語': '潘大爺走了。', '名字': '', '立繪': [{'圖層': [{'文件': '../project/_默認工程/_臨時文件/潘大爺/_.png', '子位置': (0, 0)}], '位置': [300, 0, 1], '動作': None, '特效': None, '名字': '潘大爺'}], '視頻': '', '背景': ('和風縁側.jpg', 1, '_淡出'), '背景音樂': ('call-to-adventure.mp3', 1), 'cg': '', 'js': '', '選項': [], '語者': '', '特效表': {}},
                {'額外信息': '', '話語': '然後就誰也沒有了。', '名字': '', '立繪': [], '視頻': '', '背景': ('和風縁側.jpg', 1, '_淡出'), '背景音樂': ('call-to-adventure.mp3', 1), 'cg': '', 'js': '', '選項': [], '語者': '', '特效表': {}}
            ]
        )

unittest.main()