"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Os = exports.Architecture = exports.RunnerVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines desired GitHub Actions runner version.
 */
class RunnerVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * Use the latest version available at the time the runner provider image is built.
     */
    static latest() {
        return new RunnerVersion('latest');
    }
    /**
     * Use a specific version.
     *
     * @see https://github.com/actions/runner/releases
     *
     * @param version GitHub Runner version
     */
    static specific(version) {
        return new RunnerVersion(version);
    }
}
exports.RunnerVersion = RunnerVersion;
_a = JSII_RTTI_SYMBOL_1;
RunnerVersion[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.RunnerVersion", version: "0.5.4" };
/**
 * CPU architecture enum for an image.
 */
class Architecture {
    constructor(name) {
        this.name = name;
    }
    static of(architecture) {
        return new Architecture(architecture);
    }
    /**
    * Checks if the given architecture is the same as this one.
    *
    * @param arch architecture to compare
    */
    is(arch) {
        return arch.name == this.name;
    }
}
exports.Architecture = Architecture;
_b = JSII_RTTI_SYMBOL_1;
Architecture[_b] = { fqn: "@cloudsnorkel/cdk-github-runners.Architecture", version: "0.5.4" };
/**
 * ARM64
 */
Architecture.ARM64 = Architecture.of('ARM64');
/**
 * X86_64
 */
Architecture.X86_64 = Architecture.of('X86_64');
/**
 * OS enum for an image.
 */
class Os {
    constructor(name) {
        this.name = name;
    }
    static of(os) {
        return new Os(os);
    }
    /**
    * Checks if the given OS is the same as this one.
    *
    * @param os OS to compare
    */
    is(os) {
        return os.name == this.name;
    }
}
exports.Os = Os;
_c = JSII_RTTI_SYMBOL_1;
Os[_c] = { fqn: "@cloudsnorkel/cdk-github-runners.Os", version: "0.5.4" };
/**
* Linux
*/
Os.LINUX = Os.of('Linux');
/**
* Windows
*/
Os.WINDOWS = Os.of('Windows');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tbW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3Byb3ZpZGVycy9jb21tb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFFQTs7R0FFRztBQUNILE1BQWEsYUFBYTtJQW1CeEIsWUFBK0IsT0FBZTtRQUFmLFlBQU8sR0FBUCxPQUFPLENBQVE7SUFDOUMsQ0FBQztJQW5CRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxNQUFNO1FBQ2xCLE9BQU8sSUFBSSxhQUFhLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxRQUFRLENBQUMsT0FBZTtRQUNwQyxPQUFPLElBQUksYUFBYSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQ3BDLENBQUM7O0FBakJILHNDQXFCQzs7O0FBRUQ7O0dBRUc7QUFDSCxNQUFhLFlBQVk7SUFldkIsWUFBb0MsSUFBWTtRQUFaLFNBQUksR0FBSixJQUFJLENBQVE7SUFDaEQsQ0FBQztJQUxPLE1BQU0sQ0FBQyxFQUFFLENBQUMsWUFBb0I7UUFDcEMsT0FBTyxJQUFJLFlBQVksQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBS0Q7Ozs7TUFJRTtJQUNLLEVBQUUsQ0FBQyxJQUFrQjtRQUMxQixPQUFPLElBQUksQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQztJQUNoQyxDQUFDOztBQXpCSCxvQ0EwQkM7OztBQXpCQzs7R0FFRztBQUNvQixrQkFBSyxHQUFHLFlBQVksQ0FBQyxFQUFFLENBQUMsT0FBTyxDQUFDLENBQUM7QUFFeEQ7O0dBRUc7QUFDb0IsbUJBQU0sR0FBRyxZQUFZLENBQUMsRUFBRSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0FBbUI1RDs7R0FFRztBQUNILE1BQWEsRUFBRTtJQWViLFlBQW9DLElBQVk7UUFBWixTQUFJLEdBQUosSUFBSSxDQUFRO0lBQ2hELENBQUM7SUFMTyxNQUFNLENBQUMsRUFBRSxDQUFDLEVBQVU7UUFDMUIsT0FBTyxJQUFJLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQztJQUNwQixDQUFDO0lBS0Q7Ozs7TUFJRTtJQUNLLEVBQUUsQ0FBQyxFQUFNO1FBQ2QsT0FBTyxFQUFFLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUM7SUFDOUIsQ0FBQzs7QUF6QkgsZ0JBMEJDOzs7QUF6QkM7O0VBRUU7QUFDcUIsUUFBSyxHQUFHLEVBQUUsQ0FBQyxFQUFFLENBQUMsT0FBTyxDQUFDLENBQUM7QUFFOUM7O0VBRUU7QUFDcUIsVUFBTyxHQUFHLEVBQUUsQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBhd3NfZWMyIGFzIGVjMiwgYXdzX2VjciBhcyBlY3IsIGF3c19pYW0gYXMgaWFtLCBhd3NfbG9ncyBhcyBsb2dzLCBhd3Nfc3RlcGZ1bmN0aW9ucyBhcyBzdGVwZnVuY3Rpb25zIH0gZnJvbSAnYXdzLWNkay1saWInO1xuXG4vKipcbiAqIERlZmluZXMgZGVzaXJlZCBHaXRIdWIgQWN0aW9ucyBydW5uZXIgdmVyc2lvbi5cbiAqL1xuZXhwb3J0IGNsYXNzIFJ1bm5lclZlcnNpb24ge1xuICAvKipcbiAgICogVXNlIHRoZSBsYXRlc3QgdmVyc2lvbiBhdmFpbGFibGUgYXQgdGhlIHRpbWUgdGhlIHJ1bm5lciBwcm92aWRlciBpbWFnZSBpcyBidWlsdC5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgbGF0ZXN0KCk6IFJ1bm5lclZlcnNpb24ge1xuICAgIHJldHVybiBuZXcgUnVubmVyVmVyc2lvbignbGF0ZXN0Jyk7XG4gIH1cblxuICAvKipcbiAgICogVXNlIGEgc3BlY2lmaWMgdmVyc2lvbi5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2dpdGh1Yi5jb20vYWN0aW9ucy9ydW5uZXIvcmVsZWFzZXNcbiAgICpcbiAgICogQHBhcmFtIHZlcnNpb24gR2l0SHViIFJ1bm5lciB2ZXJzaW9uXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHNwZWNpZmljKHZlcnNpb246IHN0cmluZykge1xuICAgIHJldHVybiBuZXcgUnVubmVyVmVyc2lvbih2ZXJzaW9uKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBjb25zdHJ1Y3RvcihyZWFkb25seSB2ZXJzaW9uOiBzdHJpbmcpIHtcbiAgfVxufVxuXG4vKipcbiAqIENQVSBhcmNoaXRlY3R1cmUgZW51bSBmb3IgYW4gaW1hZ2UuXG4gKi9cbmV4cG9ydCBjbGFzcyBBcmNoaXRlY3R1cmUge1xuICAvKipcbiAgICogQVJNNjRcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQVJNNjQgPSBBcmNoaXRlY3R1cmUub2YoJ0FSTTY0Jyk7XG5cbiAgLyoqXG4gICAqIFg4Nl82NFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBYODZfNjQgPSBBcmNoaXRlY3R1cmUub2YoJ1g4Nl82NCcpO1xuXG4gIHByaXZhdGUgc3RhdGljIG9mKGFyY2hpdGVjdHVyZTogc3RyaW5nKSB7XG4gICAgcmV0dXJuIG5ldyBBcmNoaXRlY3R1cmUoYXJjaGl0ZWN0dXJlKTtcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3IocHVibGljIHJlYWRvbmx5IG5hbWU6IHN0cmluZykge1xuICB9XG5cbiAgLyoqXG4gICogQ2hlY2tzIGlmIHRoZSBnaXZlbiBhcmNoaXRlY3R1cmUgaXMgdGhlIHNhbWUgYXMgdGhpcyBvbmUuXG4gICpcbiAgKiBAcGFyYW0gYXJjaCBhcmNoaXRlY3R1cmUgdG8gY29tcGFyZVxuICAqL1xuICBwdWJsaWMgaXMoYXJjaDogQXJjaGl0ZWN0dXJlKSB7XG4gICAgcmV0dXJuIGFyY2gubmFtZSA9PSB0aGlzLm5hbWU7XG4gIH1cbn1cblxuLyoqXG4gKiBPUyBlbnVtIGZvciBhbiBpbWFnZS5cbiAqL1xuZXhwb3J0IGNsYXNzIE9zIHtcbiAgLyoqXG4gICogTGludXhcbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBMSU5VWCA9IE9zLm9mKCdMaW51eCcpO1xuXG4gIC8qKlxuICAqIFdpbmRvd3NcbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBXSU5ET1dTID0gT3Mub2YoJ1dpbmRvd3MnKTtcblxuICBwcml2YXRlIHN0YXRpYyBvZihvczogc3RyaW5nKSB7XG4gICAgcmV0dXJuIG5ldyBPcyhvcyk7XG4gIH1cblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKHB1YmxpYyByZWFkb25seSBuYW1lOiBzdHJpbmcpIHtcbiAgfVxuXG4gIC8qKlxuICAqIENoZWNrcyBpZiB0aGUgZ2l2ZW4gT1MgaXMgdGhlIHNhbWUgYXMgdGhpcyBvbmUuXG4gICpcbiAgKiBAcGFyYW0gb3MgT1MgdG8gY29tcGFyZVxuICAqL1xuICBwdWJsaWMgaXMob3M6IE9zKSB7XG4gICAgcmV0dXJuIG9zLm5hbWUgPT0gdGhpcy5uYW1lO1xuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUnVubmVySW1hZ2Uge1xuICAvKipcbiAgICogRUNSIHJlcG9zaXRvcnkgY29udGFpbmluZyB0aGUgaW1hZ2UuXG4gICAqL1xuICByZWFkb25seSBpbWFnZVJlcG9zaXRvcnk6IGVjci5JUmVwb3NpdG9yeTtcblxuICAvKipcbiAgICogU3RhdGljIGltYWdlIHRhZyB3aGVyZSB0aGUgaW1hZ2Ugd2lsbCBiZSBwdXNoZWQuXG4gICAqL1xuICByZWFkb25seSBpbWFnZVRhZzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBcmNoaXRlY3R1cmUgb2YgdGhlIGltYWdlLlxuICAgKi9cbiAgcmVhZG9ubHkgYXJjaGl0ZWN0dXJlOiBBcmNoaXRlY3R1cmU7XG5cbiAgLyoqXG4gICAqIE9TIHR5cGUgb2YgdGhlIGltYWdlLlxuICAgKi9cbiAgcmVhZG9ubHkgb3M6IE9zO1xuXG4gIC8qKlxuICAgKiBMb2cgZ3JvdXAgd2hlcmUgaW1hZ2UgYnVpbGRzIGFyZSBsb2dnZWQuXG4gICAqL1xuICByZWFkb25seSBsb2dHcm91cD86IGxvZ3MuTG9nR3JvdXA7XG59XG5cbi8qKlxuICogSW50ZXJmYWNlIGZvciBjb25zdHJ1Y3RzIHRoYXQgYnVpbGQgYW4gaW1hZ2UgdGhhdCBjYW4gYmUgdXNlZCBpbiB7QGxpbmsgSVJ1bm5lclByb3ZpZGVyfS5cbiAqXG4gKiBBbnl0aGluZyB0aGF0IGVuZHMgdXAgd2l0aCBhbiBFQ1IgcmVwb3NpdG9yeSBjb250YWluaW5nIGEgRG9ja2VyIGltYWdlIHRoYXQgcnVucyBHaXRIdWIgc2VsZi1ob3N0ZWQgcnVubmVycyBjYW4gYmUgdXNlZC4gQSBzaW1wbGUgaW1wbGVtZW50YXRpb24gY291bGQgZXZlbiBwb2ludCB0byBhbiBleGlzdGluZyBpbWFnZSBhbmQgbm90aGluZyBlbHNlLlxuICpcbiAqIEl0J3MgaW1wb3J0YW50IHRoYXQgdGhlIHNwZWNpZmllZCBpbWFnZSB0YWcgYmUgYXZhaWxhYmxlIGF0IHRoZSB0aW1lIHRoZSByZXBvc2l0b3J5IGlzIGF2YWlsYWJsZS4gUHJvdmlkZXJzIHVzdWFsbHkgYXNzdW1lIHRoZSBpbWFnZSBpcyByZWFkeSBhbmQgd2lsbCBmYWlsIGlmIGl0J3Mgbm90LlxuICpcbiAqIFRoZSBpbWFnZSBjYW4gYmUgZnVydGhlciB1cGRhdGVkIG92ZXIgdGltZSBtYW51YWxseSBvciB1c2luZyBhIHNjaGVkdWxlIGFzIGxvbmcgYXMgaXQgaXMgYWx3YXlzIHdyaXR0ZW4gdG8gdGhlIHNhbWUgdGFnLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElJbWFnZUJ1aWxkZXIge1xuICAvKipcbiAgICogRUNSIHJlcG9zaXRvcnkgY29udGFpbmluZyB0aGUgaW1hZ2UuXG4gICAqXG4gICAqIFRoaXMgbWV0aG9kIGNhbiBiZSBjYWxsZWQgbXVsdGlwbGUgdGltZXMgaWYgdGhlIGltYWdlIGlzIGJvdW5kIHRvIG11bHRpcGxlIHByb3ZpZGVycy4gTWFrZSBzdXJlIHlvdSBjYWNoZSB0aGUgaW1hZ2Ugd2hlbiBpbXBsZW1lbnRpbmcgb3IgcmV0dXJuIGFuIGVycm9yIGlmIHRoaXMgYnVpbGRlciBkb2Vzbid0IHN1cHBvcnQgcmV1c2luZyBpbWFnZXMuXG4gICAqXG4gICAqIEByZXR1cm4gaW1hZ2VcbiAgICovXG4gIGJpbmQoKTogUnVubmVySW1hZ2U7XG59XG5cbi8qKlxuICogQ29tbW9uIHByb3BlcnRpZXMgZm9yIGFsbCBydW5uZXIgcHJvdmlkZXJzLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFJ1bm5lclByb3ZpZGVyUHJvcHMge1xuICAvKipcbiAgICogVGhlIG51bWJlciBvZiBkYXlzIGxvZyBldmVudHMgYXJlIGtlcHQgaW4gQ2xvdWRXYXRjaCBMb2dzLiBXaGVuIHVwZGF0aW5nXG4gICAqIHRoaXMgcHJvcGVydHksIHVuc2V0dGluZyBpdCBkb2Vzbid0IHJlbW92ZSB0aGUgbG9nIHJldGVudGlvbiBwb2xpY3kuIFRvXG4gICAqIHJlbW92ZSB0aGUgcmV0ZW50aW9uIHBvbGljeSwgc2V0IHRoZSB2YWx1ZSB0byBgSU5GSU5JVEVgLlxuICAgKlxuICAgKiBAZGVmYXVsdCBsb2dzLlJldGVudGlvbkRheXMuT05FX01PTlRIXG4gICAqL1xuICByZWFkb25seSBsb2dSZXRlbnRpb24/OiBsb2dzLlJldGVudGlvbkRheXM7XG59XG5cbi8qKlxuICogV29ya2Zsb3cgam9iIHBhcmFtZXRlcnMgYXMgcGFyc2VkIGZyb20gdGhlIHdlYmhvb2sgZXZlbnQuIFBhc3MgdGhlc2UgaW50byB5b3VyIHJ1bm5lciBleGVjdXRvciBhbmQgcnVuIHNvbWV0aGluZyBsaWtlOlxuICpcbiAqIGBgYHNoXG4gKiAuL2NvbmZpZy5zaCAtLXVuYXR0ZW5kZWQgLS11cmwgXCJodHRwczovLyR7R0lUSFVCX0RPTUFJTn0vJHtPV05FUn0vJHtSRVBPfVwiIC0tdG9rZW4gXCIke1JVTk5FUl9UT0tFTn1cIiAtLWVwaGVtZXJhbCAtLXdvcmsgX3dvcmsgLS1sYWJlbHMgXCIke1JVTk5FUl9MQUJFTH1cIiAtLW5hbWUgXCIke1JVTk5FUl9OQU1FfVwiIC0tZGlzYWJsZXVwZGF0ZVxuICogYGBgXG4gKlxuICogQWxsIHBhcmFtZXRlcnMgYXJlIHNwZWNpZmllZCBhcyBzdGVwIGZ1bmN0aW9uIHBhdGhzIGFuZCB0aGVyZWZvcmUgbXVzdCBiZSB1c2VkIG9ubHkgaW4gc3RlcCBmdW5jdGlvbiB0YXNrIHBhcmFtZXRlcnMuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUnVubmVyUnVudGltZVBhcmFtZXRlcnMge1xuICAvKipcbiAgICogUGF0aCB0byBydW5uZXIgdG9rZW4gdXNlZCB0byByZWdpc3RlciB0b2tlbi5cbiAgICovXG4gIHJlYWRvbmx5IHJ1bm5lclRva2VuUGF0aDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBQYXRoIHRvIGRlc2lyZWQgcnVubmVyIG5hbWUuIFdlIHNwZWNpZmljYWxseSBzZXQgdGhlIG5hbWUgdG8gbWFrZSB0cm91Ymxlc2hvb3RpbmcgZWFzaWVyLlxuICAgKi9cbiAgcmVhZG9ubHkgcnVubmVyTmFtZVBhdGg6IHN0cmluZztcblxuICAvKipcbiAgICogUGF0aCB0byBHaXRIdWIgZG9tYWluLiBNb3N0IG9mIHRoZSB0aW1lIHRoaXMgd2lsbCBiZSBnaXRodWIuY29tIGJ1dCBmb3Igc2VsZi1ob3N0ZWQgR2l0SHViIGluc3RhbmNlcywgdGhpcyB3aWxsIGJlIGRpZmZlcmVudC5cbiAgICovXG4gIHJlYWRvbmx5IGdpdGh1YkRvbWFpblBhdGg6IHN0cmluZztcblxuICAvKipcbiAgICogUGF0aCB0byByZXBvc3Rpcm95IG93bmVyIG5hbWUuXG4gICAqL1xuICByZWFkb25seSBvd25lclBhdGg6IHN0cmluZztcblxuICAvKipcbiAgICogUGF0aCB0byByZXBvc2l0b3J5IG5hbWUuXG4gICAqL1xuICByZWFkb25seSByZXBvUGF0aDogc3RyaW5nO1xufVxuXG4vKipcbiAqIEludGVyZmFjZSBmb3IgcnVubmVyIGltYWdlIHN0YXR1cyB1c2VkIGJ5IHN0YXR1cy5qc29uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElSdW5uZXJJbWFnZVN0YXR1cyB7XG4gIC8qKlxuICAgKiBJbWFnZSByZXBvc2l0b3J5IHdoZXJlIHJ1bm5lciBpbWFnZSBpcyBwdXNoZWQuXG4gICAqL1xuICByZWFkb25seSBpbWFnZVJlcG9zaXRvcnk/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRhZyBvZiBpbWFnZSB0aGF0IHNob3VsZCBiZSB1c2VkLlxuICAgKi9cbiAgcmVhZG9ubHkgaW1hZ2VUYWc/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIExvZyBncm91cCBuYW1lIGZvciB0aGUgaW1hZ2UgYnVpbGRlciB3aGVyZSBoaXN0b3J5IG9mIGltYWdlIGJ1aWxkcyBjYW4gYmUgYW5hbHl6ZWQuXG4gICAqL1xuICByZWFkb25seSBpbWFnZUJ1aWxkZXJMb2dHcm91cD86IHN0cmluZztcbn1cblxuLyoqXG4gKiBJbnRlcmZhY2UgZm9yIGFsbCBydW5uZXIgcHJvdmlkZXJzLiBJbXBsZW1lbnRhdGlvbnMgY3JlYXRlIGFsbCByZXF1aXJlZCByZXNvdXJjZXMgYW5kIHJldHVybiBhIHN0ZXAgZnVuY3Rpb24gdGFzayB0aGF0IHN0YXJ0cyB0aG9zZSByZXNvdXJjZXMgZnJvbSB7QGxpbmsgZ2V0U3RlcEZ1bmN0aW9uVGFza30uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSVJ1bm5lclByb3ZpZGVyIGV4dGVuZHMgZWMyLklDb25uZWN0YWJsZSwgaWFtLklHcmFudGFibGUge1xuICAvKipcbiAgICogR2l0SHViIEFjdGlvbnMgbGFiZWwgYXNzb2NpYXRlZCB3aXRoIHRoaXMgcnVubmVyIHByb3ZpZGVyLlxuICAgKi9cbiAgcmVhZG9ubHkgbGFiZWw6IHN0cmluZztcblxuICAvKipcbiAgICogVlBDIG5ldHdvcmsgaW4gd2hpY2ggcnVubmVycyB3aWxsIGJlIHBsYWNlZC5cbiAgICovXG4gIHJlYWRvbmx5IHZwYz86IGVjMi5JVnBjO1xuXG4gIC8qKlxuICAgKiBTZWN1cml0eSBncm91cCBhc3NvY2lhdGVkIHdpdGggcnVubmVycy5cbiAgICovXG4gIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXA/OiBlYzIuSVNlY3VyaXR5R3JvdXA7XG5cbiAgLyoqXG4gICAqIEltYWdlIHVzZWQgdG8gY3JlYXRlIGEgbmV3IHJlc291cmNlIGNvbXB1dGUuIENhbiBiZSBEb2NrZXIgaW1hZ2UsIEFNSSwgb3Igc29tZXRoaW5nIGVsc2UuXG4gICAqL1xuICByZWFkb25seSBpbWFnZTogUnVubmVySW1hZ2U7XG5cbiAgLyoqXG4gICAqIEdlbmVyYXRlIHN0ZXAgZnVuY3Rpb24gdGFza3MgdGhhdCBleGVjdXRlIHRoZSBydW5uZXIuXG4gICAqXG4gICAqIENhbGxlZCBieSBHaXRodWJSdW5uZXJzIGFuZCBzaG91bGRuJ3QgYmUgY2FsbGVkIG1hbnVhbGx5LlxuICAgKlxuICAgKiBAcGFyYW0gcGFyYW1ldGVycyBzcGVjaWZpYyBidWlsZCBwYXJhbWV0ZXJzXG4gICAqL1xuICBnZXRTdGVwRnVuY3Rpb25UYXNrKHBhcmFtZXRlcnM6IFJ1bm5lclJ1bnRpbWVQYXJhbWV0ZXJzKTogc3RlcGZ1bmN0aW9ucy5JQ2hhaW5hYmxlO1xufVxuIl19