"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchPutMetricAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const role_1 = require("./private/role");
/**
 * The action to capture an Amazon CloudWatch metric.
 */
class CloudWatchPutMetricAction {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_CloudWatchPutMetricActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchPutMetricAction);
            }
            throw error;
        }
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.props.role ?? role_1.singletonActionRole(rule);
        cloudwatch.Metric.grantPutMetricData(role);
        return {
            configuration: {
                cloudwatchMetric: {
                    metricName: this.props.metricName,
                    metricNamespace: this.props.metricNamespace,
                    metricTimestamp: this.props.metricTimestamp,
                    metricUnit: this.props.metricUnit,
                    metricValue: this.props.metricValue,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.CloudWatchPutMetricAction = CloudWatchPutMetricAction;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchPutMetricAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.CloudWatchPutMetricAction", version: "2.50.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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