# -*- coding: utf-8 -*-
# Generated by Django 1.10.6 on 2017-08-01 19:40
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('django_teams', '0003_auto_20160906_2058'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Answer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('textAnswer', models.TextField(blank=True, null=True)),
                ('numericAnswer', models.IntegerField(blank=True, null=True)),
                ('multipleChoiceAnswer', models.IntegerField(blank=True, choices=[(1, b'A'), (2, b'B'), (3, b'C'), (4, b'D')], null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Attempt',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('content', models.TextField(blank=True, null=True)),
                ('expectedTextAnswer', models.TextField(blank=True, null=True)),
                ('expectedNumericAnswer', models.IntegerField(blank=True, null=True)),
                ('expectedMultipleChoiceAnswer', models.IntegerField(blank=True, choices=[(1, b'A'), (2, b'B'), (3, b'C'), (4, b'D')], null=True)),
                ('type', models.IntegerField(choices=[(1, b'Fill In The Blank'), (2, b'Multiple Choice'), (3, b'Numeric'), (4, b'Open Ended'), (5, b'Rank'), (6, b'Info')])),
            ],
        ),
        migrations.CreateModel(
            name='Questionnaire',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default=b'my questionnaire', max_length=255)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('public', models.BooleanField(default=False)),
                ('owner', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='QuestionOrder',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rank', models.IntegerField()),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_pre_post.Question')),
                ('questionnaire', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_pre_post.Questionnaire')),
            ],
            options={
                'ordering': ('rank',),
            },
        ),
        migrations.AddField(
            model_name='questionnaire',
            name='questions',
            field=models.ManyToManyField(through='django_pre_post.QuestionOrder', to='django_pre_post.Question'),
        ),
        migrations.AddField(
            model_name='questionnaire',
            name='team',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='django_teams.Team'),
        ),
        migrations.AddField(
            model_name='attempt',
            name='questionnaire',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_pre_post.Questionnaire'),
        ),
        migrations.AddField(
            model_name='answer',
            name='attempt',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='django_pre_post.Attempt'),
        ),
        migrations.AddField(
            model_name='answer',
            name='owner',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='answer',
            name='question',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_pre_post.Question'),
        ),
    ]
