/*
 * Decompiled with CFR 0.152.
 */
package com.clicknium.utils;

import com.clicknium.ClickniumJavaBridge;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtil {
    private static final Class[] NOAARGES_Classes = new Class[0];

    public static Object InvokeMethod(Object targetObject, String methodName) {
        return ReflectionUtil.InvokeMethod(targetObject, methodName, null);
    }

    public static Object InvokeMethod(Object targetObject, String methodName, Object[] paramArray) {
        if (targetObject == null) {
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("reflection to invoke method " + methodName + " failed, targetObject is null");
            return null;
        }
        Class[] paramTypes = ReflectionUtil.getMethodParamTypes(paramArray);
        Method targetMethod = ReflectionUtil.getMethod(targetObject, methodName, paramTypes);
        return ReflectionUtil.invokeMethod(targetObject, targetMethod, paramArray);
    }

    public static Object InvokeDeclaredMethod(Object targetObject, String methodName) {
        return ReflectionUtil.InvokeDeclaredMethod(targetObject, methodName, null);
    }

    public static Object InvokeDeclaredMethod(Object targetObject, String methodName, Object[] paramArray) {
        if (targetObject == null) {
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("reflection to invoke declared method " + methodName + " failed, targetObject is null");
            return null;
        }
        Class[] paramTypes = ReflectionUtil.getMethodParamTypes(paramArray);
        Method targetMethod = ReflectionUtil.getDeclaredMethod(targetObject, methodName, paramTypes);
        return ReflectionUtil.invokeMethod(targetObject, targetMethod, paramArray);
    }

    public static Object InvokeDeclaredConstructor(Class targetClass, Object[] paramArray) {
        Class[] paramTypes = ReflectionUtil.getMethodParamTypes(paramArray);
        Constructor targetConstructor = ReflectionUtil.getDeclaredConstructor(targetClass, paramTypes);
        return ReflectionUtil.invokeConstructor(targetConstructor, paramArray);
    }

    public static Object InvokeDeclaredConstructor(Class targetClass, Object[] paramArray, Class[] paramTypes) {
        Constructor targetConstructor = ReflectionUtil.getDeclaredConstructor(targetClass, paramTypes);
        return ReflectionUtil.invokeConstructor(targetConstructor, paramArray);
    }

    protected static Method getMethod(Object targetObject, String methodName, Class[] paramTypes) {
        return ReflectionUtil.getInternalMethod(targetObject, methodName, paramTypes, true);
    }

    protected static Method getDeclaredMethod(Object targetObject, String methodName, Class[] paramTypes) {
        return ReflectionUtil.getInternalMethod(targetObject, methodName, paramTypes, false);
    }

    protected static Method getInternalMethod(Object targetObject, String methodName, Class[] paramTypes, boolean isDeclaredMethod) {
        Method targetMethod = null;
        try {
            try {
                targetMethod = isDeclaredMethod ? targetObject.getClass().getMethod(methodName, paramTypes) : targetObject.getClass().getDeclaredMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (targetMethod == null) {
                Exception exception = null;
                for (Class<?> targetObjectClass = targetObject.getClass(); targetObjectClass != Object.class; targetObjectClass = targetObjectClass.getSuperclass()) {
                    exception = null;
                    try {
                        targetMethod = isDeclaredMethod ? ReflectionUtil.getMatchingMethod(targetObjectClass.getMethods(), methodName, paramTypes) : ReflectionUtil.getMatchingMethod(targetObjectClass.getDeclaredMethods(), methodName, paramTypes);
                    }
                    catch (SecurityException securityException2) {
                        exception = securityException2;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        exception = noSuchMethodException;
                    }
                    if (targetMethod != null) break;
                }
                if (exception != null) {
                    ClickniumJavaBridge.theClickniumJavaBridge.debugString("reflectionutil getInternalMethod exception:" + ((Exception)exception).getMessage());
                }
            }
            if (!isDeclaredMethod && targetMethod != null) {
                targetMethod.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("reflectionutil getInternalMethod:" + securityException.getMessage());
        }
        return targetMethod;
    }

    protected static Object invokeMethod(Object targetObject, Method targetMethod, Object[] paramArray) {
        try {
            if (targetMethod != null) {
                targetMethod.setAccessible(true);
                return targetMethod.invoke(targetObject, paramArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("reflectionutil invoke method failed:" + illegalArgumentException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("reflectionutil invoke method failed:" + illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("reflectionutil invoke method failed: " + invocationTargetException.getMessage());
        }
        catch (Exception exception) {
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("reflectionutil invoke method failed, class name:" + targetObject.getClass().toString() + ", method name:" + targetMethod.getName() + " ,error message: " + exception.getMessage());
        }
        return null;
    }

    protected static Class[] getMethodParamTypes(Object[] paramArray) {
        Class[] paramArrayClass = null;
        if (paramArray != null) {
            paramArrayClass = new Class[paramArray.length];
            for (int i = 0; i < paramArray.length; ++i) {
                Class currentClass = null;
                if (paramArray[i] != null) {
                    currentClass = paramArray[i].getClass();
                } else {
                    currentClass = Object.class;
                    ClickniumJavaBridge.theClickniumJavaBridge.debugString("current param is null, assign default Object class");
                }
                if (Number.class.isAssignableFrom(currentClass)) {
                    currentClass = ReflectionUtil.getPrimitiveType(currentClass);
                }
                paramArrayClass[i] = currentClass;
            }
        } else {
            paramArrayClass = NOAARGES_Classes;
        }
        return paramArrayClass;
    }

    public static Object getDeclaredField(Object targetObject, String fieldName) {
        if (targetObject == null || fieldName == null) {
            throw new NullPointerException();
        }
        return ReflectionUtil.getDeclaredField(targetObject.getClass(), targetObject, fieldName, false);
    }

    public static Object getDeclaredField(Class targetClass, String fieldName) {
        if (targetClass == null || fieldName == null) {
            throw new NullPointerException();
        }
        return ReflectionUtil.getDeclaredField(targetClass, null, fieldName, false);
    }

    public static Object getDeclaredField(Object targetObject, String fieldName, boolean paramBoolean) {
        if (targetObject == null || fieldName == null) {
            throw new NullPointerException();
        }
        return ReflectionUtil.getDeclaredField(targetObject.getClass(), targetObject, fieldName, paramBoolean);
    }

    public static Object getDeclaredField(Class paramClass, String paramString, boolean paramBoolean) {
        if (paramClass == null || paramString == null) {
            throw new NullPointerException();
        }
        return ReflectionUtil.getDeclaredField(paramClass, null, paramString, paramBoolean);
    }

    protected static Object getDeclaredField(Class paramClass, Object paramObject, String paramString, boolean paramBoolean) {
        if (paramClass == null || paramString == null) {
            throw new NullPointerException();
        }
        Field localField = null;
        Exception localObject = null;
        for (Class localClass = paramClass; localClass != Object.class; localClass = localClass.getSuperclass()) {
            localObject = null;
            try {
                localField = localClass.getDeclaredField(paramString);
            }
            catch (NoSuchFieldException localNoSuchFieldException) {
                localObject = localNoSuchFieldException;
            }
            catch (SecurityException localSecurityException1) {
                localObject = localSecurityException1;
            }
            if (localField != null) break;
        }
        if (localField != null) {
            try {
                localField.setAccessible(true);
                return localField.get(paramObject);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ClickniumJavaBridge.theClickniumJavaBridge.debugString("reflectionutil set field accessible failed exception:" + illegalArgumentException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                ClickniumJavaBridge.theClickniumJavaBridge.debugString("reflectionutil set field accessible failed exception: " + illegalAccessException.getMessage());
            }
            catch (SecurityException securityException2) {
                ClickniumJavaBridge.theClickniumJavaBridge.debugString("reflectionutil set field accessible failed exception: " + securityException2.getMessage());
            }
        }
        return null;
    }

    protected static Object invokeConstructor(Constructor constructor, Object[] paramArray) {
        try {
            if (constructor != null) {
                return constructor.newInstance(paramArray);
            }
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("invokeConstructor failed, constructor is null");
        }
        catch (InstantiationException instantiationException) {
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("invokeConstructor:" + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("invokeConstructor:" + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("invokeConstructor:" + illegalArgumentException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("invokeConstructor:" + invocationTargetException.getMessage());
        }
        return null;
    }

    protected static Constructor getDeclaredConstructor(Class targetClass, Class[] paramArray) {
        Constructor constructor = null;
        try {
            try {
                constructor = targetClass.getDeclaredConstructor(paramArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (constructor == null) {
                Exception exception = null;
                while (targetClass != Object.class) {
                    exception = null;
                    try {
                        constructor = ReflectionUtil.getMatchingConstructor(targetClass.getDeclaredConstructors(), paramArray);
                    }
                    catch (SecurityException securityException) {
                        exception = securityException;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        exception = noSuchMethodException;
                    }
                    if (constructor != null) break;
                    targetClass = targetClass.getSuperclass();
                }
                if (exception != null) {
                    ClickniumJavaBridge.theClickniumJavaBridge.debugString("reflectionutil getDeclaredConstructor exception:" + exception.getMessage());
                }
            }
            if (constructor != null) {
                constructor.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("reflectionutil getDeclaredConstructor" + securityException.getMessage());
        }
        return constructor;
    }

    protected static Constructor getMatchingConstructor(Constructor[] constructors, Class[] paramArray) throws NoSuchMethodException {
        int i = paramArray.length;
        Constructor targetConstructor = null;
        float f1 = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        int k = constructors.length;
        for (int j = 0; j < k; ++j) {
            Class<?>[] currentConstructorParmTypes = constructors[j].getParameterTypes();
            int m = currentConstructorParmTypes.length;
            if (m != i) continue;
            boolean n = true;
            for (int i1 = 0; i1 < m; ++i1) {
                if (ReflectionUtil.isAssignmentCompatible(currentConstructorParmTypes[i1], paramArray[i1])) continue;
                n = false;
                break;
            }
            if (!n || !((f2 = ReflectionUtil.getTotalTransformationCost(paramArray, constructors[j].getParameterTypes())) < f1)) continue;
            targetConstructor = constructors[j];
            f1 = f2;
        }
        if (targetConstructor == null) {
            throw new NoSuchMethodException();
        }
        return targetConstructor;
    }

    protected static Method getMatchingMethod(Method[] methods, String methodName, Class[] paramTypes) throws NoSuchMethodException {
        int i = paramTypes.length;
        Method targetMethod = null;
        float f1 = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        int k = methods.length;
        for (int j = 0; j < k; ++j) {
            Class<?>[] chrrentMethodParamTypes;
            int m;
            if (!methods[j].getName().equals(methodName) || (m = (chrrentMethodParamTypes = methods[j].getParameterTypes()).length) != i) continue;
            boolean n = true;
            for (int i1 = 0; i1 < m; ++i1) {
                if (ReflectionUtil.isAssignmentCompatible(chrrentMethodParamTypes[i1], paramTypes[i1])) continue;
                n = false;
                break;
            }
            if (!n || !((f2 = ReflectionUtil.getTotalTransformationCost(paramTypes, methods[j].getParameterTypes())) < f1)) continue;
            targetMethod = methods[j];
            f1 = f2;
        }
        if (targetMethod == null) {
            throw new NoSuchMethodException();
        }
        return targetMethod;
    }

    protected static final boolean isAssignmentCompatible(Class target, Class source) {
        Class primitiveClass;
        if (target.isAssignableFrom(source)) {
            return true;
        }
        if (target.isPrimitive() && (primitiveClass = ReflectionUtil.getPrimitiveWrapper(target)) != null) {
            return primitiveClass.equals(source);
        }
        return false;
    }

    protected static Class getPrimitiveWrapper(Class targetClass) {
        if (Boolean.TYPE.equals(targetClass)) {
            return Boolean.class;
        }
        if (Float.TYPE.equals(targetClass)) {
            return Float.class;
        }
        if (Long.TYPE.equals(targetClass)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(targetClass)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(targetClass)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(targetClass)) {
            return Byte.class;
        }
        if (Double.TYPE.equals(targetClass)) {
            return Double.class;
        }
        if (Character.TYPE.equals(targetClass)) {
            return Character.class;
        }
        return null;
    }

    protected static Class getPrimitiveType(Class targetCLass) {
        if (Boolean.class.equals((Object)targetCLass)) {
            return Boolean.TYPE;
        }
        if (Float.class.equals((Object)targetCLass)) {
            return Float.TYPE;
        }
        if (Long.class.equals((Object)targetCLass)) {
            return Long.TYPE;
        }
        if (Integer.class.equals((Object)targetCLass)) {
            return Integer.TYPE;
        }
        if (Short.class.equals((Object)targetCLass)) {
            return Short.TYPE;
        }
        if (Byte.class.equals((Object)targetCLass)) {
            return Byte.TYPE;
        }
        if (Double.class.equals((Object)targetCLass)) {
            return Double.TYPE;
        }
        if (Character.class.equals((Object)targetCLass)) {
            return Character.TYPE;
        }
        return null;
    }

    protected static float getTotalTransformationCost(Class[] targetParamTypes, Class[] currentParamTypes) {
        float f = 0.0f;
        for (int i = 0; i < targetParamTypes.length; ++i) {
            Class localClass1 = targetParamTypes[i];
            Class localClass2 = currentParamTypes[i];
            f += ReflectionUtil.getObjectTransformationCost(localClass1, localClass2);
        }
        return f;
    }

    protected static float getObjectTransformationCost(Class targetClass, Class currentClass) {
        float f = 0.0f;
        while (currentClass != null && !currentClass.equals(targetClass)) {
            if (currentClass.isInterface() && ReflectionUtil.isAssignmentCompatible(currentClass, targetClass)) {
                f += 0.25f;
                break;
            }
            f += 1.0f;
            currentClass = currentClass.getSuperclass();
        }
        if (currentClass == null) {
            f += 1.5f;
        }
        return f;
    }
}

