/*
 * Decompiled with CFR 0.152.
 */
package com.clicknium.customaccessiblecomponent.Swing;

import com.clicknium.customaccessiblecomponent.Common.ClickniumAccessibleComponent;
import com.clicknium.customaccessiblecomponent.Common.ClickniumAccessibleRole;
import com.clicknium.utils.ReflectionUtil;
import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;

public class ClickniumAccessibleScrollBarThumb
extends ClickniumAccessibleComponent {
    private Object scrollBarUI;
    private int indexInParent;
    private Accessible parent;

    public ClickniumAccessibleScrollBarThumb(Object scrollBarUI, int indexInParent, Accessible parent) {
        super(null);
        this.scrollBarUI = scrollBarUI;
        this.indexInParent = indexInParent;
        this.parent = parent;
    }

    public AccessibleRole getAccessibleRole() {
        return ClickniumAccessibleRole.SCROLL_BAR_THUMB;
    }

    public AccessibleStateSet getAccessibleStateSet() {
        AccessibleContext accessibleContext;
        Accessible parent = this.parent;
        if (parent != null && (accessibleContext = parent.getAccessibleContext()) != null) {
            return accessibleContext.getAccessibleStateSet();
        }
        return null;
    }

    public Accessible getAccessibleParent() {
        return this.parent;
    }

    public int getAccessibleIndexInParent() {
        return this.indexInParent;
    }

    public Point getLocationOnScreen() {
        AccessibleComponent parentAccessibleComponent;
        AccessibleContext parentAccessibleContext;
        Accessible parent = this.parent;
        if (parent != null && (parentAccessibleContext = parent.getAccessibleContext()) != null && (parentAccessibleComponent = parentAccessibleContext.getAccessibleComponent()) != null) {
            Point parentLocation = parentAccessibleComponent.getLocationOnScreen();
            Rectangle thumbBounds = this.getBounds();
            parentLocation.x += thumbBounds.x;
            parentLocation.y += thumbBounds.y;
            return parentLocation;
        }
        return null;
    }

    public Rectangle getBounds() {
        Rectangle bounds = (Rectangle)ReflectionUtil.getDeclaredField(this.scrollBarUI, "thumbRect");
        return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
    }
}

