/*
 * Decompiled with CFR 0.152.
 */
package com.clicknium.customaccessiblecomponent.Override.AWT;

import com.clicknium.customaccessiblecomponent.Override.ClickniumOverrideAccessible;
import com.clicknium.utils.ReflectionUtil;
import java.awt.Checkbox;
import java.awt.event.ItemEvent;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleValue;

public class ClickniumOverrideAccessibleAwtCheckbox
extends ClickniumOverrideAccessible
implements AccessibleAction,
AccessibleValue {
    private Checkbox checkbox;

    public ClickniumOverrideAccessibleAwtCheckbox(Object object) {
        super(object);
        if (object instanceof Checkbox) {
            this.checkbox = (Checkbox)object;
        }
    }

    public String getAccessibleName() {
        return this.checkbox == null ? null : this.checkbox.getLabel();
    }

    public AccessibleAction getAccessibleAction() {
        return this;
    }

    public AccessibleValue getAccessibleValue() {
        return this;
    }

    public int getAccessibleActionCount() {
        return 1;
    }

    public String getAccessibleActionDescription(int index) {
        if (index == 0) {
            return "click";
        }
        return null;
    }

    public boolean doAccessibleAction(int index) {
        if (index == 0) {
            if (this.isCheckboxSelected()) {
                this.setCheckboxSelected(false);
            } else {
                this.setCheckboxSelected(true);
            }
            return true;
        }
        return false;
    }

    public Number getCurrentAccessibleValue() {
        return this.isCheckboxSelected() ? new Integer(1) : new Integer(0);
    }

    public boolean setCurrentAccessibleValue(Number value) {
        if (value != null) {
            int numberValue = value.intValue();
            if (numberValue == 0) {
                this.setCheckboxSelected(false);
            } else {
                this.setCheckboxSelected(true);
            }
            return true;
        }
        return false;
    }

    public Number getMinimumAccessibleValue() {
        return new Integer(0);
    }

    public Number getMaximumAccessibleValue() {
        return new Integer(1);
    }

    private boolean isCheckboxSelected() {
        return this.checkbox != null && this.checkbox.getState();
    }

    private void setCheckboxSelected(boolean selected) {
        AccessibleComponent accessibleComponent = this.sourceAccessibleContext.getAccessibleComponent();
        if (accessibleComponent != null) {
            accessibleComponent.requestFocus();
        }
        if (this.checkbox != null) {
            this.checkbox.setState(selected);
        }
        ItemEvent itemEvent = new ItemEvent(this.checkbox, 701, "", selected ? 1 : 2);
        ReflectionUtil.InvokeDeclaredMethod(this.checkbox, "processEvent", new Object[]{itemEvent});
    }
}

