/*
 * Decompiled with CFR 0.152.
 */
package com.clicknium.customaccessiblecomponent.KingDee.Report;

import com.clicknium.customaccessiblecomponent.Common.ClickniumAccessibleComponent;
import com.clicknium.customaccessiblecomponent.Common.ClickniumAccessibleRole;
import com.clicknium.utils.ReflectionUtil;
import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;

public class ClickniumAccessibleKDRowHeader
extends ClickniumAccessibleComponent {
    private Object spread;
    private Object book;
    private Object currentSheet;
    private int firstRowIndex = -1;
    private int endRowIndex = -1;
    private int hViewIndex = -1;

    public ClickniumAccessibleKDRowHeader(Object component) {
        super(component);
    }

    public AccessibleRole getAccessibleRole() {
        return ClickniumAccessibleRole.KD_REPORT_TABLE_ROW_HEADER;
    }

    public int getAccessibleChildrenCount() {
        return this.getVisibleRowCount();
    }

    public Accessible getAccessibleChild(int index) {
        if (index >= 0 && index < this.getAccessibleChildrenCount()) {
            if (this.isFreezed()) {
                int hViewIndex = this.getHViewIndex();
                if (hViewIndex == 2) {
                    return new ClickniumAccessibleKDRowHeaderCell(null, index, index);
                }
                if (hViewIndex == 3) {
                    return new ClickniumAccessibleKDRowHeaderCell(null, index, index + this.getFirstRowIndex());
                }
            } else {
                return new ClickniumAccessibleKDRowHeaderCell(null, index, index);
            }
        }
        return null;
    }

    public Point getLocationOnScreen() {
        return this.getAccessibleParent().getAccessibleContext().getAccessibleComponent().getLocationOnScreen();
    }

    public Rectangle getBounds() {
        return this.getAccessibleParent().getAccessibleContext().getAccessibleComponent().getBounds();
    }

    private Object getSpread() {
        if (this.spread == null) {
            this.spread = ReflectionUtil.InvokeMethod(this.source, "getSpread");
        }
        return this.spread;
    }

    private Object getBook() {
        Object spread;
        if (this.book == null && (spread = this.getSpread()) != null) {
            this.book = ReflectionUtil.InvokeMethod(spread, "getBook");
        }
        return this.book;
    }

    private Object getCurrentSheet() {
        Object book;
        if (this.currentSheet == null && (book = this.getBook()) != null) {
            this.currentSheet = ReflectionUtil.InvokeMethod(book, "getActiveSheet");
        }
        return this.currentSheet;
    }

    private Object getSheetOption() {
        Object sheet = this.getCurrentSheet();
        if (sheet != null) {
            return ReflectionUtil.InvokeMethod(sheet, "getSheetOption");
        }
        return null;
    }

    private Object getViewSplitInfo() {
        Object sheetOptions = this.getSheetOption();
        if (sheetOptions != null) {
            return ReflectionUtil.InvokeMethod(sheetOptions, "getViewSplitInfo");
        }
        return null;
    }

    private int getHViewIndex() {
        Object hViewIndexObject;
        if (this.hViewIndex < 0 && (hViewIndexObject = ReflectionUtil.InvokeMethod(this.source, "getClientProperty", new Object[]{"VViewIndex"})) != null) {
            this.hViewIndex = ((Number)hViewIndexObject).intValue();
        }
        return this.hViewIndex;
    }

    private int getAllRowCount() {
        Object rowsObject = ReflectionUtil.InvokeMethod(this.getCurrentSheet(), "getRows");
        if (rowsObject != null) {
            return ((Number)ReflectionUtil.InvokeMethod(rowsObject, "size")).intValue();
        }
        return 0;
    }

    private int getVisibleRowCount() {
        return this.getEndRowIndex() - this.getFirstRowIndex() + 1;
    }

    private int getFirstRowIndex() {
        Object firstRowIndexObject;
        if (this.firstRowIndex < 0 && (firstRowIndexObject = ReflectionUtil.InvokeMethod(this.source, "getFirstRow")) != null) {
            this.firstRowIndex = ((Number)firstRowIndexObject).intValue();
        }
        return this.firstRowIndex;
    }

    private int getEndRowIndex() {
        Object endRowIndexObject;
        if (this.endRowIndex < 0 && (endRowIndexObject = ReflectionUtil.InvokeMethod(this.source, "getEndRow")) != null) {
            this.endRowIndex = ((Number)endRowIndexObject).intValue();
        }
        return this.endRowIndex;
    }

    private String getRowName(int index) {
        Object currentSheet = this.getCurrentSheet();
        if (currentSheet != null) {
            return (String)ReflectionUtil.InvokeMethod(currentSheet, "getRowName", new Object[]{currentSheet, index});
        }
        return null;
    }

    private Rectangle getRowHeaderCellRectangle(int index) {
        Object currentSheet = this.getCurrentSheet();
        if (currentSheet != null) {
            return (Rectangle)ReflectionUtil.InvokeMethod(currentSheet, "getRowHeaderRect", new Object[]{currentSheet, index});
        }
        return new Rectangle();
    }

    protected boolean isFreezed() {
        Object freezedObject;
        Object splitInfo = this.getViewSplitInfo();
        if (splitInfo != null && (freezedObject = ReflectionUtil.InvokeMethod(splitInfo, "isFreezed")) != null) {
            return Boolean.parseBoolean(freezedObject.toString());
        }
        return false;
    }

    protected int getFixRowCount() {
        Object splitInfo = this.getViewSplitInfo();
        if (splitInfo != null) {
            return ((Number)ReflectionUtil.InvokeMethod(splitInfo, "getRowFixLine")).intValue();
        }
        return -1;
    }

    private int getFirstTableHeaderRowPositionY() {
        if (this.isFreezed() && this.getFixRowCount() > 0) {
            return this.getRowHeaderCellRectangle((int)this.getFirstRowIndex()).y;
        }
        return 0;
    }

    public class ClickniumAccessibleKDRowHeaderCell
    extends ClickniumAccessibleComponent {
        private int index;
        private int actualIndex;

        public ClickniumAccessibleKDRowHeaderCell(Object component, int index, int actualIndex) {
            super(component);
            this.index = index;
            this.actualIndex = actualIndex;
        }

        public String getAccessibleName() {
            return ClickniumAccessibleKDRowHeader.this.getRowName(this.actualIndex);
        }

        public AccessibleRole getAccessibleRole() {
            return ClickniumAccessibleRole.LABEL;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return ClickniumAccessibleKDRowHeader.this.getAccessibleStateSet();
        }

        public Accessible getAccessibleParent() {
            return ClickniumAccessibleKDRowHeader.this;
        }

        public Point getLocationOnScreen() {
            Rectangle cellRectangle = ClickniumAccessibleKDRowHeader.this.getRowHeaderCellRectangle(this.actualIndex);
            Point parentPosition = ClickniumAccessibleKDRowHeader.this.getLocationOnScreen();
            parentPosition.x += cellRectangle.x;
            parentPosition.y = ClickniumAccessibleKDRowHeader.this.isFreezed() && ClickniumAccessibleKDRowHeader.this.getHViewIndex() == 3 ? (parentPosition.y += cellRectangle.y - ClickniumAccessibleKDRowHeader.this.getFirstTableHeaderRowPositionY()) : (parentPosition.y += cellRectangle.y);
            return parentPosition;
        }

        public Rectangle getBounds() {
            return ClickniumAccessibleKDRowHeader.this.getRowHeaderCellRectangle(this.actualIndex);
        }
    }
}

