# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['utils_ak',
 'utils_ak.architecture',
 'utils_ak.architecture.finite_state_machine',
 'utils_ak.architecture.func',
 'utils_ak.architecture.integrity_guard',
 'utils_ak.architecture.operation',
 'utils_ak.architecture.sink',
 'utils_ak.async_tools',
 'utils_ak.block_tree',
 'utils_ak.block_tree.pushers',
 'utils_ak.builtin',
 'utils_ak.callback_timer',
 'utils_ak.clickhouse',
 'utils_ak.clickhouse.config',
 'utils_ak.clock',
 'utils_ak.coder',
 'utils_ak.coder.coders',
 'utils_ak.coder.coders.json',
 'utils_ak.coder.coders.msgpack',
 'utils_ak.color',
 'utils_ak.config',
 'utils_ak.dag',
 'utils_ak.deployment',
 'utils_ak.deployment.controller',
 'utils_ak.deployment.controller.controllers',
 'utils_ak.deployment.example',
 'utils_ak.dict',
 'utils_ak.exceptions',
 'utils_ak.fluid_flow',
 'utils_ak.fluid_flow.actors',
 'utils_ak.fluid_flow.tests',
 'utils_ak.git',
 'utils_ak.hash',
 'utils_ak.iteration',
 'utils_ak.job_orchestrator',
 'utils_ak.job_orchestrator.tests',
 'utils_ak.job_orchestrator.worker',
 'utils_ak.job_orchestrator.worker.test',
 'utils_ak.job_orchestrator.worker.test.inbox',
 'utils_ak.jupyter',
 'utils_ak.kafka',
 'utils_ak.kafka.archive',
 'utils_ak.loguru',
 'utils_ak.message_queue',
 'utils_ak.message_queue.brokers',
 'utils_ak.message_queue.brokers.examples',
 'utils_ak.message_queue.clients',
 'utils_ak.mongoengine',
 'utils_ak.naming',
 'utils_ak.networking',
 'utils_ak.networking.proxy',
 'utils_ak.nn',
 'utils_ak.numeric',
 'utils_ak.openpyxl',
 'utils_ak.os',
 'utils_ak.pandas',
 'utils_ak.plot',
 'utils_ak.portion',
 'utils_ak.properties',
 'utils_ak.properties.archive',
 'utils_ak.proxy',
 'utils_ak.re',
 'utils_ak.reflexion',
 'utils_ak.screen',
 'utils_ak.screen.archive',
 'utils_ak.screen.tests',
 'utils_ak.simple_event_manager',
 'utils_ak.simple_microservice',
 'utils_ak.simple_microservice.examples',
 'utils_ak.simple_vector',
 'utils_ak.split_file',
 'utils_ak.state',
 'utils_ak.state.provider',
 'utils_ak.state.provider.providers',
 'utils_ak.str',
 'utils_ak.streaming',
 'utils_ak.streaming.windowing',
 'utils_ak.system',
 'utils_ak.time',
 'utils_ak.tqdm',
 'utils_ak.zmq',
 'utils_ak.zmq.benchmark']

package_data = \
{'': ['*'],
 'utils_ak.config': ['sample_configs/*'],
 'utils_ak.deployment.controller.controllers': ['data/123/*'],
 'utils_ak.deployment.example': ['configs/*', 'inbox/*'],
 'utils_ak.job_orchestrator': ['data/docker-compose/603384f556f388e8aeceb221/*',
                               'data/docker-compose/603385670c7c448055c8a574/*',
                               'data/docker-compose/60338b8dcfb2b0d1518ab942/*',
                               'data/docker-compose/60338c65a934f591503fa342/*',
                               'data/docker-compose/60338c7b3ceb6807bc8bf137/*',
                               'data/docker-compose/60338cd3d10015ef72308dca/*',
                               'data/docker-compose/6033ac8e50a3b29e09cf4b47/*',
                               'data/docker-compose/6033acb73993552852600347/*',
                               'data/docker-compose/6033acdd0ec1968d521e6ff0/*',
                               'data/docker-compose/6033ad356ad37d72409f823c/*',
                               'data/docker-compose/6033ad6227fcab41c088641c/*',
                               'data/docker-compose/6033ad832ef3c2e3d6f707e4/*'],
 'utils_ak.job_orchestrator.worker.test': ['data/docker-compose/deployment_id/*'],
 'utils_ak.screen': ['logs/*', 'screen_logs/*']}

install_requires = \
['Delorean>=1.0.0,<2.0.0',
 'GitPython>=3.1.9,<4.0.0',
 'PyYAML>=5.4.1,<6.0.0',
 'anyconfig>=0.9.11,<0.10.0',
 'boto3>=1.15.18,<2.0.0',
 'empyrical>=0.5.5,<0.6.0',
 'filelock>=3.0.12,<4.0.0',
 'fire>=0.4.0,<0.5.0',
 'h5py>=2.10.0,<3.0.0',
 'joblib>=0.17.0,<0.18.0',
 'loguru>=0.5.3,<0.6.0',
 'mongoengine>=0.22.1,<0.23.0',
 'msgpack>=1.0.2,<2.0.0',
 'numpy>=1.19.2,<2.0.0',
 'opencv-python>=4.4.0,<5.0.0',
 'openpyxl>=3.0.6,<4.0.0',
 'pandas>=1.1.3,<2.0.0',
 'paramiko>=2.7.2,<3.0.0',
 'pathlib>=1.0.1,<2.0.0',
 'pickleDB>=0.9.2,<0.10.0',
 'portion>=2.1.4,<3.0.0',
 'pymongo>=3.11.0,<4.0.0',
 'pyperclip>=1.8.1,<2.0.0',
 'pyzmail36>=1.0.4,<2.0.0',
 'pyzmq>=19.0.2,<20.0.0',
 'requests-futures>=1.0.0,<2.0.0',
 'retrypy>=0.0.33,<0.0.34',
 'scp>=0.13.2,<0.14.0',
 'seaborn>=0.11.0,<0.12.0',
 'slacker>=0.14.0,<0.15.0',
 'sortedcollections>=2.1.0,<3.0.0',
 'stackprinter>=0.2.5,<0.3.0',
 'telegram>=0.0.1,<0.0.2',
 'tenacity>=6.2.0,<7.0.0',
 'tqdm>=4.50.2,<5.0.0']

setup_kwargs = {
    'name': 'utils-ak',
    'version': '0.1.7',
    'description': 'Lots of small utils',
    'long_description': None,
    'author': 'akadaner',
    'author_email': 'arseniikadaner@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7.1,<4.0.0',
}


setup(**setup_kwargs)
