import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceCustomIssueTrackerConfig extends cdktf.TerraformMetaArguments {
    /**
    * The URL to view an issue in the external issue tracker. Must contain :id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_custom_issue_tracker#issues_url ServiceCustomIssueTracker#issues_url}
    */
    readonly issuesUrl: string;
    /**
    * The ID or full path of the project for the custom issue tracker.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_custom_issue_tracker#project ServiceCustomIssueTracker#project}
    */
    readonly project: string;
    /**
    * The URL to the project in the external issue tracker.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_custom_issue_tracker#project_url ServiceCustomIssueTracker#project_url}
    */
    readonly projectUrl: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/service_custom_issue_tracker gitlab_service_custom_issue_tracker}
*/
export declare class ServiceCustomIssueTracker extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_service_custom_issue_tracker";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/service_custom_issue_tracker gitlab_service_custom_issue_tracker} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceCustomIssueTrackerConfig
    */
    constructor(scope: Construct, id: string, config: ServiceCustomIssueTrackerConfig);
    get active(): cdktf.IResolvable;
    get createdAt(): string;
    get id(): string;
    private _issuesUrl?;
    get issuesUrl(): string;
    set issuesUrl(value: string);
    get issuesUrlInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _projectUrl?;
    get projectUrl(): string;
    set projectUrl(value: string);
    get projectUrlInput(): string | undefined;
    get slug(): string;
    get updatedAt(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
