import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RepositoryFileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Email of the commit author.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#author_email RepositoryFile#author_email}
    */
    readonly authorEmail?: string;
    /**
    * Name of the commit author.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#author_name RepositoryFile#author_name}
    */
    readonly authorName?: string;
    /**
    * Name of the branch to which to commit to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#branch RepositoryFile#branch}
    */
    readonly branch: string;
    /**
    * Commit message.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#commit_message RepositoryFile#commit_message}
    */
    readonly commitMessage: string;
    /**
    * File content. If the content is not yet base64 encoded, it will be encoded automatically. No other encoding is currently supported, because of a [GitLab API bug](https://gitlab.com/gitlab-org/gitlab/-/issues/342430).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#content RepositoryFile#content}
    */
    readonly content: string;
    /**
    * Enables or disables the execute flag on the file. **Note**: requires GitLab 14.10 or newer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#execute_filemode RepositoryFile#execute_filemode}
    */
    readonly executeFilemode?: boolean | cdktf.IResolvable;
    /**
    * The full path of the file. It must be relative to the root of the project without a leading slash `/` or `./`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#file_path RepositoryFile#file_path}
    */
    readonly filePath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#id RepositoryFile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Enable overwriting existing files, defaults to `false`. This attribute is only used during `create` and must be use carefully. We suggest to use `imports` whenever possible and limit the use of this attribute for when the project was imported on the same `apply`. This attribute is not supported during a resource import.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#overwrite_on_create RepositoryFile#overwrite_on_create}
    */
    readonly overwriteOnCreate?: boolean | cdktf.IResolvable;
    /**
    * The name or ID of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#project RepositoryFile#project}
    */
    readonly project: string;
    /**
    * Name of the branch to start the new commit from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#start_branch RepositoryFile#start_branch}
    */
    readonly startBranch?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#timeouts RepositoryFile#timeouts}
    */
    readonly timeouts?: RepositoryFileTimeouts;
}
export interface RepositoryFileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#create RepositoryFile#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#delete RepositoryFile#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file#update RepositoryFile#update}
    */
    readonly update?: string;
}
export declare function repositoryFileTimeoutsToTerraform(struct?: RepositoryFileTimeoutsOutputReference | RepositoryFileTimeouts | cdktf.IResolvable): any;
export declare class RepositoryFileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RepositoryFileTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: RepositoryFileTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file gitlab_repository_file}
*/
export declare class RepositoryFile extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_repository_file";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/repository_file gitlab_repository_file} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RepositoryFileConfig
    */
    constructor(scope: Construct, id: string, config: RepositoryFileConfig);
    private _authorEmail?;
    get authorEmail(): string;
    set authorEmail(value: string);
    resetAuthorEmail(): void;
    get authorEmailInput(): string | undefined;
    private _authorName?;
    get authorName(): string;
    set authorName(value: string);
    resetAuthorName(): void;
    get authorNameInput(): string | undefined;
    get blobId(): string;
    private _branch?;
    get branch(): string;
    set branch(value: string);
    get branchInput(): string | undefined;
    get commitId(): string;
    private _commitMessage?;
    get commitMessage(): string;
    set commitMessage(value: string);
    get commitMessageInput(): string | undefined;
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    get contentSha256(): string;
    get encoding(): string;
    private _executeFilemode?;
    get executeFilemode(): boolean | cdktf.IResolvable;
    set executeFilemode(value: boolean | cdktf.IResolvable);
    resetExecuteFilemode(): void;
    get executeFilemodeInput(): boolean | cdktf.IResolvable | undefined;
    get fileName(): string;
    private _filePath?;
    get filePath(): string;
    set filePath(value: string);
    get filePathInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastCommitId(): string;
    private _overwriteOnCreate?;
    get overwriteOnCreate(): boolean | cdktf.IResolvable;
    set overwriteOnCreate(value: boolean | cdktf.IResolvable);
    resetOverwriteOnCreate(): void;
    get overwriteOnCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get ref(): string;
    get size(): number;
    private _startBranch?;
    get startBranch(): string;
    set startBranch(value: string);
    resetStartBranch(): void;
    get startBranchInput(): string | undefined;
    private _timeouts;
    get timeouts(): RepositoryFileTimeoutsOutputReference;
    putTimeouts(value: RepositoryFileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | RepositoryFileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
