"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab gitlab}
*/
class GitlabProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab gitlab} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GitlabProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'gitlab',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '15.10.0',
                providerVersionConstraint: '~> 15.7'
            },
            terraformProviderSource: 'gitlabhq/gitlab'
        });
        this._baseUrl = config.baseUrl;
        this._cacertFile = config.cacertFile;
        this._clientCert = config.clientCert;
        this._clientKey = config.clientKey;
        this._earlyAuthCheck = config.earlyAuthCheck;
        this._insecure = config.insecure;
        this._token = config.token;
        this._alias = config.alias;
    }
    get baseUrl() {
        return this._baseUrl;
    }
    set baseUrl(value) {
        this._baseUrl = value;
    }
    resetBaseUrl() {
        this._baseUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get baseUrlInput() {
        return this._baseUrl;
    }
    get cacertFile() {
        return this._cacertFile;
    }
    set cacertFile(value) {
        this._cacertFile = value;
    }
    resetCacertFile() {
        this._cacertFile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cacertFileInput() {
        return this._cacertFile;
    }
    get clientCert() {
        return this._clientCert;
    }
    set clientCert(value) {
        this._clientCert = value;
    }
    resetClientCert() {
        this._clientCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertInput() {
        return this._clientCert;
    }
    get clientKey() {
        return this._clientKey;
    }
    set clientKey(value) {
        this._clientKey = value;
    }
    resetClientKey() {
        this._clientKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientKeyInput() {
        return this._clientKey;
    }
    get earlyAuthCheck() {
        return this._earlyAuthCheck;
    }
    set earlyAuthCheck(value) {
        this._earlyAuthCheck = value;
    }
    resetEarlyAuthCheck() {
        this._earlyAuthCheck = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get earlyAuthCheckInput() {
        return this._earlyAuthCheck;
    }
    get insecure() {
        return this._insecure;
    }
    set insecure(value) {
        this._insecure = value;
    }
    resetInsecure() {
        this._insecure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insecureInput() {
        return this._insecure;
    }
    get token() {
        return this._token;
    }
    set token(value) {
        this._token = value;
    }
    resetToken() {
        this._token = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            base_url: cdktf.stringToTerraform(this._baseUrl),
            cacert_file: cdktf.stringToTerraform(this._cacertFile),
            client_cert: cdktf.stringToTerraform(this._clientCert),
            client_key: cdktf.stringToTerraform(this._clientKey),
            early_auth_check: cdktf.booleanToTerraform(this._earlyAuthCheck),
            insecure: cdktf.booleanToTerraform(this._insecure),
            token: cdktf.stringToTerraform(this._token),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.GitlabProvider = GitlabProvider;
_a = JSII_RTTI_SYMBOL_1;
GitlabProvider[_a] = { fqn: "@cdktf/provider-gitlab.provider.GitlabProvider", version: "6.0.2" };
// =================
// STATIC PROPERTIES
// =================
GitlabProvider.tfResourceType = "gitlab";
//# sourceMappingURL=data:application/json;base64,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