"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Project = exports.ProjectPushRulesOutputReference = exports.projectPushRulesToTerraform = exports.ProjectContainerExpirationPolicyOutputReference = exports.projectContainerExpirationPolicyToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function projectContainerExpirationPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cadence: cdktf.stringToTerraform(struct.cadence),
        enabled: cdktf.booleanToTerraform(struct.enabled),
        keep_n: cdktf.numberToTerraform(struct.keepN),
        name_regex: cdktf.stringToTerraform(struct.nameRegex),
        name_regex_delete: cdktf.stringToTerraform(struct.nameRegexDelete),
        name_regex_keep: cdktf.stringToTerraform(struct.nameRegexKeep),
        older_than: cdktf.stringToTerraform(struct.olderThan),
    };
}
exports.projectContainerExpirationPolicyToTerraform = projectContainerExpirationPolicyToTerraform;
class ProjectContainerExpirationPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cadence !== undefined) {
            hasAnyValues = true;
            internalValueResult.cadence = this._cadence;
        }
        if (this._enabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.enabled = this._enabled;
        }
        if (this._keepN !== undefined) {
            hasAnyValues = true;
            internalValueResult.keepN = this._keepN;
        }
        if (this._nameRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.nameRegex = this._nameRegex;
        }
        if (this._nameRegexDelete !== undefined) {
            hasAnyValues = true;
            internalValueResult.nameRegexDelete = this._nameRegexDelete;
        }
        if (this._nameRegexKeep !== undefined) {
            hasAnyValues = true;
            internalValueResult.nameRegexKeep = this._nameRegexKeep;
        }
        if (this._olderThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.olderThan = this._olderThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cadence = undefined;
            this._enabled = undefined;
            this._keepN = undefined;
            this._nameRegex = undefined;
            this._nameRegexDelete = undefined;
            this._nameRegexKeep = undefined;
            this._olderThan = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cadence = value.cadence;
            this._enabled = value.enabled;
            this._keepN = value.keepN;
            this._nameRegex = value.nameRegex;
            this._nameRegexDelete = value.nameRegexDelete;
            this._nameRegexKeep = value.nameRegexKeep;
            this._olderThan = value.olderThan;
        }
    }
    get cadence() {
        return this.getStringAttribute('cadence');
    }
    set cadence(value) {
        this._cadence = value;
    }
    resetCadence() {
        this._cadence = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cadenceInput() {
        return this._cadence;
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get keepN() {
        return this.getNumberAttribute('keep_n');
    }
    set keepN(value) {
        this._keepN = value;
    }
    resetKeepN() {
        this._keepN = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepNInput() {
        return this._keepN;
    }
    get nameRegex() {
        return this.getStringAttribute('name_regex');
    }
    set nameRegex(value) {
        this._nameRegex = value;
    }
    resetNameRegex() {
        this._nameRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameRegexInput() {
        return this._nameRegex;
    }
    get nameRegexDelete() {
        return this.getStringAttribute('name_regex_delete');
    }
    set nameRegexDelete(value) {
        this._nameRegexDelete = value;
    }
    resetNameRegexDelete() {
        this._nameRegexDelete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameRegexDeleteInput() {
        return this._nameRegexDelete;
    }
    get nameRegexKeep() {
        return this.getStringAttribute('name_regex_keep');
    }
    set nameRegexKeep(value) {
        this._nameRegexKeep = value;
    }
    resetNameRegexKeep() {
        this._nameRegexKeep = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameRegexKeepInput() {
        return this._nameRegexKeep;
    }
    // next_run_at - computed: true, optional: false, required: false
    get nextRunAt() {
        return this.getStringAttribute('next_run_at');
    }
    get olderThan() {
        return this.getStringAttribute('older_than');
    }
    set olderThan(value) {
        this._olderThan = value;
    }
    resetOlderThan() {
        this._olderThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get olderThanInput() {
        return this._olderThan;
    }
}
exports.ProjectContainerExpirationPolicyOutputReference = ProjectContainerExpirationPolicyOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ProjectContainerExpirationPolicyOutputReference[_a] = { fqn: "@cdktf/provider-gitlab.project.ProjectContainerExpirationPolicyOutputReference", version: "6.0.2" };
function projectPushRulesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        author_email_regex: cdktf.stringToTerraform(struct.authorEmailRegex),
        branch_name_regex: cdktf.stringToTerraform(struct.branchNameRegex),
        commit_committer_check: cdktf.booleanToTerraform(struct.commitCommitterCheck),
        commit_message_negative_regex: cdktf.stringToTerraform(struct.commitMessageNegativeRegex),
        commit_message_regex: cdktf.stringToTerraform(struct.commitMessageRegex),
        deny_delete_tag: cdktf.booleanToTerraform(struct.denyDeleteTag),
        file_name_regex: cdktf.stringToTerraform(struct.fileNameRegex),
        max_file_size: cdktf.numberToTerraform(struct.maxFileSize),
        member_check: cdktf.booleanToTerraform(struct.memberCheck),
        prevent_secrets: cdktf.booleanToTerraform(struct.preventSecrets),
        reject_unsigned_commits: cdktf.booleanToTerraform(struct.rejectUnsignedCommits),
    };
}
exports.projectPushRulesToTerraform = projectPushRulesToTerraform;
class ProjectPushRulesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._authorEmailRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.authorEmailRegex = this._authorEmailRegex;
        }
        if (this._branchNameRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.branchNameRegex = this._branchNameRegex;
        }
        if (this._commitCommitterCheck !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitCommitterCheck = this._commitCommitterCheck;
        }
        if (this._commitMessageNegativeRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitMessageNegativeRegex = this._commitMessageNegativeRegex;
        }
        if (this._commitMessageRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitMessageRegex = this._commitMessageRegex;
        }
        if (this._denyDeleteTag !== undefined) {
            hasAnyValues = true;
            internalValueResult.denyDeleteTag = this._denyDeleteTag;
        }
        if (this._fileNameRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.fileNameRegex = this._fileNameRegex;
        }
        if (this._maxFileSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxFileSize = this._maxFileSize;
        }
        if (this._memberCheck !== undefined) {
            hasAnyValues = true;
            internalValueResult.memberCheck = this._memberCheck;
        }
        if (this._preventSecrets !== undefined) {
            hasAnyValues = true;
            internalValueResult.preventSecrets = this._preventSecrets;
        }
        if (this._rejectUnsignedCommits !== undefined) {
            hasAnyValues = true;
            internalValueResult.rejectUnsignedCommits = this._rejectUnsignedCommits;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._authorEmailRegex = undefined;
            this._branchNameRegex = undefined;
            this._commitCommitterCheck = undefined;
            this._commitMessageNegativeRegex = undefined;
            this._commitMessageRegex = undefined;
            this._denyDeleteTag = undefined;
            this._fileNameRegex = undefined;
            this._maxFileSize = undefined;
            this._memberCheck = undefined;
            this._preventSecrets = undefined;
            this._rejectUnsignedCommits = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._authorEmailRegex = value.authorEmailRegex;
            this._branchNameRegex = value.branchNameRegex;
            this._commitCommitterCheck = value.commitCommitterCheck;
            this._commitMessageNegativeRegex = value.commitMessageNegativeRegex;
            this._commitMessageRegex = value.commitMessageRegex;
            this._denyDeleteTag = value.denyDeleteTag;
            this._fileNameRegex = value.fileNameRegex;
            this._maxFileSize = value.maxFileSize;
            this._memberCheck = value.memberCheck;
            this._preventSecrets = value.preventSecrets;
            this._rejectUnsignedCommits = value.rejectUnsignedCommits;
        }
    }
    get authorEmailRegex() {
        return this.getStringAttribute('author_email_regex');
    }
    set authorEmailRegex(value) {
        this._authorEmailRegex = value;
    }
    resetAuthorEmailRegex() {
        this._authorEmailRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authorEmailRegexInput() {
        return this._authorEmailRegex;
    }
    get branchNameRegex() {
        return this.getStringAttribute('branch_name_regex');
    }
    set branchNameRegex(value) {
        this._branchNameRegex = value;
    }
    resetBranchNameRegex() {
        this._branchNameRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get branchNameRegexInput() {
        return this._branchNameRegex;
    }
    get commitCommitterCheck() {
        return this.getBooleanAttribute('commit_committer_check');
    }
    set commitCommitterCheck(value) {
        this._commitCommitterCheck = value;
    }
    resetCommitCommitterCheck() {
        this._commitCommitterCheck = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitCommitterCheckInput() {
        return this._commitCommitterCheck;
    }
    get commitMessageNegativeRegex() {
        return this.getStringAttribute('commit_message_negative_regex');
    }
    set commitMessageNegativeRegex(value) {
        this._commitMessageNegativeRegex = value;
    }
    resetCommitMessageNegativeRegex() {
        this._commitMessageNegativeRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitMessageNegativeRegexInput() {
        return this._commitMessageNegativeRegex;
    }
    get commitMessageRegex() {
        return this.getStringAttribute('commit_message_regex');
    }
    set commitMessageRegex(value) {
        this._commitMessageRegex = value;
    }
    resetCommitMessageRegex() {
        this._commitMessageRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitMessageRegexInput() {
        return this._commitMessageRegex;
    }
    get denyDeleteTag() {
        return this.getBooleanAttribute('deny_delete_tag');
    }
    set denyDeleteTag(value) {
        this._denyDeleteTag = value;
    }
    resetDenyDeleteTag() {
        this._denyDeleteTag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get denyDeleteTagInput() {
        return this._denyDeleteTag;
    }
    get fileNameRegex() {
        return this.getStringAttribute('file_name_regex');
    }
    set fileNameRegex(value) {
        this._fileNameRegex = value;
    }
    resetFileNameRegex() {
        this._fileNameRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fileNameRegexInput() {
        return this._fileNameRegex;
    }
    get maxFileSize() {
        return this.getNumberAttribute('max_file_size');
    }
    set maxFileSize(value) {
        this._maxFileSize = value;
    }
    resetMaxFileSize() {
        this._maxFileSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxFileSizeInput() {
        return this._maxFileSize;
    }
    get memberCheck() {
        return this.getBooleanAttribute('member_check');
    }
    set memberCheck(value) {
        this._memberCheck = value;
    }
    resetMemberCheck() {
        this._memberCheck = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memberCheckInput() {
        return this._memberCheck;
    }
    get preventSecrets() {
        return this.getBooleanAttribute('prevent_secrets');
    }
    set preventSecrets(value) {
        this._preventSecrets = value;
    }
    resetPreventSecrets() {
        this._preventSecrets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preventSecretsInput() {
        return this._preventSecrets;
    }
    get rejectUnsignedCommits() {
        return this.getBooleanAttribute('reject_unsigned_commits');
    }
    set rejectUnsignedCommits(value) {
        this._rejectUnsignedCommits = value;
    }
    resetRejectUnsignedCommits() {
        this._rejectUnsignedCommits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rejectUnsignedCommitsInput() {
        return this._rejectUnsignedCommits;
    }
}
exports.ProjectPushRulesOutputReference = ProjectPushRulesOutputReference;
_b = JSII_RTTI_SYMBOL_1;
ProjectPushRulesOutputReference[_b] = { fqn: "@cdktf/provider-gitlab.project.ProjectPushRulesOutputReference", version: "6.0.2" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project gitlab_project}
*/
class Project extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project gitlab_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_project',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '15.10.0',
                providerVersionConstraint: '~> 15.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // container_expiration_policy - computed: false, optional: true, required: false
        this._containerExpirationPolicy = new ProjectContainerExpirationPolicyOutputReference(this, "container_expiration_policy");
        // push_rules - computed: false, optional: true, required: false
        this._pushRules = new ProjectPushRulesOutputReference(this, "push_rules");
        this._allowMergeOnSkippedPipeline = config.allowMergeOnSkippedPipeline;
        this._analyticsAccessLevel = config.analyticsAccessLevel;
        this._approvalsBeforeMerge = config.approvalsBeforeMerge;
        this._archiveOnDestroy = config.archiveOnDestroy;
        this._archived = config.archived;
        this._autoCancelPendingPipelines = config.autoCancelPendingPipelines;
        this._autoDevopsDeployStrategy = config.autoDevopsDeployStrategy;
        this._autoDevopsEnabled = config.autoDevopsEnabled;
        this._autocloseReferencedIssues = config.autocloseReferencedIssues;
        this._avatar = config.avatar;
        this._avatarHash = config.avatarHash;
        this._buildCoverageRegex = config.buildCoverageRegex;
        this._buildGitStrategy = config.buildGitStrategy;
        this._buildTimeout = config.buildTimeout;
        this._buildsAccessLevel = config.buildsAccessLevel;
        this._ciConfigPath = config.ciConfigPath;
        this._ciDefaultGitDepth = config.ciDefaultGitDepth;
        this._ciForwardDeploymentEnabled = config.ciForwardDeploymentEnabled;
        this._ciSeparatedCaches = config.ciSeparatedCaches;
        this._containerRegistryAccessLevel = config.containerRegistryAccessLevel;
        this._containerRegistryEnabled = config.containerRegistryEnabled;
        this._defaultBranch = config.defaultBranch;
        this._description = config.description;
        this._emailsDisabled = config.emailsDisabled;
        this._environmentsAccessLevel = config.environmentsAccessLevel;
        this._externalAuthorizationClassificationLabel = config.externalAuthorizationClassificationLabel;
        this._featureFlagsAccessLevel = config.featureFlagsAccessLevel;
        this._forkedFromProjectId = config.forkedFromProjectId;
        this._forkingAccessLevel = config.forkingAccessLevel;
        this._groupWithProjectTemplatesId = config.groupWithProjectTemplatesId;
        this._id = config.id;
        this._importUrl = config.importUrl;
        this._importUrlPassword = config.importUrlPassword;
        this._importUrlUsername = config.importUrlUsername;
        this._infrastructureAccessLevel = config.infrastructureAccessLevel;
        this._initializeWithReadme = config.initializeWithReadme;
        this._issuesAccessLevel = config.issuesAccessLevel;
        this._issuesEnabled = config.issuesEnabled;
        this._issuesTemplate = config.issuesTemplate;
        this._lfsEnabled = config.lfsEnabled;
        this._mergeCommitTemplate = config.mergeCommitTemplate;
        this._mergeMethod = config.mergeMethod;
        this._mergePipelinesEnabled = config.mergePipelinesEnabled;
        this._mergeRequestsAccessLevel = config.mergeRequestsAccessLevel;
        this._mergeRequestsEnabled = config.mergeRequestsEnabled;
        this._mergeRequestsTemplate = config.mergeRequestsTemplate;
        this._mergeTrainsEnabled = config.mergeTrainsEnabled;
        this._mirror = config.mirror;
        this._mirrorOverwritesDivergedBranches = config.mirrorOverwritesDivergedBranches;
        this._mirrorTriggerBuilds = config.mirrorTriggerBuilds;
        this._monitorAccessLevel = config.monitorAccessLevel;
        this._mrDefaultTargetSelf = config.mrDefaultTargetSelf;
        this._name = config.name;
        this._namespaceId = config.namespaceId;
        this._onlyAllowMergeIfAllDiscussionsAreResolved = config.onlyAllowMergeIfAllDiscussionsAreResolved;
        this._onlyAllowMergeIfPipelineSucceeds = config.onlyAllowMergeIfPipelineSucceeds;
        this._onlyMirrorProtectedBranches = config.onlyMirrorProtectedBranches;
        this._operationsAccessLevel = config.operationsAccessLevel;
        this._packagesEnabled = config.packagesEnabled;
        this._pagesAccessLevel = config.pagesAccessLevel;
        this._path = config.path;
        this._pipelinesEnabled = config.pipelinesEnabled;
        this._printingMergeRequestLinkEnabled = config.printingMergeRequestLinkEnabled;
        this._publicBuilds = config.publicBuilds;
        this._releasesAccessLevel = config.releasesAccessLevel;
        this._removeSourceBranchAfterMerge = config.removeSourceBranchAfterMerge;
        this._repositoryAccessLevel = config.repositoryAccessLevel;
        this._repositoryStorage = config.repositoryStorage;
        this._requestAccessEnabled = config.requestAccessEnabled;
        this._requirementsAccessLevel = config.requirementsAccessLevel;
        this._resolveOutdatedDiffDiscussions = config.resolveOutdatedDiffDiscussions;
        this._restrictUserDefinedVariables = config.restrictUserDefinedVariables;
        this._securityAndComplianceAccessLevel = config.securityAndComplianceAccessLevel;
        this._sharedRunnersEnabled = config.sharedRunnersEnabled;
        this._skipWaitForDefaultBranchProtection = config.skipWaitForDefaultBranchProtection;
        this._snippetsAccessLevel = config.snippetsAccessLevel;
        this._snippetsEnabled = config.snippetsEnabled;
        this._squashCommitTemplate = config.squashCommitTemplate;
        this._squashOption = config.squashOption;
        this._suggestionCommitMessage = config.suggestionCommitMessage;
        this._tags = config.tags;
        this._templateName = config.templateName;
        this._templateProjectId = config.templateProjectId;
        this._topics = config.topics;
        this._useCustomTemplate = config.useCustomTemplate;
        this._visibilityLevel = config.visibilityLevel;
        this._wikiAccessLevel = config.wikiAccessLevel;
        this._wikiEnabled = config.wikiEnabled;
        this._containerExpirationPolicy.internalValue = config.containerExpirationPolicy;
        this._pushRules.internalValue = config.pushRules;
    }
    get allowMergeOnSkippedPipeline() {
        return this.getBooleanAttribute('allow_merge_on_skipped_pipeline');
    }
    set allowMergeOnSkippedPipeline(value) {
        this._allowMergeOnSkippedPipeline = value;
    }
    resetAllowMergeOnSkippedPipeline() {
        this._allowMergeOnSkippedPipeline = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowMergeOnSkippedPipelineInput() {
        return this._allowMergeOnSkippedPipeline;
    }
    get analyticsAccessLevel() {
        return this.getStringAttribute('analytics_access_level');
    }
    set analyticsAccessLevel(value) {
        this._analyticsAccessLevel = value;
    }
    resetAnalyticsAccessLevel() {
        this._analyticsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get analyticsAccessLevelInput() {
        return this._analyticsAccessLevel;
    }
    get approvalsBeforeMerge() {
        return this.getNumberAttribute('approvals_before_merge');
    }
    set approvalsBeforeMerge(value) {
        this._approvalsBeforeMerge = value;
    }
    resetApprovalsBeforeMerge() {
        this._approvalsBeforeMerge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get approvalsBeforeMergeInput() {
        return this._approvalsBeforeMerge;
    }
    get archiveOnDestroy() {
        return this.getBooleanAttribute('archive_on_destroy');
    }
    set archiveOnDestroy(value) {
        this._archiveOnDestroy = value;
    }
    resetArchiveOnDestroy() {
        this._archiveOnDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archiveOnDestroyInput() {
        return this._archiveOnDestroy;
    }
    get archived() {
        return this.getBooleanAttribute('archived');
    }
    set archived(value) {
        this._archived = value;
    }
    resetArchived() {
        this._archived = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archivedInput() {
        return this._archived;
    }
    get autoCancelPendingPipelines() {
        return this.getStringAttribute('auto_cancel_pending_pipelines');
    }
    set autoCancelPendingPipelines(value) {
        this._autoCancelPendingPipelines = value;
    }
    resetAutoCancelPendingPipelines() {
        this._autoCancelPendingPipelines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoCancelPendingPipelinesInput() {
        return this._autoCancelPendingPipelines;
    }
    get autoDevopsDeployStrategy() {
        return this.getStringAttribute('auto_devops_deploy_strategy');
    }
    set autoDevopsDeployStrategy(value) {
        this._autoDevopsDeployStrategy = value;
    }
    resetAutoDevopsDeployStrategy() {
        this._autoDevopsDeployStrategy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsDeployStrategyInput() {
        return this._autoDevopsDeployStrategy;
    }
    get autoDevopsEnabled() {
        return this.getBooleanAttribute('auto_devops_enabled');
    }
    set autoDevopsEnabled(value) {
        this._autoDevopsEnabled = value;
    }
    resetAutoDevopsEnabled() {
        this._autoDevopsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsEnabledInput() {
        return this._autoDevopsEnabled;
    }
    get autocloseReferencedIssues() {
        return this.getBooleanAttribute('autoclose_referenced_issues');
    }
    set autocloseReferencedIssues(value) {
        this._autocloseReferencedIssues = value;
    }
    resetAutocloseReferencedIssues() {
        this._autocloseReferencedIssues = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autocloseReferencedIssuesInput() {
        return this._autocloseReferencedIssues;
    }
    get avatar() {
        return this.getStringAttribute('avatar');
    }
    set avatar(value) {
        this._avatar = value;
    }
    resetAvatar() {
        this._avatar = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get avatarInput() {
        return this._avatar;
    }
    get avatarHash() {
        return this.getStringAttribute('avatar_hash');
    }
    set avatarHash(value) {
        this._avatarHash = value;
    }
    resetAvatarHash() {
        this._avatarHash = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get avatarHashInput() {
        return this._avatarHash;
    }
    // avatar_url - computed: true, optional: false, required: false
    get avatarUrl() {
        return this.getStringAttribute('avatar_url');
    }
    get buildCoverageRegex() {
        return this.getStringAttribute('build_coverage_regex');
    }
    set buildCoverageRegex(value) {
        this._buildCoverageRegex = value;
    }
    resetBuildCoverageRegex() {
        this._buildCoverageRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildCoverageRegexInput() {
        return this._buildCoverageRegex;
    }
    get buildGitStrategy() {
        return this.getStringAttribute('build_git_strategy');
    }
    set buildGitStrategy(value) {
        this._buildGitStrategy = value;
    }
    resetBuildGitStrategy() {
        this._buildGitStrategy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildGitStrategyInput() {
        return this._buildGitStrategy;
    }
    get buildTimeout() {
        return this.getNumberAttribute('build_timeout');
    }
    set buildTimeout(value) {
        this._buildTimeout = value;
    }
    resetBuildTimeout() {
        this._buildTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildTimeoutInput() {
        return this._buildTimeout;
    }
    get buildsAccessLevel() {
        return this.getStringAttribute('builds_access_level');
    }
    set buildsAccessLevel(value) {
        this._buildsAccessLevel = value;
    }
    resetBuildsAccessLevel() {
        this._buildsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildsAccessLevelInput() {
        return this._buildsAccessLevel;
    }
    get ciConfigPath() {
        return this.getStringAttribute('ci_config_path');
    }
    set ciConfigPath(value) {
        this._ciConfigPath = value;
    }
    resetCiConfigPath() {
        this._ciConfigPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciConfigPathInput() {
        return this._ciConfigPath;
    }
    get ciDefaultGitDepth() {
        return this.getNumberAttribute('ci_default_git_depth');
    }
    set ciDefaultGitDepth(value) {
        this._ciDefaultGitDepth = value;
    }
    resetCiDefaultGitDepth() {
        this._ciDefaultGitDepth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciDefaultGitDepthInput() {
        return this._ciDefaultGitDepth;
    }
    get ciForwardDeploymentEnabled() {
        return this.getBooleanAttribute('ci_forward_deployment_enabled');
    }
    set ciForwardDeploymentEnabled(value) {
        this._ciForwardDeploymentEnabled = value;
    }
    resetCiForwardDeploymentEnabled() {
        this._ciForwardDeploymentEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciForwardDeploymentEnabledInput() {
        return this._ciForwardDeploymentEnabled;
    }
    get ciSeparatedCaches() {
        return this.getBooleanAttribute('ci_separated_caches');
    }
    set ciSeparatedCaches(value) {
        this._ciSeparatedCaches = value;
    }
    resetCiSeparatedCaches() {
        this._ciSeparatedCaches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciSeparatedCachesInput() {
        return this._ciSeparatedCaches;
    }
    get containerRegistryAccessLevel() {
        return this.getStringAttribute('container_registry_access_level');
    }
    set containerRegistryAccessLevel(value) {
        this._containerRegistryAccessLevel = value;
    }
    resetContainerRegistryAccessLevel() {
        this._containerRegistryAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryAccessLevelInput() {
        return this._containerRegistryAccessLevel;
    }
    get containerRegistryEnabled() {
        return this.getBooleanAttribute('container_registry_enabled');
    }
    set containerRegistryEnabled(value) {
        this._containerRegistryEnabled = value;
    }
    resetContainerRegistryEnabled() {
        this._containerRegistryEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryEnabledInput() {
        return this._containerRegistryEnabled;
    }
    get defaultBranch() {
        return this.getStringAttribute('default_branch');
    }
    set defaultBranch(value) {
        this._defaultBranch = value;
    }
    resetDefaultBranch() {
        this._defaultBranch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultBranchInput() {
        return this._defaultBranch;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get emailsDisabled() {
        return this.getBooleanAttribute('emails_disabled');
    }
    set emailsDisabled(value) {
        this._emailsDisabled = value;
    }
    resetEmailsDisabled() {
        this._emailsDisabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailsDisabledInput() {
        return this._emailsDisabled;
    }
    get environmentsAccessLevel() {
        return this.getStringAttribute('environments_access_level');
    }
    set environmentsAccessLevel(value) {
        this._environmentsAccessLevel = value;
    }
    resetEnvironmentsAccessLevel() {
        this._environmentsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get environmentsAccessLevelInput() {
        return this._environmentsAccessLevel;
    }
    get externalAuthorizationClassificationLabel() {
        return this.getStringAttribute('external_authorization_classification_label');
    }
    set externalAuthorizationClassificationLabel(value) {
        this._externalAuthorizationClassificationLabel = value;
    }
    resetExternalAuthorizationClassificationLabel() {
        this._externalAuthorizationClassificationLabel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthorizationClassificationLabelInput() {
        return this._externalAuthorizationClassificationLabel;
    }
    get featureFlagsAccessLevel() {
        return this.getStringAttribute('feature_flags_access_level');
    }
    set featureFlagsAccessLevel(value) {
        this._featureFlagsAccessLevel = value;
    }
    resetFeatureFlagsAccessLevel() {
        this._featureFlagsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get featureFlagsAccessLevelInput() {
        return this._featureFlagsAccessLevel;
    }
    get forkedFromProjectId() {
        return this.getNumberAttribute('forked_from_project_id');
    }
    set forkedFromProjectId(value) {
        this._forkedFromProjectId = value;
    }
    resetForkedFromProjectId() {
        this._forkedFromProjectId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forkedFromProjectIdInput() {
        return this._forkedFromProjectId;
    }
    get forkingAccessLevel() {
        return this.getStringAttribute('forking_access_level');
    }
    set forkingAccessLevel(value) {
        this._forkingAccessLevel = value;
    }
    resetForkingAccessLevel() {
        this._forkingAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forkingAccessLevelInput() {
        return this._forkingAccessLevel;
    }
    get groupWithProjectTemplatesId() {
        return this.getNumberAttribute('group_with_project_templates_id');
    }
    set groupWithProjectTemplatesId(value) {
        this._groupWithProjectTemplatesId = value;
    }
    resetGroupWithProjectTemplatesId() {
        this._groupWithProjectTemplatesId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupWithProjectTemplatesIdInput() {
        return this._groupWithProjectTemplatesId;
    }
    // http_url_to_repo - computed: true, optional: false, required: false
    get httpUrlToRepo() {
        return this.getStringAttribute('http_url_to_repo');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get importUrl() {
        return this.getStringAttribute('import_url');
    }
    set importUrl(value) {
        this._importUrl = value;
    }
    resetImportUrl() {
        this._importUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get importUrlInput() {
        return this._importUrl;
    }
    get importUrlPassword() {
        return this.getStringAttribute('import_url_password');
    }
    set importUrlPassword(value) {
        this._importUrlPassword = value;
    }
    resetImportUrlPassword() {
        this._importUrlPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get importUrlPasswordInput() {
        return this._importUrlPassword;
    }
    get importUrlUsername() {
        return this.getStringAttribute('import_url_username');
    }
    set importUrlUsername(value) {
        this._importUrlUsername = value;
    }
    resetImportUrlUsername() {
        this._importUrlUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get importUrlUsernameInput() {
        return this._importUrlUsername;
    }
    get infrastructureAccessLevel() {
        return this.getStringAttribute('infrastructure_access_level');
    }
    set infrastructureAccessLevel(value) {
        this._infrastructureAccessLevel = value;
    }
    resetInfrastructureAccessLevel() {
        this._infrastructureAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get infrastructureAccessLevelInput() {
        return this._infrastructureAccessLevel;
    }
    get initializeWithReadme() {
        return this.getBooleanAttribute('initialize_with_readme');
    }
    set initializeWithReadme(value) {
        this._initializeWithReadme = value;
    }
    resetInitializeWithReadme() {
        this._initializeWithReadme = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get initializeWithReadmeInput() {
        return this._initializeWithReadme;
    }
    get issuesAccessLevel() {
        return this.getStringAttribute('issues_access_level');
    }
    set issuesAccessLevel(value) {
        this._issuesAccessLevel = value;
    }
    resetIssuesAccessLevel() {
        this._issuesAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesAccessLevelInput() {
        return this._issuesAccessLevel;
    }
    get issuesEnabled() {
        return this.getBooleanAttribute('issues_enabled');
    }
    set issuesEnabled(value) {
        this._issuesEnabled = value;
    }
    resetIssuesEnabled() {
        this._issuesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesEnabledInput() {
        return this._issuesEnabled;
    }
    get issuesTemplate() {
        return this.getStringAttribute('issues_template');
    }
    set issuesTemplate(value) {
        this._issuesTemplate = value;
    }
    resetIssuesTemplate() {
        this._issuesTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesTemplateInput() {
        return this._issuesTemplate;
    }
    get lfsEnabled() {
        return this.getBooleanAttribute('lfs_enabled');
    }
    set lfsEnabled(value) {
        this._lfsEnabled = value;
    }
    resetLfsEnabled() {
        this._lfsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lfsEnabledInput() {
        return this._lfsEnabled;
    }
    get mergeCommitTemplate() {
        return this.getStringAttribute('merge_commit_template');
    }
    set mergeCommitTemplate(value) {
        this._mergeCommitTemplate = value;
    }
    resetMergeCommitTemplate() {
        this._mergeCommitTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeCommitTemplateInput() {
        return this._mergeCommitTemplate;
    }
    get mergeMethod() {
        return this.getStringAttribute('merge_method');
    }
    set mergeMethod(value) {
        this._mergeMethod = value;
    }
    resetMergeMethod() {
        this._mergeMethod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeMethodInput() {
        return this._mergeMethod;
    }
    get mergePipelinesEnabled() {
        return this.getBooleanAttribute('merge_pipelines_enabled');
    }
    set mergePipelinesEnabled(value) {
        this._mergePipelinesEnabled = value;
    }
    resetMergePipelinesEnabled() {
        this._mergePipelinesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergePipelinesEnabledInput() {
        return this._mergePipelinesEnabled;
    }
    get mergeRequestsAccessLevel() {
        return this.getStringAttribute('merge_requests_access_level');
    }
    set mergeRequestsAccessLevel(value) {
        this._mergeRequestsAccessLevel = value;
    }
    resetMergeRequestsAccessLevel() {
        this._mergeRequestsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsAccessLevelInput() {
        return this._mergeRequestsAccessLevel;
    }
    get mergeRequestsEnabled() {
        return this.getBooleanAttribute('merge_requests_enabled');
    }
    set mergeRequestsEnabled(value) {
        this._mergeRequestsEnabled = value;
    }
    resetMergeRequestsEnabled() {
        this._mergeRequestsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsEnabledInput() {
        return this._mergeRequestsEnabled;
    }
    get mergeRequestsTemplate() {
        return this.getStringAttribute('merge_requests_template');
    }
    set mergeRequestsTemplate(value) {
        this._mergeRequestsTemplate = value;
    }
    resetMergeRequestsTemplate() {
        this._mergeRequestsTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsTemplateInput() {
        return this._mergeRequestsTemplate;
    }
    get mergeTrainsEnabled() {
        return this.getBooleanAttribute('merge_trains_enabled');
    }
    set mergeTrainsEnabled(value) {
        this._mergeTrainsEnabled = value;
    }
    resetMergeTrainsEnabled() {
        this._mergeTrainsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeTrainsEnabledInput() {
        return this._mergeTrainsEnabled;
    }
    get mirror() {
        return this.getBooleanAttribute('mirror');
    }
    set mirror(value) {
        this._mirror = value;
    }
    resetMirror() {
        this._mirror = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorInput() {
        return this._mirror;
    }
    get mirrorOverwritesDivergedBranches() {
        return this.getBooleanAttribute('mirror_overwrites_diverged_branches');
    }
    set mirrorOverwritesDivergedBranches(value) {
        this._mirrorOverwritesDivergedBranches = value;
    }
    resetMirrorOverwritesDivergedBranches() {
        this._mirrorOverwritesDivergedBranches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorOverwritesDivergedBranchesInput() {
        return this._mirrorOverwritesDivergedBranches;
    }
    get mirrorTriggerBuilds() {
        return this.getBooleanAttribute('mirror_trigger_builds');
    }
    set mirrorTriggerBuilds(value) {
        this._mirrorTriggerBuilds = value;
    }
    resetMirrorTriggerBuilds() {
        this._mirrorTriggerBuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorTriggerBuildsInput() {
        return this._mirrorTriggerBuilds;
    }
    get monitorAccessLevel() {
        return this.getStringAttribute('monitor_access_level');
    }
    set monitorAccessLevel(value) {
        this._monitorAccessLevel = value;
    }
    resetMonitorAccessLevel() {
        this._monitorAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get monitorAccessLevelInput() {
        return this._monitorAccessLevel;
    }
    get mrDefaultTargetSelf() {
        return this.getBooleanAttribute('mr_default_target_self');
    }
    set mrDefaultTargetSelf(value) {
        this._mrDefaultTargetSelf = value;
    }
    resetMrDefaultTargetSelf() {
        this._mrDefaultTargetSelf = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mrDefaultTargetSelfInput() {
        return this._mrDefaultTargetSelf;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get namespaceId() {
        return this.getNumberAttribute('namespace_id');
    }
    set namespaceId(value) {
        this._namespaceId = value;
    }
    resetNamespaceId() {
        this._namespaceId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceIdInput() {
        return this._namespaceId;
    }
    get onlyAllowMergeIfAllDiscussionsAreResolved() {
        return this.getBooleanAttribute('only_allow_merge_if_all_discussions_are_resolved');
    }
    set onlyAllowMergeIfAllDiscussionsAreResolved(value) {
        this._onlyAllowMergeIfAllDiscussionsAreResolved = value;
    }
    resetOnlyAllowMergeIfAllDiscussionsAreResolved() {
        this._onlyAllowMergeIfAllDiscussionsAreResolved = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyAllowMergeIfAllDiscussionsAreResolvedInput() {
        return this._onlyAllowMergeIfAllDiscussionsAreResolved;
    }
    get onlyAllowMergeIfPipelineSucceeds() {
        return this.getBooleanAttribute('only_allow_merge_if_pipeline_succeeds');
    }
    set onlyAllowMergeIfPipelineSucceeds(value) {
        this._onlyAllowMergeIfPipelineSucceeds = value;
    }
    resetOnlyAllowMergeIfPipelineSucceeds() {
        this._onlyAllowMergeIfPipelineSucceeds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyAllowMergeIfPipelineSucceedsInput() {
        return this._onlyAllowMergeIfPipelineSucceeds;
    }
    get onlyMirrorProtectedBranches() {
        return this.getBooleanAttribute('only_mirror_protected_branches');
    }
    set onlyMirrorProtectedBranches(value) {
        this._onlyMirrorProtectedBranches = value;
    }
    resetOnlyMirrorProtectedBranches() {
        this._onlyMirrorProtectedBranches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyMirrorProtectedBranchesInput() {
        return this._onlyMirrorProtectedBranches;
    }
    get operationsAccessLevel() {
        return this.getStringAttribute('operations_access_level');
    }
    set operationsAccessLevel(value) {
        this._operationsAccessLevel = value;
    }
    resetOperationsAccessLevel() {
        this._operationsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationsAccessLevelInput() {
        return this._operationsAccessLevel;
    }
    get packagesEnabled() {
        return this.getBooleanAttribute('packages_enabled');
    }
    set packagesEnabled(value) {
        this._packagesEnabled = value;
    }
    resetPackagesEnabled() {
        this._packagesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get packagesEnabledInput() {
        return this._packagesEnabled;
    }
    get pagesAccessLevel() {
        return this.getStringAttribute('pages_access_level');
    }
    set pagesAccessLevel(value) {
        this._pagesAccessLevel = value;
    }
    resetPagesAccessLevel() {
        this._pagesAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pagesAccessLevelInput() {
        return this._pagesAccessLevel;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    resetPath() {
        this._path = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    // path_with_namespace - computed: true, optional: false, required: false
    get pathWithNamespace() {
        return this.getStringAttribute('path_with_namespace');
    }
    get pipelinesEnabled() {
        return this.getBooleanAttribute('pipelines_enabled');
    }
    set pipelinesEnabled(value) {
        this._pipelinesEnabled = value;
    }
    resetPipelinesEnabled() {
        this._pipelinesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pipelinesEnabledInput() {
        return this._pipelinesEnabled;
    }
    get printingMergeRequestLinkEnabled() {
        return this.getBooleanAttribute('printing_merge_request_link_enabled');
    }
    set printingMergeRequestLinkEnabled(value) {
        this._printingMergeRequestLinkEnabled = value;
    }
    resetPrintingMergeRequestLinkEnabled() {
        this._printingMergeRequestLinkEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get printingMergeRequestLinkEnabledInput() {
        return this._printingMergeRequestLinkEnabled;
    }
    get publicBuilds() {
        return this.getBooleanAttribute('public_builds');
    }
    set publicBuilds(value) {
        this._publicBuilds = value;
    }
    resetPublicBuilds() {
        this._publicBuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicBuildsInput() {
        return this._publicBuilds;
    }
    get releasesAccessLevel() {
        return this.getStringAttribute('releases_access_level');
    }
    set releasesAccessLevel(value) {
        this._releasesAccessLevel = value;
    }
    resetReleasesAccessLevel() {
        this._releasesAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get releasesAccessLevelInput() {
        return this._releasesAccessLevel;
    }
    get removeSourceBranchAfterMerge() {
        return this.getBooleanAttribute('remove_source_branch_after_merge');
    }
    set removeSourceBranchAfterMerge(value) {
        this._removeSourceBranchAfterMerge = value;
    }
    resetRemoveSourceBranchAfterMerge() {
        this._removeSourceBranchAfterMerge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get removeSourceBranchAfterMergeInput() {
        return this._removeSourceBranchAfterMerge;
    }
    get repositoryAccessLevel() {
        return this.getStringAttribute('repository_access_level');
    }
    set repositoryAccessLevel(value) {
        this._repositoryAccessLevel = value;
    }
    resetRepositoryAccessLevel() {
        this._repositoryAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryAccessLevelInput() {
        return this._repositoryAccessLevel;
    }
    get repositoryStorage() {
        return this.getStringAttribute('repository_storage');
    }
    set repositoryStorage(value) {
        this._repositoryStorage = value;
    }
    resetRepositoryStorage() {
        this._repositoryStorage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryStorageInput() {
        return this._repositoryStorage;
    }
    get requestAccessEnabled() {
        return this.getBooleanAttribute('request_access_enabled');
    }
    set requestAccessEnabled(value) {
        this._requestAccessEnabled = value;
    }
    resetRequestAccessEnabled() {
        this._requestAccessEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestAccessEnabledInput() {
        return this._requestAccessEnabled;
    }
    get requirementsAccessLevel() {
        return this.getStringAttribute('requirements_access_level');
    }
    set requirementsAccessLevel(value) {
        this._requirementsAccessLevel = value;
    }
    resetRequirementsAccessLevel() {
        this._requirementsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requirementsAccessLevelInput() {
        return this._requirementsAccessLevel;
    }
    get resolveOutdatedDiffDiscussions() {
        return this.getBooleanAttribute('resolve_outdated_diff_discussions');
    }
    set resolveOutdatedDiffDiscussions(value) {
        this._resolveOutdatedDiffDiscussions = value;
    }
    resetResolveOutdatedDiffDiscussions() {
        this._resolveOutdatedDiffDiscussions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resolveOutdatedDiffDiscussionsInput() {
        return this._resolveOutdatedDiffDiscussions;
    }
    get restrictUserDefinedVariables() {
        return this.getBooleanAttribute('restrict_user_defined_variables');
    }
    set restrictUserDefinedVariables(value) {
        this._restrictUserDefinedVariables = value;
    }
    resetRestrictUserDefinedVariables() {
        this._restrictUserDefinedVariables = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get restrictUserDefinedVariablesInput() {
        return this._restrictUserDefinedVariables;
    }
    // runners_token - computed: true, optional: false, required: false
    get runnersToken() {
        return this.getStringAttribute('runners_token');
    }
    get securityAndComplianceAccessLevel() {
        return this.getStringAttribute('security_and_compliance_access_level');
    }
    set securityAndComplianceAccessLevel(value) {
        this._securityAndComplianceAccessLevel = value;
    }
    resetSecurityAndComplianceAccessLevel() {
        this._securityAndComplianceAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityAndComplianceAccessLevelInput() {
        return this._securityAndComplianceAccessLevel;
    }
    get sharedRunnersEnabled() {
        return this.getBooleanAttribute('shared_runners_enabled');
    }
    set sharedRunnersEnabled(value) {
        this._sharedRunnersEnabled = value;
    }
    resetSharedRunnersEnabled() {
        this._sharedRunnersEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedRunnersEnabledInput() {
        return this._sharedRunnersEnabled;
    }
    get skipWaitForDefaultBranchProtection() {
        return this.getBooleanAttribute('skip_wait_for_default_branch_protection');
    }
    set skipWaitForDefaultBranchProtection(value) {
        this._skipWaitForDefaultBranchProtection = value;
    }
    resetSkipWaitForDefaultBranchProtection() {
        this._skipWaitForDefaultBranchProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipWaitForDefaultBranchProtectionInput() {
        return this._skipWaitForDefaultBranchProtection;
    }
    get snippetsAccessLevel() {
        return this.getStringAttribute('snippets_access_level');
    }
    set snippetsAccessLevel(value) {
        this._snippetsAccessLevel = value;
    }
    resetSnippetsAccessLevel() {
        this._snippetsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snippetsAccessLevelInput() {
        return this._snippetsAccessLevel;
    }
    get snippetsEnabled() {
        return this.getBooleanAttribute('snippets_enabled');
    }
    set snippetsEnabled(value) {
        this._snippetsEnabled = value;
    }
    resetSnippetsEnabled() {
        this._snippetsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snippetsEnabledInput() {
        return this._snippetsEnabled;
    }
    get squashCommitTemplate() {
        return this.getStringAttribute('squash_commit_template');
    }
    set squashCommitTemplate(value) {
        this._squashCommitTemplate = value;
    }
    resetSquashCommitTemplate() {
        this._squashCommitTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get squashCommitTemplateInput() {
        return this._squashCommitTemplate;
    }
    get squashOption() {
        return this.getStringAttribute('squash_option');
    }
    set squashOption(value) {
        this._squashOption = value;
    }
    resetSquashOption() {
        this._squashOption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get squashOptionInput() {
        return this._squashOption;
    }
    // ssh_url_to_repo - computed: true, optional: false, required: false
    get sshUrlToRepo() {
        return this.getStringAttribute('ssh_url_to_repo');
    }
    get suggestionCommitMessage() {
        return this.getStringAttribute('suggestion_commit_message');
    }
    set suggestionCommitMessage(value) {
        this._suggestionCommitMessage = value;
    }
    resetSuggestionCommitMessage() {
        this._suggestionCommitMessage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suggestionCommitMessageInput() {
        return this._suggestionCommitMessage;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get templateName() {
        return this.getStringAttribute('template_name');
    }
    set templateName(value) {
        this._templateName = value;
    }
    resetTemplateName() {
        this._templateName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get templateNameInput() {
        return this._templateName;
    }
    get templateProjectId() {
        return this.getNumberAttribute('template_project_id');
    }
    set templateProjectId(value) {
        this._templateProjectId = value;
    }
    resetTemplateProjectId() {
        this._templateProjectId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get templateProjectIdInput() {
        return this._templateProjectId;
    }
    get topics() {
        return cdktf.Fn.tolist(this.getListAttribute('topics'));
    }
    set topics(value) {
        this._topics = value;
    }
    resetTopics() {
        this._topics = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get topicsInput() {
        return this._topics;
    }
    get useCustomTemplate() {
        return this.getBooleanAttribute('use_custom_template');
    }
    set useCustomTemplate(value) {
        this._useCustomTemplate = value;
    }
    resetUseCustomTemplate() {
        this._useCustomTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useCustomTemplateInput() {
        return this._useCustomTemplate;
    }
    get visibilityLevel() {
        return this.getStringAttribute('visibility_level');
    }
    set visibilityLevel(value) {
        this._visibilityLevel = value;
    }
    resetVisibilityLevel() {
        this._visibilityLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get visibilityLevelInput() {
        return this._visibilityLevel;
    }
    // web_url - computed: true, optional: false, required: false
    get webUrl() {
        return this.getStringAttribute('web_url');
    }
    get wikiAccessLevel() {
        return this.getStringAttribute('wiki_access_level');
    }
    set wikiAccessLevel(value) {
        this._wikiAccessLevel = value;
    }
    resetWikiAccessLevel() {
        this._wikiAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiAccessLevelInput() {
        return this._wikiAccessLevel;
    }
    get wikiEnabled() {
        return this.getBooleanAttribute('wiki_enabled');
    }
    set wikiEnabled(value) {
        this._wikiEnabled = value;
    }
    resetWikiEnabled() {
        this._wikiEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiEnabledInput() {
        return this._wikiEnabled;
    }
    get containerExpirationPolicy() {
        return this._containerExpirationPolicy;
    }
    putContainerExpirationPolicy(value) {
        this._containerExpirationPolicy.internalValue = value;
    }
    resetContainerExpirationPolicy() {
        this._containerExpirationPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerExpirationPolicyInput() {
        return this._containerExpirationPolicy.internalValue;
    }
    get pushRules() {
        return this._pushRules;
    }
    putPushRules(value) {
        this._pushRules.internalValue = value;
    }
    resetPushRules() {
        this._pushRules.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushRulesInput() {
        return this._pushRules.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_merge_on_skipped_pipeline: cdktf.booleanToTerraform(this._allowMergeOnSkippedPipeline),
            analytics_access_level: cdktf.stringToTerraform(this._analyticsAccessLevel),
            approvals_before_merge: cdktf.numberToTerraform(this._approvalsBeforeMerge),
            archive_on_destroy: cdktf.booleanToTerraform(this._archiveOnDestroy),
            archived: cdktf.booleanToTerraform(this._archived),
            auto_cancel_pending_pipelines: cdktf.stringToTerraform(this._autoCancelPendingPipelines),
            auto_devops_deploy_strategy: cdktf.stringToTerraform(this._autoDevopsDeployStrategy),
            auto_devops_enabled: cdktf.booleanToTerraform(this._autoDevopsEnabled),
            autoclose_referenced_issues: cdktf.booleanToTerraform(this._autocloseReferencedIssues),
            avatar: cdktf.stringToTerraform(this._avatar),
            avatar_hash: cdktf.stringToTerraform(this._avatarHash),
            build_coverage_regex: cdktf.stringToTerraform(this._buildCoverageRegex),
            build_git_strategy: cdktf.stringToTerraform(this._buildGitStrategy),
            build_timeout: cdktf.numberToTerraform(this._buildTimeout),
            builds_access_level: cdktf.stringToTerraform(this._buildsAccessLevel),
            ci_config_path: cdktf.stringToTerraform(this._ciConfigPath),
            ci_default_git_depth: cdktf.numberToTerraform(this._ciDefaultGitDepth),
            ci_forward_deployment_enabled: cdktf.booleanToTerraform(this._ciForwardDeploymentEnabled),
            ci_separated_caches: cdktf.booleanToTerraform(this._ciSeparatedCaches),
            container_registry_access_level: cdktf.stringToTerraform(this._containerRegistryAccessLevel),
            container_registry_enabled: cdktf.booleanToTerraform(this._containerRegistryEnabled),
            default_branch: cdktf.stringToTerraform(this._defaultBranch),
            description: cdktf.stringToTerraform(this._description),
            emails_disabled: cdktf.booleanToTerraform(this._emailsDisabled),
            environments_access_level: cdktf.stringToTerraform(this._environmentsAccessLevel),
            external_authorization_classification_label: cdktf.stringToTerraform(this._externalAuthorizationClassificationLabel),
            feature_flags_access_level: cdktf.stringToTerraform(this._featureFlagsAccessLevel),
            forked_from_project_id: cdktf.numberToTerraform(this._forkedFromProjectId),
            forking_access_level: cdktf.stringToTerraform(this._forkingAccessLevel),
            group_with_project_templates_id: cdktf.numberToTerraform(this._groupWithProjectTemplatesId),
            id: cdktf.stringToTerraform(this._id),
            import_url: cdktf.stringToTerraform(this._importUrl),
            import_url_password: cdktf.stringToTerraform(this._importUrlPassword),
            import_url_username: cdktf.stringToTerraform(this._importUrlUsername),
            infrastructure_access_level: cdktf.stringToTerraform(this._infrastructureAccessLevel),
            initialize_with_readme: cdktf.booleanToTerraform(this._initializeWithReadme),
            issues_access_level: cdktf.stringToTerraform(this._issuesAccessLevel),
            issues_enabled: cdktf.booleanToTerraform(this._issuesEnabled),
            issues_template: cdktf.stringToTerraform(this._issuesTemplate),
            lfs_enabled: cdktf.booleanToTerraform(this._lfsEnabled),
            merge_commit_template: cdktf.stringToTerraform(this._mergeCommitTemplate),
            merge_method: cdktf.stringToTerraform(this._mergeMethod),
            merge_pipelines_enabled: cdktf.booleanToTerraform(this._mergePipelinesEnabled),
            merge_requests_access_level: cdktf.stringToTerraform(this._mergeRequestsAccessLevel),
            merge_requests_enabled: cdktf.booleanToTerraform(this._mergeRequestsEnabled),
            merge_requests_template: cdktf.stringToTerraform(this._mergeRequestsTemplate),
            merge_trains_enabled: cdktf.booleanToTerraform(this._mergeTrainsEnabled),
            mirror: cdktf.booleanToTerraform(this._mirror),
            mirror_overwrites_diverged_branches: cdktf.booleanToTerraform(this._mirrorOverwritesDivergedBranches),
            mirror_trigger_builds: cdktf.booleanToTerraform(this._mirrorTriggerBuilds),
            monitor_access_level: cdktf.stringToTerraform(this._monitorAccessLevel),
            mr_default_target_self: cdktf.booleanToTerraform(this._mrDefaultTargetSelf),
            name: cdktf.stringToTerraform(this._name),
            namespace_id: cdktf.numberToTerraform(this._namespaceId),
            only_allow_merge_if_all_discussions_are_resolved: cdktf.booleanToTerraform(this._onlyAllowMergeIfAllDiscussionsAreResolved),
            only_allow_merge_if_pipeline_succeeds: cdktf.booleanToTerraform(this._onlyAllowMergeIfPipelineSucceeds),
            only_mirror_protected_branches: cdktf.booleanToTerraform(this._onlyMirrorProtectedBranches),
            operations_access_level: cdktf.stringToTerraform(this._operationsAccessLevel),
            packages_enabled: cdktf.booleanToTerraform(this._packagesEnabled),
            pages_access_level: cdktf.stringToTerraform(this._pagesAccessLevel),
            path: cdktf.stringToTerraform(this._path),
            pipelines_enabled: cdktf.booleanToTerraform(this._pipelinesEnabled),
            printing_merge_request_link_enabled: cdktf.booleanToTerraform(this._printingMergeRequestLinkEnabled),
            public_builds: cdktf.booleanToTerraform(this._publicBuilds),
            releases_access_level: cdktf.stringToTerraform(this._releasesAccessLevel),
            remove_source_branch_after_merge: cdktf.booleanToTerraform(this._removeSourceBranchAfterMerge),
            repository_access_level: cdktf.stringToTerraform(this._repositoryAccessLevel),
            repository_storage: cdktf.stringToTerraform(this._repositoryStorage),
            request_access_enabled: cdktf.booleanToTerraform(this._requestAccessEnabled),
            requirements_access_level: cdktf.stringToTerraform(this._requirementsAccessLevel),
            resolve_outdated_diff_discussions: cdktf.booleanToTerraform(this._resolveOutdatedDiffDiscussions),
            restrict_user_defined_variables: cdktf.booleanToTerraform(this._restrictUserDefinedVariables),
            security_and_compliance_access_level: cdktf.stringToTerraform(this._securityAndComplianceAccessLevel),
            shared_runners_enabled: cdktf.booleanToTerraform(this._sharedRunnersEnabled),
            skip_wait_for_default_branch_protection: cdktf.booleanToTerraform(this._skipWaitForDefaultBranchProtection),
            snippets_access_level: cdktf.stringToTerraform(this._snippetsAccessLevel),
            snippets_enabled: cdktf.booleanToTerraform(this._snippetsEnabled),
            squash_commit_template: cdktf.stringToTerraform(this._squashCommitTemplate),
            squash_option: cdktf.stringToTerraform(this._squashOption),
            suggestion_commit_message: cdktf.stringToTerraform(this._suggestionCommitMessage),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            template_name: cdktf.stringToTerraform(this._templateName),
            template_project_id: cdktf.numberToTerraform(this._templateProjectId),
            topics: cdktf.listMapper(cdktf.stringToTerraform, false)(this._topics),
            use_custom_template: cdktf.booleanToTerraform(this._useCustomTemplate),
            visibility_level: cdktf.stringToTerraform(this._visibilityLevel),
            wiki_access_level: cdktf.stringToTerraform(this._wikiAccessLevel),
            wiki_enabled: cdktf.booleanToTerraform(this._wikiEnabled),
            container_expiration_policy: projectContainerExpirationPolicyToTerraform(this._containerExpirationPolicy.internalValue),
            push_rules: projectPushRulesToTerraform(this._pushRules.internalValue),
        };
    }
}
exports.Project = Project;
_c = JSII_RTTI_SYMBOL_1;
Project[_c] = { fqn: "@cdktf/provider-gitlab.project.Project", version: "6.0.2" };
// =================
// STATIC PROPERTIES
// =================
Project.tfResourceType = "gitlab_project";
//# sourceMappingURL=data:application/json;base64,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