import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectProtectedEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_protected_environment#environment ProjectProtectedEnvironment#environment}
    */
    readonly environment: string;
    /**
    * The ID or full path of the project which the protected environment is created against.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_protected_environment#project ProjectProtectedEnvironment#project}
    */
    readonly project: string;
    /**
    * The number of approvals required to deploy to this environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_protected_environment#required_approval_count ProjectProtectedEnvironment#required_approval_count}
    */
    readonly requiredApprovalCount?: number;
    /**
    * deploy_access_levels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_protected_environment#deploy_access_levels ProjectProtectedEnvironment#deploy_access_levels}
    */
    readonly deployAccessLevels?: ProjectProtectedEnvironmentDeployAccessLevels[] | cdktf.IResolvable;
}
export interface ProjectProtectedEnvironmentDeployAccessLevels {
    /**
    * Levels of access required to deploy to this protected environment. Valid values are `developer`, `maintainer`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_protected_environment#access_level ProjectProtectedEnvironment#access_level}
    */
    readonly accessLevel?: string;
    /**
    * The ID of the group allowed to deploy to this protected environment. The project must be shared with the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_protected_environment#group_id ProjectProtectedEnvironment#group_id}
    */
    readonly groupId?: number;
    /**
    * The ID of the user allowed to deploy to this protected environment. The user must be a member of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_protected_environment#user_id ProjectProtectedEnvironment#user_id}
    */
    readonly userId?: number;
}
export declare function projectProtectedEnvironmentDeployAccessLevelsToTerraform(struct?: ProjectProtectedEnvironmentDeployAccessLevels | cdktf.IResolvable): any;
export declare class ProjectProtectedEnvironmentDeployAccessLevelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProjectProtectedEnvironmentDeployAccessLevels | cdktf.IResolvable | undefined;
    set internalValue(value: ProjectProtectedEnvironmentDeployAccessLevels | cdktf.IResolvable | undefined);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    resetAccessLevel(): void;
    get accessLevelInput(): string | undefined;
    get accessLevelDescription(): string;
    private _groupId?;
    get groupId(): number;
    set groupId(value: number);
    resetGroupId(): void;
    get groupIdInput(): number | undefined;
    private _userId?;
    get userId(): number;
    set userId(value: number);
    resetUserId(): void;
    get userIdInput(): number | undefined;
}
export declare class ProjectProtectedEnvironmentDeployAccessLevelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProjectProtectedEnvironmentDeployAccessLevels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProjectProtectedEnvironmentDeployAccessLevelsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_protected_environment gitlab_project_protected_environment}
*/
export declare class ProjectProtectedEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_protected_environment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_protected_environment gitlab_project_protected_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectProtectedEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: ProjectProtectedEnvironmentConfig);
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _requiredApprovalCount?;
    get requiredApprovalCount(): number;
    set requiredApprovalCount(value: number);
    resetRequiredApprovalCount(): void;
    get requiredApprovalCountInput(): number | undefined;
    private _deployAccessLevels;
    get deployAccessLevels(): ProjectProtectedEnvironmentDeployAccessLevelsList;
    putDeployAccessLevels(value: ProjectProtectedEnvironmentDeployAccessLevels[] | cdktf.IResolvable): void;
    resetDeployAccessLevels(): void;
    get deployAccessLevelsInput(): cdktf.IResolvable | ProjectProtectedEnvironmentDeployAccessLevels[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
