import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PagesDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enables [automatic generation](https://docs.gitlab.com/ee/user/project/pages/custom_domains_ssl_tls_certification/lets_encrypt_integration.html) of SSL certificates issued by Let’s Encrypt for custom domains. When this is set to "true", certificate can't be provided.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pages_domain#auto_ssl_enabled PagesDomain#auto_ssl_enabled}
    */
    readonly autoSslEnabled?: boolean | cdktf.IResolvable;
    /**
    * The certificate in PEM format with intermediates following in most specific to least specific order.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pages_domain#certificate PagesDomain#certificate}
    */
    readonly certificate?: string;
    /**
    * The custom domain indicated by the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pages_domain#domain PagesDomain#domain}
    */
    readonly domain: string;
    /**
    * Whether the certificate is expired.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pages_domain#expired PagesDomain#expired}
    */
    readonly expired?: boolean | cdktf.IResolvable;
    /**
    * The certificate key in PEM format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pages_domain#key PagesDomain#key}
    */
    readonly key?: string;
    /**
    * The ID or [URL-encoded path of the project](https://docs.gitlab.com/ee/api/index.html#namespaced-path-encoding) owned by the authenticated user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/pages_domain#project PagesDomain#project}
    */
    readonly project: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/pages_domain gitlab_pages_domain}
*/
export declare class PagesDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_pages_domain";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/pages_domain gitlab_pages_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PagesDomainConfig
    */
    constructor(scope: Construct, id: string, config: PagesDomainConfig);
    private _autoSslEnabled?;
    get autoSslEnabled(): boolean | cdktf.IResolvable;
    set autoSslEnabled(value: boolean | cdktf.IResolvable);
    resetAutoSslEnabled(): void;
    get autoSslEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    get domainInput(): string | undefined;
    private _expired?;
    get expired(): boolean | cdktf.IResolvable;
    set expired(value: boolean | cdktf.IResolvable);
    resetExpired(): void;
    get expiredInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get url(): string;
    get verificationCode(): string;
    get verified(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
