"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Group = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group gitlab_group}
*/
class Group extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group gitlab_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_group',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '15.10.0',
                providerVersionConstraint: '~> 15.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._autoDevopsEnabled = config.autoDevopsEnabled;
        this._avatar = config.avatar;
        this._avatarHash = config.avatarHash;
        this._defaultBranchProtection = config.defaultBranchProtection;
        this._description = config.description;
        this._emailsDisabled = config.emailsDisabled;
        this._extraSharedRunnersMinutesLimit = config.extraSharedRunnersMinutesLimit;
        this._id = config.id;
        this._ipRestrictionRanges = config.ipRestrictionRanges;
        this._lfsEnabled = config.lfsEnabled;
        this._membershipLock = config.membershipLock;
        this._mentionsDisabled = config.mentionsDisabled;
        this._name = config.name;
        this._parentId = config.parentId;
        this._path = config.path;
        this._preventForkingOutsideGroup = config.preventForkingOutsideGroup;
        this._projectCreationLevel = config.projectCreationLevel;
        this._requestAccessEnabled = config.requestAccessEnabled;
        this._requireTwoFactorAuthentication = config.requireTwoFactorAuthentication;
        this._shareWithGroupLock = config.shareWithGroupLock;
        this._sharedRunnersMinutesLimit = config.sharedRunnersMinutesLimit;
        this._subgroupCreationLevel = config.subgroupCreationLevel;
        this._twoFactorGracePeriod = config.twoFactorGracePeriod;
        this._visibilityLevel = config.visibilityLevel;
    }
    get autoDevopsEnabled() {
        return this.getBooleanAttribute('auto_devops_enabled');
    }
    set autoDevopsEnabled(value) {
        this._autoDevopsEnabled = value;
    }
    resetAutoDevopsEnabled() {
        this._autoDevopsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsEnabledInput() {
        return this._autoDevopsEnabled;
    }
    get avatar() {
        return this.getStringAttribute('avatar');
    }
    set avatar(value) {
        this._avatar = value;
    }
    resetAvatar() {
        this._avatar = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get avatarInput() {
        return this._avatar;
    }
    get avatarHash() {
        return this.getStringAttribute('avatar_hash');
    }
    set avatarHash(value) {
        this._avatarHash = value;
    }
    resetAvatarHash() {
        this._avatarHash = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get avatarHashInput() {
        return this._avatarHash;
    }
    // avatar_url - computed: true, optional: false, required: false
    get avatarUrl() {
        return this.getStringAttribute('avatar_url');
    }
    get defaultBranchProtection() {
        return this.getNumberAttribute('default_branch_protection');
    }
    set defaultBranchProtection(value) {
        this._defaultBranchProtection = value;
    }
    resetDefaultBranchProtection() {
        this._defaultBranchProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultBranchProtectionInput() {
        return this._defaultBranchProtection;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get emailsDisabled() {
        return this.getBooleanAttribute('emails_disabled');
    }
    set emailsDisabled(value) {
        this._emailsDisabled = value;
    }
    resetEmailsDisabled() {
        this._emailsDisabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailsDisabledInput() {
        return this._emailsDisabled;
    }
    get extraSharedRunnersMinutesLimit() {
        return this.getNumberAttribute('extra_shared_runners_minutes_limit');
    }
    set extraSharedRunnersMinutesLimit(value) {
        this._extraSharedRunnersMinutesLimit = value;
    }
    resetExtraSharedRunnersMinutesLimit() {
        this._extraSharedRunnersMinutesLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get extraSharedRunnersMinutesLimitInput() {
        return this._extraSharedRunnersMinutesLimit;
    }
    // full_name - computed: true, optional: false, required: false
    get fullName() {
        return this.getStringAttribute('full_name');
    }
    // full_path - computed: true, optional: false, required: false
    get fullPath() {
        return this.getStringAttribute('full_path');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ipRestrictionRanges() {
        return this.getListAttribute('ip_restriction_ranges');
    }
    set ipRestrictionRanges(value) {
        this._ipRestrictionRanges = value;
    }
    resetIpRestrictionRanges() {
        this._ipRestrictionRanges = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipRestrictionRangesInput() {
        return this._ipRestrictionRanges;
    }
    get lfsEnabled() {
        return this.getBooleanAttribute('lfs_enabled');
    }
    set lfsEnabled(value) {
        this._lfsEnabled = value;
    }
    resetLfsEnabled() {
        this._lfsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lfsEnabledInput() {
        return this._lfsEnabled;
    }
    get membershipLock() {
        return this.getBooleanAttribute('membership_lock');
    }
    set membershipLock(value) {
        this._membershipLock = value;
    }
    resetMembershipLock() {
        this._membershipLock = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get membershipLockInput() {
        return this._membershipLock;
    }
    get mentionsDisabled() {
        return this.getBooleanAttribute('mentions_disabled');
    }
    set mentionsDisabled(value) {
        this._mentionsDisabled = value;
    }
    resetMentionsDisabled() {
        this._mentionsDisabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mentionsDisabledInput() {
        return this._mentionsDisabled;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get parentId() {
        return this.getNumberAttribute('parent_id');
    }
    set parentId(value) {
        this._parentId = value;
    }
    resetParentId() {
        this._parentId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get parentIdInput() {
        return this._parentId;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    get preventForkingOutsideGroup() {
        return this.getBooleanAttribute('prevent_forking_outside_group');
    }
    set preventForkingOutsideGroup(value) {
        this._preventForkingOutsideGroup = value;
    }
    resetPreventForkingOutsideGroup() {
        this._preventForkingOutsideGroup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preventForkingOutsideGroupInput() {
        return this._preventForkingOutsideGroup;
    }
    get projectCreationLevel() {
        return this.getStringAttribute('project_creation_level');
    }
    set projectCreationLevel(value) {
        this._projectCreationLevel = value;
    }
    resetProjectCreationLevel() {
        this._projectCreationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectCreationLevelInput() {
        return this._projectCreationLevel;
    }
    get requestAccessEnabled() {
        return this.getBooleanAttribute('request_access_enabled');
    }
    set requestAccessEnabled(value) {
        this._requestAccessEnabled = value;
    }
    resetRequestAccessEnabled() {
        this._requestAccessEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestAccessEnabledInput() {
        return this._requestAccessEnabled;
    }
    get requireTwoFactorAuthentication() {
        return this.getBooleanAttribute('require_two_factor_authentication');
    }
    set requireTwoFactorAuthentication(value) {
        this._requireTwoFactorAuthentication = value;
    }
    resetRequireTwoFactorAuthentication() {
        this._requireTwoFactorAuthentication = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireTwoFactorAuthenticationInput() {
        return this._requireTwoFactorAuthentication;
    }
    // runners_token - computed: true, optional: false, required: false
    get runnersToken() {
        return this.getStringAttribute('runners_token');
    }
    get shareWithGroupLock() {
        return this.getBooleanAttribute('share_with_group_lock');
    }
    set shareWithGroupLock(value) {
        this._shareWithGroupLock = value;
    }
    resetShareWithGroupLock() {
        this._shareWithGroupLock = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get shareWithGroupLockInput() {
        return this._shareWithGroupLock;
    }
    get sharedRunnersMinutesLimit() {
        return this.getNumberAttribute('shared_runners_minutes_limit');
    }
    set sharedRunnersMinutesLimit(value) {
        this._sharedRunnersMinutesLimit = value;
    }
    resetSharedRunnersMinutesLimit() {
        this._sharedRunnersMinutesLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedRunnersMinutesLimitInput() {
        return this._sharedRunnersMinutesLimit;
    }
    get subgroupCreationLevel() {
        return this.getStringAttribute('subgroup_creation_level');
    }
    set subgroupCreationLevel(value) {
        this._subgroupCreationLevel = value;
    }
    resetSubgroupCreationLevel() {
        this._subgroupCreationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subgroupCreationLevelInput() {
        return this._subgroupCreationLevel;
    }
    get twoFactorGracePeriod() {
        return this.getNumberAttribute('two_factor_grace_period');
    }
    set twoFactorGracePeriod(value) {
        this._twoFactorGracePeriod = value;
    }
    resetTwoFactorGracePeriod() {
        this._twoFactorGracePeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get twoFactorGracePeriodInput() {
        return this._twoFactorGracePeriod;
    }
    get visibilityLevel() {
        return this.getStringAttribute('visibility_level');
    }
    set visibilityLevel(value) {
        this._visibilityLevel = value;
    }
    resetVisibilityLevel() {
        this._visibilityLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get visibilityLevelInput() {
        return this._visibilityLevel;
    }
    // web_url - computed: true, optional: false, required: false
    get webUrl() {
        return this.getStringAttribute('web_url');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auto_devops_enabled: cdktf.booleanToTerraform(this._autoDevopsEnabled),
            avatar: cdktf.stringToTerraform(this._avatar),
            avatar_hash: cdktf.stringToTerraform(this._avatarHash),
            default_branch_protection: cdktf.numberToTerraform(this._defaultBranchProtection),
            description: cdktf.stringToTerraform(this._description),
            emails_disabled: cdktf.booleanToTerraform(this._emailsDisabled),
            extra_shared_runners_minutes_limit: cdktf.numberToTerraform(this._extraSharedRunnersMinutesLimit),
            id: cdktf.stringToTerraform(this._id),
            ip_restriction_ranges: cdktf.listMapper(cdktf.stringToTerraform, false)(this._ipRestrictionRanges),
            lfs_enabled: cdktf.booleanToTerraform(this._lfsEnabled),
            membership_lock: cdktf.booleanToTerraform(this._membershipLock),
            mentions_disabled: cdktf.booleanToTerraform(this._mentionsDisabled),
            name: cdktf.stringToTerraform(this._name),
            parent_id: cdktf.numberToTerraform(this._parentId),
            path: cdktf.stringToTerraform(this._path),
            prevent_forking_outside_group: cdktf.booleanToTerraform(this._preventForkingOutsideGroup),
            project_creation_level: cdktf.stringToTerraform(this._projectCreationLevel),
            request_access_enabled: cdktf.booleanToTerraform(this._requestAccessEnabled),
            require_two_factor_authentication: cdktf.booleanToTerraform(this._requireTwoFactorAuthentication),
            share_with_group_lock: cdktf.booleanToTerraform(this._shareWithGroupLock),
            shared_runners_minutes_limit: cdktf.numberToTerraform(this._sharedRunnersMinutesLimit),
            subgroup_creation_level: cdktf.stringToTerraform(this._subgroupCreationLevel),
            two_factor_grace_period: cdktf.numberToTerraform(this._twoFactorGracePeriod),
            visibility_level: cdktf.stringToTerraform(this._visibilityLevel),
        };
    }
}
exports.Group = Group;
_a = JSII_RTTI_SYMBOL_1;
Group[_a] = { fqn: "@cdktf/provider-gitlab.group.Group", version: "6.0.2" };
// =================
// STATIC PROPERTIES
// =================
Group.tfResourceType = "gitlab_group";
//# sourceMappingURL=data:application/json;base64,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