import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Limit by archived status.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#archived DataGitlabProjects#archived}
    */
    readonly archived?: boolean | cdktf.IResolvable;
    /**
    * The ID of the group owned by the authenticated user to look projects for within. Cannot be used with `min_access_level`, `with_programming_language` or `statistics`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#group_id DataGitlabProjects#group_id}
    */
    readonly groupId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#id DataGitlabProjects#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Include projects in subgroups of this group. Default is `false`. Needs `group_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#include_subgroups DataGitlabProjects#include_subgroups}
    */
    readonly includeSubgroups?: boolean | cdktf.IResolvable;
    /**
    * The maximum number of project results pages that may be queried. Prevents overloading your Gitlab instance in case of a misconfiguration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#max_queryable_pages DataGitlabProjects#max_queryable_pages}
    */
    readonly maxQueryablePages?: number;
    /**
    * Limit by projects that the current user is a member of.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#membership DataGitlabProjects#membership}
    */
    readonly membership?: boolean | cdktf.IResolvable;
    /**
    * Limit to projects where current user has at least this access level, refer to the [official documentation](https://docs.gitlab.com/ee/api/members.html) for values. Cannot be used with `group_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#min_access_level DataGitlabProjects#min_access_level}
    */
    readonly minAccessLevel?: number;
    /**
    * Return projects ordered ordered by: `id`, `name`, `path`, `created_at`, `updated_at`, `last_activity_at`, `similarity`, `repository_size`, `storage_size`, `packages_size`, `wiki_size`. Some values or only available in certain circumstances. See [upstream docs](https://docs.gitlab.com/ee/api/projects.html#list-all-projects) for details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#order_by DataGitlabProjects#order_by}
    */
    readonly orderBy?: string;
    /**
    * Limit by projects owned by the current user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#owned DataGitlabProjects#owned}
    */
    readonly owned?: boolean | cdktf.IResolvable;
    /**
    * The first page to begin the query on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#page DataGitlabProjects#page}
    */
    readonly page?: number;
    /**
    * The number of results to return per page.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#per_page DataGitlabProjects#per_page}
    */
    readonly perPage?: number;
    /**
    * Return list of authorized projects matching the search criteria.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#search DataGitlabProjects#search}
    */
    readonly search?: string;
    /**
    * Return only the ID, URL, name, and path of each project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#simple DataGitlabProjects#simple}
    */
    readonly simple?: boolean | cdktf.IResolvable;
    /**
    * Return projects sorted in `asc` or `desc` order. Default is `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#sort DataGitlabProjects#sort}
    */
    readonly sort?: string;
    /**
    * Limit by projects starred by the current user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#starred DataGitlabProjects#starred}
    */
    readonly starred?: boolean | cdktf.IResolvable;
    /**
    * Include project statistics. Cannot be used with `group_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#statistics DataGitlabProjects#statistics}
    */
    readonly statistics?: boolean | cdktf.IResolvable;
    /**
    * Limit by visibility `public`, `internal`, or `private`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#visibility DataGitlabProjects#visibility}
    */
    readonly visibility?: string;
    /**
    * Include custom attributes in response _(admins only)_.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#with_custom_attributes DataGitlabProjects#with_custom_attributes}
    */
    readonly withCustomAttributes?: boolean | cdktf.IResolvable;
    /**
    * Limit by projects with issues feature enabled. Default is `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#with_issues_enabled DataGitlabProjects#with_issues_enabled}
    */
    readonly withIssuesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Limit by projects with merge requests feature enabled. Default is `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#with_merge_requests_enabled DataGitlabProjects#with_merge_requests_enabled}
    */
    readonly withMergeRequestsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Limit by projects which use the given programming language. Cannot be used with `group_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#with_programming_language DataGitlabProjects#with_programming_language}
    */
    readonly withProgrammingLanguage?: string;
    /**
    * Include projects shared to this group. Default is `true`. Needs `group_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/projects#with_shared DataGitlabProjects#with_shared}
    */
    readonly withShared?: boolean | cdktf.IResolvable;
}
export interface DataGitlabProjectsProjectsContainerExpirationPolicy {
}
export declare function dataGitlabProjectsProjectsContainerExpirationPolicyToTerraform(struct?: DataGitlabProjectsProjectsContainerExpirationPolicy): any;
export declare class DataGitlabProjectsProjectsContainerExpirationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectsProjectsContainerExpirationPolicy | undefined;
    set internalValue(value: DataGitlabProjectsProjectsContainerExpirationPolicy | undefined);
    get cadence(): string;
    get enabled(): cdktf.IResolvable;
    get keepN(): number;
    get nameRegex(): string;
    get nameRegexDelete(): string;
    get nameRegexKeep(): string;
    get nextRunAt(): string;
    get olderThan(): string;
}
export declare class DataGitlabProjectsProjectsContainerExpirationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectsProjectsContainerExpirationPolicyOutputReference;
}
export interface DataGitlabProjectsProjectsForkedFromProject {
}
export declare function dataGitlabProjectsProjectsForkedFromProjectToTerraform(struct?: DataGitlabProjectsProjectsForkedFromProject): any;
export declare class DataGitlabProjectsProjectsForkedFromProjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectsProjectsForkedFromProject | undefined;
    set internalValue(value: DataGitlabProjectsProjectsForkedFromProject | undefined);
    get httpUrlToRepo(): string;
    get id(): number;
    get name(): string;
    get nameWithNamespace(): string;
    get path(): string;
    get pathWithNamespace(): string;
    get webUrl(): string;
}
export declare class DataGitlabProjectsProjectsForkedFromProjectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectsProjectsForkedFromProjectOutputReference;
}
export interface DataGitlabProjectsProjectsNamespace {
}
export declare function dataGitlabProjectsProjectsNamespaceToTerraform(struct?: DataGitlabProjectsProjectsNamespace): any;
export declare class DataGitlabProjectsProjectsNamespaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectsProjectsNamespace | undefined;
    set internalValue(value: DataGitlabProjectsProjectsNamespace | undefined);
    get fullPath(): string;
    get id(): number;
    get kind(): string;
    get name(): string;
    get path(): string;
}
export declare class DataGitlabProjectsProjectsNamespaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectsProjectsNamespaceOutputReference;
}
export interface DataGitlabProjectsProjectsOwner {
}
export declare function dataGitlabProjectsProjectsOwnerToTerraform(struct?: DataGitlabProjectsProjectsOwner): any;
export declare class DataGitlabProjectsProjectsOwnerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectsProjectsOwner | undefined;
    set internalValue(value: DataGitlabProjectsProjectsOwner | undefined);
    get avatarUrl(): string;
    get id(): number;
    get name(): string;
    get state(): string;
    get username(): string;
    get websiteUrl(): string;
}
export declare class DataGitlabProjectsProjectsOwnerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectsProjectsOwnerOutputReference;
}
export interface DataGitlabProjectsProjectsPermissions {
}
export declare function dataGitlabProjectsProjectsPermissionsToTerraform(struct?: DataGitlabProjectsProjectsPermissions): any;
export declare class DataGitlabProjectsProjectsPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectsProjectsPermissions | undefined;
    set internalValue(value: DataGitlabProjectsProjectsPermissions | undefined);
    private _groupAccess;
    get groupAccess(): cdktf.NumberMap;
    private _projectAccess;
    get projectAccess(): cdktf.NumberMap;
}
export declare class DataGitlabProjectsProjectsPermissionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectsProjectsPermissionsOutputReference;
}
export interface DataGitlabProjectsProjectsSharedWithGroups {
}
export declare function dataGitlabProjectsProjectsSharedWithGroupsToTerraform(struct?: DataGitlabProjectsProjectsSharedWithGroups): any;
export declare class DataGitlabProjectsProjectsSharedWithGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectsProjectsSharedWithGroups | undefined;
    set internalValue(value: DataGitlabProjectsProjectsSharedWithGroups | undefined);
    get groupAccessLevel(): string;
    get groupId(): number;
    get groupName(): string;
}
export declare class DataGitlabProjectsProjectsSharedWithGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectsProjectsSharedWithGroupsOutputReference;
}
export interface DataGitlabProjectsProjects {
}
export declare function dataGitlabProjectsProjectsToTerraform(struct?: DataGitlabProjectsProjects): any;
export declare class DataGitlabProjectsProjectsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectsProjects | undefined;
    set internalValue(value: DataGitlabProjectsProjects | undefined);
    private _links;
    get links(): cdktf.StringMap;
    get allowMergeOnSkippedPipeline(): cdktf.IResolvable;
    get analyticsAccessLevel(): string;
    get approvalsBeforeMerge(): number;
    get archived(): cdktf.IResolvable;
    get autoCancelPendingPipelines(): string;
    get autoDevopsDeployStrategy(): string;
    get autoDevopsEnabled(): cdktf.IResolvable;
    get autocloseReferencedIssues(): cdktf.IResolvable;
    get avatarUrl(): string;
    get buildCoverageRegex(): string;
    get buildGitStrategy(): string;
    get buildTimeout(): number;
    get buildsAccessLevel(): string;
    get ciConfigPath(): string;
    get ciDefaultGitDepth(): number;
    get ciForwardDeploymentEnabled(): cdktf.IResolvable;
    private _containerExpirationPolicy;
    get containerExpirationPolicy(): DataGitlabProjectsProjectsContainerExpirationPolicyList;
    get containerRegistryAccessLevel(): string;
    get containerRegistryEnabled(): cdktf.IResolvable;
    get createdAt(): string;
    get creatorId(): number;
    private _customAttributes;
    get customAttributes(): cdktf.StringMapList;
    get defaultBranch(): string;
    get description(): string;
    get emailsDisabled(): cdktf.IResolvable;
    get environmentsAccessLevel(): string;
    get externalAuthorizationClassificationLabel(): string;
    get featureFlagsAccessLevel(): string;
    private _forkedFromProject;
    get forkedFromProject(): DataGitlabProjectsProjectsForkedFromProjectList;
    get forkingAccessLevel(): string;
    get forksCount(): number;
    get httpUrlToRepo(): string;
    get id(): number;
    get importError(): string;
    get importStatus(): string;
    get importUrl(): string;
    get infrastructureAccessLevel(): string;
    get issuesAccessLevel(): string;
    get issuesEnabled(): cdktf.IResolvable;
    get jobsEnabled(): cdktf.IResolvable;
    get lastActivityAt(): string;
    get lfsEnabled(): cdktf.IResolvable;
    get mergeCommitTemplate(): string;
    get mergeMethod(): string;
    get mergePipelinesEnabled(): cdktf.IResolvable;
    get mergeRequestsAccessLevel(): string;
    get mergeRequestsEnabled(): cdktf.IResolvable;
    get mergeTrainsEnabled(): cdktf.IResolvable;
    get mirror(): cdktf.IResolvable;
    get mirrorOverwritesDivergedBranches(): cdktf.IResolvable;
    get mirrorTriggerBuilds(): cdktf.IResolvable;
    get mirrorUserId(): number;
    get monitorAccessLevel(): string;
    get name(): string;
    get nameWithNamespace(): string;
    private _namespace;
    get namespace(): DataGitlabProjectsProjectsNamespaceList;
    get onlyAllowMergeIfAllDiscussionsAreResolved(): cdktf.IResolvable;
    get onlyAllowMergeIfPipelineSucceeds(): cdktf.IResolvable;
    get onlyMirrorProtectedBranches(): cdktf.IResolvable;
    get openIssuesCount(): number;
    get operationsAccessLevel(): string;
    private _owner;
    get owner(): DataGitlabProjectsProjectsOwnerList;
    get packagesEnabled(): cdktf.IResolvable;
    get path(): string;
    get pathWithNamespace(): string;
    private _permissions;
    get permissions(): DataGitlabProjectsProjectsPermissionsList;
    get public(): cdktf.IResolvable;
    get publicBuilds(): cdktf.IResolvable;
    get readmeUrl(): string;
    get releasesAccessLevel(): string;
    get repositoryAccessLevel(): string;
    get repositoryStorage(): string;
    get requestAccessEnabled(): cdktf.IResolvable;
    get requirementsAccessLevel(): string;
    get resolveOutdatedDiffDiscussions(): cdktf.IResolvable;
    get restrictUserDefinedVariables(): cdktf.IResolvable;
    get runnersToken(): string;
    get securityAndComplianceAccessLevel(): string;
    get sharedRunnersEnabled(): cdktf.IResolvable;
    private _sharedWithGroups;
    get sharedWithGroups(): DataGitlabProjectsProjectsSharedWithGroupsList;
    get snippetsAccessLevel(): string;
    get snippetsEnabled(): cdktf.IResolvable;
    get squashCommitTemplate(): string;
    get sshUrlToRepo(): string;
    get starCount(): number;
    private _statistics;
    get statistics(): cdktf.NumberMap;
    get suggestionCommitMessage(): string;
    get tagList(): string[];
    get topics(): string[];
    get visibility(): string;
    get webUrl(): string;
    get wikiAccessLevel(): string;
    get wikiEnabled(): cdktf.IResolvable;
}
export declare class DataGitlabProjectsProjectsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectsProjectsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/projects gitlab_projects}
*/
export declare class DataGitlabProjects extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_projects";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/projects gitlab_projects} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGitlabProjectsConfig);
    private _archived?;
    get archived(): boolean | cdktf.IResolvable;
    set archived(value: boolean | cdktf.IResolvable);
    resetArchived(): void;
    get archivedInput(): boolean | cdktf.IResolvable | undefined;
    private _groupId?;
    get groupId(): number;
    set groupId(value: number);
    resetGroupId(): void;
    get groupIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _includeSubgroups?;
    get includeSubgroups(): boolean | cdktf.IResolvable;
    set includeSubgroups(value: boolean | cdktf.IResolvable);
    resetIncludeSubgroups(): void;
    get includeSubgroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _maxQueryablePages?;
    get maxQueryablePages(): number;
    set maxQueryablePages(value: number);
    resetMaxQueryablePages(): void;
    get maxQueryablePagesInput(): number | undefined;
    private _membership?;
    get membership(): boolean | cdktf.IResolvable;
    set membership(value: boolean | cdktf.IResolvable);
    resetMembership(): void;
    get membershipInput(): boolean | cdktf.IResolvable | undefined;
    private _minAccessLevel?;
    get minAccessLevel(): number;
    set minAccessLevel(value: number);
    resetMinAccessLevel(): void;
    get minAccessLevelInput(): number | undefined;
    private _orderBy?;
    get orderBy(): string;
    set orderBy(value: string);
    resetOrderBy(): void;
    get orderByInput(): string | undefined;
    private _owned?;
    get owned(): boolean | cdktf.IResolvable;
    set owned(value: boolean | cdktf.IResolvable);
    resetOwned(): void;
    get ownedInput(): boolean | cdktf.IResolvable | undefined;
    private _page?;
    get page(): number;
    set page(value: number);
    resetPage(): void;
    get pageInput(): number | undefined;
    private _perPage?;
    get perPage(): number;
    set perPage(value: number);
    resetPerPage(): void;
    get perPageInput(): number | undefined;
    private _projects;
    get projects(): DataGitlabProjectsProjectsList;
    private _search?;
    get search(): string;
    set search(value: string);
    resetSearch(): void;
    get searchInput(): string | undefined;
    private _simple?;
    get simple(): boolean | cdktf.IResolvable;
    set simple(value: boolean | cdktf.IResolvable);
    resetSimple(): void;
    get simpleInput(): boolean | cdktf.IResolvable | undefined;
    private _sort?;
    get sort(): string;
    set sort(value: string);
    resetSort(): void;
    get sortInput(): string | undefined;
    private _starred?;
    get starred(): boolean | cdktf.IResolvable;
    set starred(value: boolean | cdktf.IResolvable);
    resetStarred(): void;
    get starredInput(): boolean | cdktf.IResolvable | undefined;
    private _statistics?;
    get statistics(): boolean | cdktf.IResolvable;
    set statistics(value: boolean | cdktf.IResolvable);
    resetStatistics(): void;
    get statisticsInput(): boolean | cdktf.IResolvable | undefined;
    private _visibility?;
    get visibility(): string;
    set visibility(value: string);
    resetVisibility(): void;
    get visibilityInput(): string | undefined;
    private _withCustomAttributes?;
    get withCustomAttributes(): boolean | cdktf.IResolvable;
    set withCustomAttributes(value: boolean | cdktf.IResolvable);
    resetWithCustomAttributes(): void;
    get withCustomAttributesInput(): boolean | cdktf.IResolvable | undefined;
    private _withIssuesEnabled?;
    get withIssuesEnabled(): boolean | cdktf.IResolvable;
    set withIssuesEnabled(value: boolean | cdktf.IResolvable);
    resetWithIssuesEnabled(): void;
    get withIssuesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _withMergeRequestsEnabled?;
    get withMergeRequestsEnabled(): boolean | cdktf.IResolvable;
    set withMergeRequestsEnabled(value: boolean | cdktf.IResolvable);
    resetWithMergeRequestsEnabled(): void;
    get withMergeRequestsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _withProgrammingLanguage?;
    get withProgrammingLanguage(): string;
    set withProgrammingLanguage(value: string);
    resetWithProgrammingLanguage(): void;
    get withProgrammingLanguageInput(): string | undefined;
    private _withShared?;
    get withShared(): boolean | cdktf.IResolvable;
    set withShared(value: boolean | cdktf.IResolvable);
    resetWithShared(): void;
    get withSharedInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
