import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabMetadataConfig extends cdktf.TerraformMetaArguments {
}
export interface DataGitlabMetadataKas {
}
export declare function dataGitlabMetadataKasToTerraform(struct?: DataGitlabMetadataKas): any;
export declare class DataGitlabMetadataKasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataGitlabMetadataKas | undefined;
    set internalValue(value: DataGitlabMetadataKas | undefined);
    get enabled(): cdktf.IResolvable;
    get externalUrl(): string;
    get version(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/metadata gitlab_metadata}
*/
export declare class DataGitlabMetadata extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_metadata";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/metadata gitlab_metadata} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabMetadataConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGitlabMetadataConfig);
    get enterprise(): cdktf.IResolvable;
    get id(): string;
    private _kas;
    get kas(): DataGitlabMetadataKasOutputReference;
    get revision(): string;
    get version(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
