import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabGroupSubgroupsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Show all the groups you have access to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_subgroups#all_available DataGitlabGroupSubgroups#all_available}
    */
    readonly allAvailable?: boolean | cdktf.IResolvable;
    /**
    * The ID of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_subgroups#group_id DataGitlabGroupSubgroups#group_id}
    */
    readonly groupId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_subgroups#id DataGitlabGroupSubgroups#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Limit to groups where current user has at least this access level.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_subgroups#min_access_level DataGitlabGroupSubgroups#min_access_level}
    */
    readonly minAccessLevel?: string;
    /**
    * Order groups by name, path or id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_subgroups#order_by DataGitlabGroupSubgroups#order_by}
    */
    readonly orderBy?: string;
    /**
    * Limit to groups explicitly owned by the current user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_subgroups#owned DataGitlabGroupSubgroups#owned}
    */
    readonly owned?: boolean | cdktf.IResolvable;
    /**
    * Return the list of authorized groups matching the search criteria.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_subgroups#search DataGitlabGroupSubgroups#search}
    */
    readonly search?: string;
    /**
    * Skip the group IDs passed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_subgroups#skip_groups DataGitlabGroupSubgroups#skip_groups}
    */
    readonly skipGroups?: number[];
    /**
    * Order groups in asc or desc order.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_subgroups#sort DataGitlabGroupSubgroups#sort}
    */
    readonly sort?: string;
    /**
    * Include group statistics (administrators only).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_subgroups#statistics DataGitlabGroupSubgroups#statistics}
    */
    readonly statistics?: boolean | cdktf.IResolvable;
    /**
    * Include custom attributes in response (administrators only).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_subgroups#with_custom_attributes DataGitlabGroupSubgroups#with_custom_attributes}
    */
    readonly withCustomAttributes?: boolean | cdktf.IResolvable;
}
export interface DataGitlabGroupSubgroupsSubgroups {
}
export declare function dataGitlabGroupSubgroupsSubgroupsToTerraform(struct?: DataGitlabGroupSubgroupsSubgroups): any;
export declare class DataGitlabGroupSubgroupsSubgroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabGroupSubgroupsSubgroups | undefined;
    set internalValue(value: DataGitlabGroupSubgroupsSubgroups | undefined);
    get autoDevopsEnabled(): cdktf.IResolvable;
    get avatarUrl(): string;
    get createdAt(): string;
    get defaultBranchProtection(): number;
    get description(): string;
    get emailsDisabled(): cdktf.IResolvable;
    get fileTemplateProjectId(): number;
    get fullName(): string;
    get fullPath(): string;
    get groupId(): number;
    get ipRestrictionRanges(): string;
    get lfsEnabled(): cdktf.IResolvable;
    get mentionsDisabled(): cdktf.IResolvable;
    get name(): string;
    get parentId(): number;
    get path(): string;
    get projectCreationLevel(): string;
    get requestAccessEnabled(): cdktf.IResolvable;
    get requireTwoFactorAuthentication(): cdktf.IResolvable;
    get shareWithGroupLock(): cdktf.IResolvable;
    private _statistics;
    get statistics(): cdktf.StringMap;
    get subgroupCreationLevel(): string;
    get twoFactorGracePeriod(): number;
    get visibility(): string;
    get webUrl(): string;
}
export declare class DataGitlabGroupSubgroupsSubgroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabGroupSubgroupsSubgroupsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/group_subgroups gitlab_group_subgroups}
*/
export declare class DataGitlabGroupSubgroups extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_group_subgroups";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/group_subgroups gitlab_group_subgroups} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabGroupSubgroupsConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabGroupSubgroupsConfig);
    private _allAvailable?;
    get allAvailable(): boolean | cdktf.IResolvable;
    set allAvailable(value: boolean | cdktf.IResolvable);
    resetAllAvailable(): void;
    get allAvailableInput(): boolean | cdktf.IResolvable | undefined;
    private _groupId?;
    get groupId(): number;
    set groupId(value: number);
    get groupIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _minAccessLevel?;
    get minAccessLevel(): string;
    set minAccessLevel(value: string);
    resetMinAccessLevel(): void;
    get minAccessLevelInput(): string | undefined;
    private _orderBy?;
    get orderBy(): string;
    set orderBy(value: string);
    resetOrderBy(): void;
    get orderByInput(): string | undefined;
    private _owned?;
    get owned(): boolean | cdktf.IResolvable;
    set owned(value: boolean | cdktf.IResolvable);
    resetOwned(): void;
    get ownedInput(): boolean | cdktf.IResolvable | undefined;
    private _search?;
    get search(): string;
    set search(value: string);
    resetSearch(): void;
    get searchInput(): string | undefined;
    private _skipGroups?;
    get skipGroups(): number[];
    set skipGroups(value: number[]);
    resetSkipGroups(): void;
    get skipGroupsInput(): number[] | undefined;
    private _sort?;
    get sort(): string;
    set sort(value: string);
    resetSort(): void;
    get sortInput(): string | undefined;
    private _statistics?;
    get statistics(): boolean | cdktf.IResolvable;
    set statistics(value: boolean | cdktf.IResolvable);
    resetStatistics(): void;
    get statisticsInput(): boolean | cdktf.IResolvable | undefined;
    private _subgroups;
    get subgroups(): DataGitlabGroupSubgroupsSubgroupsList;
    private _withCustomAttributes?;
    get withCustomAttributes(): boolean | cdktf.IResolvable;
    set withCustomAttributes(value: boolean | cdktf.IResolvable);
    resetWithCustomAttributes(): void;
    get withCustomAttributesInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
