import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabGroupHooksConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID or full path of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_hooks#group DataGitlabGroupHooks#group}
    */
    readonly group: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_hooks#id DataGitlabGroupHooks#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataGitlabGroupHooksHooks {
}
export declare function dataGitlabGroupHooksHooksToTerraform(struct?: DataGitlabGroupHooksHooks): any;
export declare class DataGitlabGroupHooksHooksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabGroupHooksHooks | undefined;
    set internalValue(value: DataGitlabGroupHooksHooks | undefined);
    get confidentialIssuesEvents(): cdktf.IResolvable;
    get confidentialNoteEvents(): cdktf.IResolvable;
    get deploymentEvents(): cdktf.IResolvable;
    get enableSslVerification(): cdktf.IResolvable;
    get group(): string;
    get groupId(): number;
    get hookId(): number;
    get issuesEvents(): cdktf.IResolvable;
    get jobEvents(): cdktf.IResolvable;
    get mergeRequestsEvents(): cdktf.IResolvable;
    get noteEvents(): cdktf.IResolvable;
    get pipelineEvents(): cdktf.IResolvable;
    get pushEvents(): cdktf.IResolvable;
    get pushEventsBranchFilter(): string;
    get releasesEvents(): cdktf.IResolvable;
    get subgroupEvents(): cdktf.IResolvable;
    get tagPushEvents(): cdktf.IResolvable;
    get token(): string;
    get url(): string;
    get wikiPageEvents(): cdktf.IResolvable;
}
export declare class DataGitlabGroupHooksHooksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabGroupHooksHooksOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/group_hooks gitlab_group_hooks}
*/
export declare class DataGitlabGroupHooks extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_group_hooks";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/group_hooks gitlab_group_hooks} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabGroupHooksConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabGroupHooksConfig);
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    private _hooks;
    get hooks(): DataGitlabGroupHooksHooksList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
