import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of this Terraform resource. In the format of `<application_id>`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/application#id DataGitlabApplication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/application gitlab_application}
*/
export declare class DataGitlabApplication extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_application";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/application gitlab_application} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabApplicationConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabApplicationConfig);
    get applicationId(): string;
    get confidential(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    get name(): string;
    get redirectUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
