import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BranchProtectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Can be set to true to allow users with push access to force push.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#allow_force_push BranchProtection#allow_force_push}
    */
    readonly allowForcePush?: boolean | cdktf.IResolvable;
    /**
    * Name of the branch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#branch BranchProtection#branch}
    */
    readonly branch: string;
    /**
    * Can be set to true to require code owner approval before merging. Only available own Premium and Ultimate instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#code_owner_approval_required BranchProtection#code_owner_approval_required}
    */
    readonly codeOwnerApprovalRequired?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#id BranchProtection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Access levels allowed to merge. Valid values are: `no one`, `developer`, `maintainer`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#merge_access_level BranchProtection#merge_access_level}
    */
    readonly mergeAccessLevel?: string;
    /**
    * The id of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#project BranchProtection#project}
    */
    readonly project: string;
    /**
    * Access levels allowed to push. Valid values are: `no one`, `developer`, `maintainer`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#push_access_level BranchProtection#push_access_level}
    */
    readonly pushAccessLevel?: string;
    /**
    * Access levels allowed to unprotect. Valid values are: `no one`, `developer`, `maintainer`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#unprotect_access_level BranchProtection#unprotect_access_level}
    */
    readonly unprotectAccessLevel?: string;
    /**
    * allowed_to_merge block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#allowed_to_merge BranchProtection#allowed_to_merge}
    */
    readonly allowedToMerge?: BranchProtectionAllowedToMerge[] | cdktf.IResolvable;
    /**
    * allowed_to_push block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#allowed_to_push BranchProtection#allowed_to_push}
    */
    readonly allowedToPush?: BranchProtectionAllowedToPush[] | cdktf.IResolvable;
    /**
    * allowed_to_unprotect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#allowed_to_unprotect BranchProtection#allowed_to_unprotect}
    */
    readonly allowedToUnprotect?: BranchProtectionAllowedToUnprotect[] | cdktf.IResolvable;
}
export interface BranchProtectionAllowedToMerge {
    /**
    * The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#group_id BranchProtection#group_id}
    */
    readonly groupId?: number;
    /**
    * The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#user_id BranchProtection#user_id}
    */
    readonly userId?: number;
}
export declare function branchProtectionAllowedToMergeToTerraform(struct?: BranchProtectionAllowedToMerge | cdktf.IResolvable): any;
export declare class BranchProtectionAllowedToMergeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BranchProtectionAllowedToMerge | cdktf.IResolvable | undefined;
    set internalValue(value: BranchProtectionAllowedToMerge | cdktf.IResolvable | undefined);
    get accessLevel(): string;
    get accessLevelDescription(): string;
    private _groupId?;
    get groupId(): number;
    set groupId(value: number);
    resetGroupId(): void;
    get groupIdInput(): number | undefined;
    private _userId?;
    get userId(): number;
    set userId(value: number);
    resetUserId(): void;
    get userIdInput(): number | undefined;
}
export declare class BranchProtectionAllowedToMergeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BranchProtectionAllowedToMerge[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BranchProtectionAllowedToMergeOutputReference;
}
export interface BranchProtectionAllowedToPush {
    /**
    * The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#group_id BranchProtection#group_id}
    */
    readonly groupId?: number;
    /**
    * The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#user_id BranchProtection#user_id}
    */
    readonly userId?: number;
}
export declare function branchProtectionAllowedToPushToTerraform(struct?: BranchProtectionAllowedToPush | cdktf.IResolvable): any;
export declare class BranchProtectionAllowedToPushOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BranchProtectionAllowedToPush | cdktf.IResolvable | undefined;
    set internalValue(value: BranchProtectionAllowedToPush | cdktf.IResolvable | undefined);
    get accessLevel(): string;
    get accessLevelDescription(): string;
    private _groupId?;
    get groupId(): number;
    set groupId(value: number);
    resetGroupId(): void;
    get groupIdInput(): number | undefined;
    private _userId?;
    get userId(): number;
    set userId(value: number);
    resetUserId(): void;
    get userIdInput(): number | undefined;
}
export declare class BranchProtectionAllowedToPushList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BranchProtectionAllowedToPush[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BranchProtectionAllowedToPushOutputReference;
}
export interface BranchProtectionAllowedToUnprotect {
    /**
    * The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#group_id BranchProtection#group_id}
    */
    readonly groupId?: number;
    /**
    * The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection#user_id BranchProtection#user_id}
    */
    readonly userId?: number;
}
export declare function branchProtectionAllowedToUnprotectToTerraform(struct?: BranchProtectionAllowedToUnprotect | cdktf.IResolvable): any;
export declare class BranchProtectionAllowedToUnprotectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BranchProtectionAllowedToUnprotect | cdktf.IResolvable | undefined;
    set internalValue(value: BranchProtectionAllowedToUnprotect | cdktf.IResolvable | undefined);
    get accessLevel(): string;
    get accessLevelDescription(): string;
    private _groupId?;
    get groupId(): number;
    set groupId(value: number);
    resetGroupId(): void;
    get groupIdInput(): number | undefined;
    private _userId?;
    get userId(): number;
    set userId(value: number);
    resetUserId(): void;
    get userIdInput(): number | undefined;
}
export declare class BranchProtectionAllowedToUnprotectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BranchProtectionAllowedToUnprotect[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BranchProtectionAllowedToUnprotectOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection gitlab_branch_protection}
*/
export declare class BranchProtection extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_branch_protection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection gitlab_branch_protection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BranchProtectionConfig
    */
    constructor(scope: Construct, id: string, config: BranchProtectionConfig);
    private _allowForcePush?;
    get allowForcePush(): boolean | cdktf.IResolvable;
    set allowForcePush(value: boolean | cdktf.IResolvable);
    resetAllowForcePush(): void;
    get allowForcePushInput(): boolean | cdktf.IResolvable | undefined;
    private _branch?;
    get branch(): string;
    set branch(value: string);
    get branchInput(): string | undefined;
    get branchProtectionId(): number;
    private _codeOwnerApprovalRequired?;
    get codeOwnerApprovalRequired(): boolean | cdktf.IResolvable;
    set codeOwnerApprovalRequired(value: boolean | cdktf.IResolvable);
    resetCodeOwnerApprovalRequired(): void;
    get codeOwnerApprovalRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mergeAccessLevel?;
    get mergeAccessLevel(): string;
    set mergeAccessLevel(value: string);
    resetMergeAccessLevel(): void;
    get mergeAccessLevelInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _pushAccessLevel?;
    get pushAccessLevel(): string;
    set pushAccessLevel(value: string);
    resetPushAccessLevel(): void;
    get pushAccessLevelInput(): string | undefined;
    private _unprotectAccessLevel?;
    get unprotectAccessLevel(): string;
    set unprotectAccessLevel(value: string);
    resetUnprotectAccessLevel(): void;
    get unprotectAccessLevelInput(): string | undefined;
    private _allowedToMerge;
    get allowedToMerge(): BranchProtectionAllowedToMergeList;
    putAllowedToMerge(value: BranchProtectionAllowedToMerge[] | cdktf.IResolvable): void;
    resetAllowedToMerge(): void;
    get allowedToMergeInput(): cdktf.IResolvable | BranchProtectionAllowedToMerge[] | undefined;
    private _allowedToPush;
    get allowedToPush(): BranchProtectionAllowedToPushList;
    putAllowedToPush(value: BranchProtectionAllowedToPush[] | cdktf.IResolvable): void;
    resetAllowedToPush(): void;
    get allowedToPushInput(): cdktf.IResolvable | BranchProtectionAllowedToPush[] | undefined;
    private _allowedToUnprotect;
    get allowedToUnprotect(): BranchProtectionAllowedToUnprotectList;
    putAllowedToUnprotect(value: BranchProtectionAllowedToUnprotect[] | cdktf.IResolvable): void;
    resetAllowedToUnprotect(): void;
    get allowedToUnprotectInput(): cdktf.IResolvable | BranchProtectionAllowedToUnprotect[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
