import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The application is used where the client secret can be kept confidential. Native mobile apps and Single Page Apps are considered non-confidential. Defaults to true if not supplied
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application#confidential Application#confidential}
    */
    readonly confidential?: boolean | cdktf.IResolvable;
    /**
    * Name of the application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application#name Application#name}
    */
    readonly name: string;
    /**
    * The URL gitlab should send the user to after authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application#redirect_url Application#redirect_url}
    */
    readonly redirectUrl: string;
    /**
    *
                      Scopes of the application. Use "openid" if you plan to use this as an oidc authentication application. Valid options are: `api`, `read_api`, `read_user`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `sudo`, `admin_mode`, `openid`, `profile`, `email`.
  This is only populated when creating a new application. This attribute is not available for imported resources
                      
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/application#scopes Application#scopes}
    */
    readonly scopes: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/application gitlab_application}
*/
export declare class Application extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_application";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/application gitlab_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationConfig);
    get applicationId(): string;
    private _confidential?;
    get confidential(): boolean | cdktf.IResolvable;
    set confidential(value: boolean | cdktf.IResolvable);
    resetConfidential(): void;
    get confidentialInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _redirectUrl?;
    get redirectUrl(): string;
    set redirectUrl(value: string);
    get redirectUrlInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    get secret(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
